/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class TypeCountWriter {
    private final OrcsApi orcsApi;

    public TypeCountWriter(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void write(BranchId branch, Set<Long> newArts, Set<Long> modifiedArts, Set<Long> deletedArts, List<Long> artTypes, List<Long> attrTypes, OutputStream outputStream) {
        try {
            int index;
            Object[] row;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            List<AttributeTypeToken> attributes = this.getAttrTypes(attrTypes);
            Object[] headers = this.getHeaders(attributes);
            int columns = headers.length;
            sheetWriter.startSheet("Type Count Report", headers.length);
            sheetWriter.writeRow(headers);
            List<IArtifactType> artifactTypes = this.getTypes(artTypes);
            if (!newArts.isEmpty()) {
                ResultSet newArtifacts = ((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(artifactTypes)).andUuids(newArts)).getResults();
                for (ArtifactReadable art : newArtifacts) {
                    row = new String[columns];
                    index = 0;
                    row[index++] = art.getName();
                    row[index++] = "NEW";
                    row[index++] = art.getArtifactType().toString();
                    for (AttributeTypeId attributeTypeId : attributes) {
                        row[index++] = art.getAttributeValues(attributeTypeId).toString();
                    }
                    sheetWriter.writeRow(row);
                }
            }
            if (!modifiedArts.isEmpty()) {
                ResultSet modifiedArtifacts = ((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(artifactTypes)).andUuids(modifiedArts)).getResults();
                for (ArtifactReadable art : modifiedArtifacts) {
                    row = new String[columns];
                    index = 0;
                    row[index++] = art.getName();
                    row[index++] = "MODIFIED";
                    row[index++] = art.getArtifactType().toString();
                    for (AttributeTypeId attributeTypeId : attributes) {
                        row[index++] = art.getAttributeValues(attributeTypeId).toString();
                    }
                    sheetWriter.writeRow(row);
                }
            }
            if (!deletedArts.isEmpty()) {
                ResultSet deletedArtifacts = ((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(artifactTypes)).andUuids(deletedArts)).getResults();
                for (ArtifactReadable art : deletedArtifacts) {
                    row = new String[columns];
                    index = 0;
                    row[index++] = art.getName();
                    row[index++] = "DELETED";
                    row[index++] = art.getArtifactType().toString();
                    for (AttributeTypeId attributeTypeId : attributes) {
                        row[index++] = art.getAttributeValues(attributeTypeId).toString();
                    }
                    sheetWriter.writeRow(row);
                }
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private List<IArtifactType> getTypes(List<Long> typeIds) {
        ArrayList<IArtifactType> toReturn = new ArrayList<IArtifactType>();
        Collection allTypes = this.orcsApi.getOrcsTypes().getArtifactTypes().getAll();
        for (IArtifactType type : allTypes) {
            if (!typeIds.contains(type.getGuid())) continue;
            toReturn.add(type);
        }
        return toReturn;
    }

    private List<AttributeTypeToken> getAttrTypes(List<Long> typeIds) {
        ArrayList<AttributeTypeToken> toReturn = new ArrayList<AttributeTypeToken>();
        Collection allTypes = this.orcsApi.getOrcsTypes().getAttributeTypes().getAll();
        for (AttributeTypeToken type : allTypes) {
            if (!typeIds.contains(type.getId())) continue;
            toReturn.add(type);
        }
        return toReturn;
    }

    private String[] getHeaders(List<AttributeTypeToken> types) {
        this.orcsApi.getOrcsTypes().getArtifactTypes().getAll();
        String[] toReturn = new String[types.size() + 3];
        int index = 0;
        toReturn[index++] = "Name";
        toReturn[index++] = "Mod Type";
        toReturn[index++] = "Art Type";
        for (AttributeTypeToken type : types) {
            toReturn[index++] = type.getName();
        }
        return toReturn;
    }
}

