/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="program")
public class ProgramResource
extends AbstractConfigResource {
    @Context
    private UriInfo uriInfo;

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public ProgramResource(IAtsServer atsServer) {
        super(AtsArtifactTypes.Program, atsServer);
    }

    @GET
    @Path(value="{uuid}/insertion")
    @Produces(value={"application/json"})
    public Response getProgramInsertions(@PathParam(value="uuid") long uuid) throws Exception {
        ArtifactReadable programArt = this.atsServer.getArtifact(uuid);
        if (programArt == null) {
            throw new OseeCoreException("Given uuid not found", new Object[0]);
        }
        if (!programArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
            throw new OseeCoreException("Given uuid not program type", new Object[0]);
        }
        ResultSet results = programArt.getRelated(AtsRelationTypes.ProgramToInsertion_Insertion);
        LinkedList<IAtsInsertion> insertions = new LinkedList<IAtsInsertion>();
        for (ArtifactReadable insertion : results) {
            insertions.add(this.atsServer.getConfigItemFactory().getInsertion((ArtifactId)insertion));
        }
        GenericEntity<List<IAtsConfigObject>> entity = new GenericEntity<List<IAtsConfigObject>>(insertions){};
        return Response.ok((Object)entity).build();
    }

    @POST
    @Path(value="{programUuid}/insertion")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createInsertion(@PathParam(value="programUuid") long programUuid, JaxInsertion newInsertion) throws Exception {
        ArtifactReadable programArt = this.atsServer.getArtifact(programUuid);
        if (programArt == null) {
            throw new OseeCoreException("Given uuid not found", new Object[0]);
        }
        if (!programArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
            throw new OseeCoreException("Given uuid not program type", new Object[0]);
        }
        ResultSet results = ((QueryBuilder)this.atsServer.getQuery().andUuid(newInsertion.getUuid().longValue())).getResults();
        if (results.size() != 0) {
            throw new OseeStateException("Insertion with id %d already exists", new Object[]{newInsertion.getUuid()});
        }
        IAtsInsertion created = this.atsServer.getConfigItemFactory().createInsertion((ArtifactId)programArt, newInsertion);
        return this.getResponse((IAtsConfigObject)created);
    }

    @PUT
    @Path(value="{programUuid}/insertion")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateInsertion(@PathParam(value="programUuid") long programUuid, JaxInsertion insertion) {
        ArtifactReadable insertionArt = this.atsServer.getArtifact(insertion.getUuid());
        if (insertionArt == null) {
            throw new OseeCoreException("Given insertion uuid not found", new Object[0]);
        }
        if (!insertionArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            throw new OseeCoreException("Given insertion uuid not insertion type", new Object[0]);
        }
        Response response = null;
        if (!insertionArt.getName().equals(insertion.getName())) {
            IAtsInsertion updated = this.atsServer.getConfigItemFactory().updateInsertion(insertion);
            response = Response.ok().entity((Object)updated).build();
        } else {
            response = Response.notModified().build();
        }
        return response;
    }

    @GET
    @Path(value="{programUuid}/insertion/{uuid}")
    @Produces(value={"application/json"})
    public Response getInsertionDetails(@PathParam(value="programUuid") long programUuid, @PathParam(value="uuid") long uuid) throws Exception {
        ArtifactReadable configArt = this.atsServer.getArtifact(uuid);
        if (configArt == null) {
            throw new OseeCoreException("Given uuid not found", new Object[0]);
        }
        return Response.ok().entity((Object)this.atsServer.getConfigItemFactory().getInsertion((ArtifactId)configArt)).build();
    }

    @DELETE
    @Path(value="{programUuid}/insertion/{insertionUuid}")
    public Response deleteInsertion(@PathParam(value="insertionUuid") long insertionUuid) throws Exception {
        ArtifactReadable insertion = this.atsServer.getArtifact(insertionUuid);
        if (insertion == null) {
            throw new OseeCoreException("Given insertion uuid not found", new Object[0]);
        }
        this.atsServer.getConfigItemFactory().deleteInsertion((ArtifactId)insertion);
        return Response.ok().build();
    }

    @GET
    @Path(value="{programUuid}/insertion/{insertionUuid}/activity")
    @Produces(value={"application/json"})
    public Response getInsertionActivitys(@PathParam(value="programUuid") long programUuid, @PathParam(value="insertionUuid") long insertionUuid) throws Exception {
        ArtifactReadable insertion = this.atsServer.getArtifact(insertionUuid);
        if (insertion == null) {
            throw new OseeCoreException("Given insertion uuid not found", new Object[0]);
        }
        if (!insertion.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            throw new OseeCoreException("Given uuid not insertion type", new Object[0]);
        }
        ResultSet results = insertion.getRelated(AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity);
        LinkedList<IAtsInsertionActivity> insertionActivitys = new LinkedList<IAtsInsertionActivity>();
        for (ArtifactReadable insertionActivity : results) {
            insertionActivitys.add(this.atsServer.getConfigItemFactory().getInsertionActivity((ArtifactId)insertionActivity));
        }
        GenericEntity<List<IAtsConfigObject>> entity = new GenericEntity<List<IAtsConfigObject>>(insertionActivitys){};
        return Response.ok((Object)entity).build();
    }

    @POST
    @Path(value="{programUuid}/insertion/{insertionUuid}/activity")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createInsertionActivity(@PathParam(value="programUuid") long programUuid, @PathParam(value="insertionUuid") long insertionUuid, JaxInsertionActivity newActivity) throws Exception {
        ArtifactReadable insertion = this.atsServer.getArtifact(insertionUuid);
        if (insertion == null) {
            throw new OseeCoreException("Given insertion uuid not found", new Object[0]);
        }
        if (!insertion.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            throw new OseeCoreException("Given uuid not insertion type", new Object[0]);
        }
        ResultSet results = ((QueryBuilder)this.atsServer.getQuery().andUuid(newActivity.getUuid().longValue())).getResults();
        if (results.size() != 0) {
            throw new OseeStateException("Insertion Activity with id %d already exists", new Object[]{newActivity.getUuid()});
        }
        IAtsInsertionActivity created = this.atsServer.getConfigItemFactory().createInsertionActivity((ArtifactId)insertion, newActivity);
        return this.getResponse((IAtsConfigObject)created);
    }

    @PUT
    @Path(value="{programUuid}/insertion/{insertionUuid}/activity")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateInsertionActivity(@PathParam(value="programUuid") long programUuid, @PathParam(value="insertionUuid") long insertionUuid, JaxInsertionActivity newActivity) throws Exception {
        ArtifactReadable insertionActivityArt = this.atsServer.getArtifact(newActivity.getUuid());
        if (insertionActivityArt == null) {
            throw new OseeCoreException("Given insertion activity uuid not found", new Object[0]);
        }
        if (!insertionActivityArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.InsertionActivity})) {
            throw new OseeCoreException("Given insertion activity uuid not insertion activity type", new Object[0]);
        }
        Response response = null;
        if (!insertionActivityArt.getName().equals(newActivity.getName())) {
            IAtsInsertionActivity updated = this.atsServer.getConfigItemFactory().updateInsertionActivity(newActivity);
            response = Response.ok().entity((Object)updated).build();
        } else {
            response = Response.notModified().build();
        }
        return response;
    }

    @GET
    @Path(value="{programUuid}/insertion/{insertionUuid}/activity/{iaUuid}")
    @Produces(value={"application/json"})
    public Response getInsertionActivityDetails(@PathParam(value="programUuid") long programUuid, @PathParam(value="insertionUuid") long insertionUuid, @PathParam(value="iaUuid") long iaUuid) throws Exception {
        ArtifactReadable configArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getQuery().andUuid(iaUuid)).getResults().getExactlyOne();
        return Response.ok().entity((Object)this.atsServer.getConfigItemFactory().getInsertionActivity((ArtifactId)configArt)).build();
    }

    @DELETE
    @Path(value="{programUuid}/insertion/{insertionUuid}/activity/{iaUuid}")
    public Response deleteInsertionActivity(@PathParam(value="iaUuid") long iaUuid) throws Exception {
        ArtifactReadable insertionActivity = (ArtifactReadable)((QueryBuilder)this.atsServer.getQuery().andUuid(iaUuid)).getResults().getExactlyOne();
        this.atsServer.getConfigItemFactory().deleteInsertionActivity((ArtifactId)insertionActivity);
        return Response.ok().build();
    }

    private Response getResponse(IAtsConfigObject config) {
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path(String.valueOf(config.getId())).build(new Object[0]);
        Response response = Response.created((URI)location).entity((Object)config).build();
        return response;
    }
}

