/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.InsertionEndpointApi;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.program.JaxProgram;
import org.eclipse.osee.ats.api.program.ProgramEndpointApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class ProgramEndpointImpl
extends BaseConfigEndpointImpl<JaxProgram>
implements ProgramEndpointApi {
    private final long countryUuid;

    public ProgramEndpointImpl(IAtsServer atsServer) {
        this(atsServer, 0L);
    }

    public ProgramEndpointImpl(IAtsServer atsServer, long countryUuid) {
        super(AtsArtifactTypes.Program, null, atsServer);
        this.countryUuid = countryUuid;
    }

    @PUT
    public Response update(JaxProgram program) throws Exception {
        ArtifactReadable artifact = this.atsServer.getArtifact(program.getUuid());
        if (artifact == null) {
            throw new OseeStateException("Artifact with uuid %d not found", new Object[]{program.getUuid()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactReadable configArtifact = (ArtifactReadable)changes.createArtifact(this.artifactType, program.getName(), GUID.create(), program.getUuid());
        IAtsConfigObject configObject = this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)configArtifact);
        if (!configArtifact.getName().equals(program.getName())) {
            changes.setSoleAttributeValue((IAtsObject)configObject, (AttributeTypeId)CoreAttributeTypes.Name, (Object)program.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + program.getUuid())).build();
    }

    @Override
    public JaxProgram getConfigObject(ArtifactId artifact) {
        JaxProgram jaxProgram = new JaxProgram();
        IAtsProgram program = this.atsServer.getConfigItemFactory().getProgram(artifact);
        jaxProgram.setName(program.getName());
        jaxProgram.setUuid(program.getId());
        jaxProgram.setActive(program.isActive());
        jaxProgram.setDescription(program.getDescription());
        return jaxProgram;
    }

    @Override
    public List<JaxProgram> getObjects() {
        ArrayList<JaxProgram> configs = new ArrayList<JaxProgram>();
        if (this.countryUuid == 0L) {
            for (ArtifactReadable art : ((QueryBuilder)this.atsServer.getQuery().andIsOfType(new ArtifactTypeId[]{this.artifactType})).getResults()) {
                configs.add(this.getConfigObject((ArtifactId)art));
            }
        } else {
            for (ArtifactReadable art : this.atsServer.getArtifact(this.countryUuid).getRelated(AtsRelationTypes.CountryToProgram_Program)) {
                JaxProgram program = this.getConfigObject((ArtifactId)art);
                program.setCountryUuid(this.countryUuid);
                configs.add(program);
            }
        }
        return configs;
    }

    @Override
    protected void create(JaxProgram jaxProgram, ArtifactId programArtId, IAtsChangeSet changes) {
        ArtifactReadable programArt = (ArtifactReadable)programArtId;
        if (programArt.getRelatedCount(AtsRelationTypes.CountryToProgram_Country) == 0) {
            ArtifactReadable countryArt = this.atsServer.getArtifact(jaxProgram.getCountryUuid());
            changes.relate((Object)countryArt, AtsRelationTypes.CountryToProgram_Program, (Object)programArt);
        }
    }

    public InsertionEndpointApi getInsertion(long programUuid) {
        return new InsertionEndpointImpl(this.atsServer, programUuid);
    }
}

