/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.InsertionActivityEndpointApi;
import org.eclipse.osee.ats.api.insertion.InsertionEndpointApi;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class InsertionEndpointImpl
extends BaseConfigEndpointImpl<JaxInsertion>
implements InsertionEndpointApi {
    private final long programUuid;

    public InsertionEndpointImpl(IAtsServer atsServer) {
        this(atsServer, 0L);
    }

    public InsertionEndpointImpl(IAtsServer atsServer, long programUuid) {
        super(AtsArtifactTypes.Insertion, null, atsServer);
        this.programUuid = programUuid;
    }

    @PUT
    public Response update(JaxInsertion insertion) throws Exception {
        ArtifactReadable artifact = this.atsServer.getArtifact(insertion.getUuid());
        if (artifact == null) {
            throw new OseeStateException("Artifact with uuid %d not found", new Object[]{insertion.getUuid()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactReadable configArtifact = (ArtifactReadable)changes.createArtifact(this.artifactType, insertion.getName(), GUID.create(), insertion.getUuid());
        IAtsConfigObject configObject = this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)configArtifact);
        if (!configArtifact.getName().equals(insertion.getName())) {
            changes.setSoleAttributeValue((IAtsObject)configObject, (AttributeTypeId)CoreAttributeTypes.Name, (Object)insertion.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + insertion.getUuid())).build();
    }

    @Override
    public JaxInsertion getConfigObject(ArtifactId artifact) {
        JaxInsertion jaxInsertion = new JaxInsertion();
        IAtsInsertion insertion = this.atsServer.getConfigItemFactory().getInsertion(artifact);
        jaxInsertion.setName(insertion.getName());
        jaxInsertion.setUuid(insertion.getId());
        jaxInsertion.setActive(insertion.isActive());
        jaxInsertion.setDescription(insertion.getDescription());
        return jaxInsertion;
    }

    @Override
    public List<JaxInsertion> getObjects() {
        ArrayList<JaxInsertion> insertions = new ArrayList<JaxInsertion>();
        if (this.programUuid == 0L) {
            for (ArtifactReadable art : ((QueryBuilder)this.atsServer.getQuery().andIsOfType(new ArtifactTypeId[]{this.artifactType})).getResults()) {
                insertions.add(this.getConfigObject((ArtifactId)art));
            }
        } else {
            for (ArtifactReadable insertionArt : this.atsServer.getArtifact(this.programUuid).getRelated(AtsRelationTypes.ProgramToInsertion_Insertion)) {
                JaxInsertion insertion = this.getConfigObject((ArtifactId)insertionArt);
                insertion.setProgramUuid(this.programUuid);
                insertions.add(insertion);
            }
        }
        return insertions;
    }

    @Override
    protected void create(JaxInsertion jaxInsertion, ArtifactId insertionArtId, IAtsChangeSet changes) {
        ArtifactReadable insertionArt = (ArtifactReadable)insertionArtId;
        if (insertionArt.getRelatedCount(AtsRelationTypes.ProgramToInsertion_Program) == 0) {
            ArtifactReadable programArt = this.atsServer.getArtifact(jaxInsertion.getProgramUuid());
            changes.relate((Object)programArt, AtsRelationTypes.ProgramToInsertion_Insertion, (Object)insertionArt);
        }
    }

    public InsertionActivityEndpointApi getInsertionActivity(long insertionUuid) {
        return new InsertionActivityEndpointImpl(this.atsServer, insertionUuid);
    }
}

