/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.insertion.InsertionActivityEndpointApi;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class InsertionActivityEndpointImpl
extends BaseConfigEndpointImpl<JaxInsertionActivity>
implements InsertionActivityEndpointApi {
    private final long insertionUuid;

    public InsertionActivityEndpointImpl(IAtsServer atsServer) {
        this(atsServer, 0L);
    }

    public InsertionActivityEndpointImpl(IAtsServer atsServer, long insertionUuid) {
        super(AtsArtifactTypes.InsertionActivity, null, atsServer);
        this.insertionUuid = insertionUuid;
    }

    @PUT
    public Response update(JaxInsertionActivity activity) throws Exception {
        ArtifactReadable artifact = this.atsServer.getArtifact(activity.getUuid());
        if (artifact == null) {
            throw new OseeStateException("Artifact with uuid %d not found", new Object[]{activity.getUuid()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactReadable configArtifact = (ArtifactReadable)changes.createArtifact(this.artifactType, activity.getName(), GUID.create(), activity.getUuid());
        IAtsConfigObject configObject = this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)configArtifact);
        if (!configArtifact.getName().equals(activity.getName())) {
            changes.setSoleAttributeValue((IAtsObject)configObject, (AttributeTypeId)CoreAttributeTypes.Name, (Object)activity.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + activity.getUuid())).build();
    }

    @Override
    public JaxInsertionActivity getConfigObject(ArtifactId artifact) {
        JaxInsertionActivity jaxInsertion = new JaxInsertionActivity();
        IAtsInsertionActivity insertion = this.atsServer.getConfigItemFactory().getInsertionActivity(artifact);
        jaxInsertion.setName(insertion.getName());
        jaxInsertion.setUuid(insertion.getId());
        jaxInsertion.setActive(insertion.isActive());
        jaxInsertion.setDescription(insertion.getDescription());
        return jaxInsertion;
    }

    @Override
    public List<JaxInsertionActivity> getObjects() {
        ArrayList<JaxInsertionActivity> insertions = new ArrayList<JaxInsertionActivity>();
        if (this.insertionUuid == 0L) {
            for (ArtifactReadable art : ((QueryBuilder)this.atsServer.getQuery().andIsOfType(new ArtifactTypeId[]{this.artifactType})).getResults()) {
                insertions.add(this.getConfigObject((ArtifactId)art));
            }
        } else {
            for (ArtifactReadable activityArt : this.atsServer.getArtifact(this.insertionUuid).getRelated(AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                JaxInsertionActivity activity = this.getConfigObject((ArtifactId)activityArt);
                activity.setInsertionUuid(this.insertionUuid);
                insertions.add(activity);
            }
        }
        return insertions;
    }

    @Override
    protected void create(JaxInsertionActivity jaxInsertionActivity, ArtifactId insertionActivityArtId, IAtsChangeSet changes) {
        ArtifactReadable insertionActivityArt = (ArtifactReadable)insertionActivityArtId;
        if (insertionActivityArt.getRelatedCount(AtsRelationTypes.InsertionToInsertionActivity_Insertion) == 0) {
            ArtifactReadable insertionArt = this.atsServer.getArtifact(jaxInsertionActivity.getInsertionUuid());
            changes.relate((Object)insertionArt, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity, (Object)insertionActivityArt);
        }
    }
}

