/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.country.CountryEndpointApi;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.country.JaxCountry;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.program.ProgramEndpointApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ProgramEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class CountryEndpointImpl
extends BaseConfigEndpointImpl<JaxCountry>
implements CountryEndpointApi {
    public CountryEndpointImpl(IAtsServer atsServer) {
        super(AtsArtifactTypes.Country, AtsArtifactToken.CountryFolder, atsServer);
    }

    public Response update(JaxCountry country) throws Exception {
        ArtifactReadable artifact = this.atsServer.getArtifact(country.getUuid());
        if (artifact == null) {
            throw new OseeStateException("Artifact with uuid %d not found", new Object[]{country.getUuid()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactReadable configArtifact = (ArtifactReadable)changes.createArtifact(this.artifactType, country.getName(), GUID.create(), country.getUuid());
        IAtsConfigObject configObject = this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)configArtifact);
        if (!configArtifact.getName().equals(country.getName())) {
            changes.setSoleAttributeValue((IAtsObject)configObject, (AttributeTypeId)CoreAttributeTypes.Name, (Object)country.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + country.getUuid())).build();
    }

    @Override
    public JaxCountry getConfigObject(ArtifactId artifact) {
        JaxCountry jaxCountry = new JaxCountry();
        IAtsCountry country = this.atsServer.getConfigItemFactory().getCountry(artifact);
        jaxCountry.setName(country.getName());
        jaxCountry.setUuid(country.getId());
        jaxCountry.setActive(country.isActive());
        jaxCountry.setDescription(country.getDescription());
        return jaxCountry;
    }

    @Override
    public List<JaxCountry> getObjects() {
        ArrayList<JaxCountry> configs = new ArrayList<JaxCountry>();
        for (ArtifactReadable art : ((QueryBuilder)this.atsServer.getQuery().andIsOfType(new ArtifactTypeId[]{this.artifactType})).getResults()) {
            configs.add(this.getConfigObject((ArtifactId)art));
        }
        return configs;
    }

    public ProgramEndpointApi getProgram(long countryUuid) {
        return new ProgramEndpointImpl(this.atsServer, countryUuid);
    }
}

