/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Arrays;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.AHTML;

@Path(value="convert")
public final class ConvertResource {
    private final IAtsServer atsServer;

    public ConvertResource(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    @GET
    @Produces(value={"text/html"})
    public ViewModel getStates() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(AHTML.beginMultiColumnTable((int)95, (int)1));
        sb.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Name", "Report", "Run", "Description")));
        for (IAtsDatabaseConversion convert : this.atsServer.getDatabaseConversions()) {
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{convert.getName(), this.getForm(convert.getName(), "report", "REPORT-ONLY"), this.getForm(convert.getName(), "run", "RUN"), AHTML.textToHtml((String)convert.getDescription())}));
        }
        sb.append(AHTML.endMultiColumnTable());
        return new ViewModel("convert.html").param("conversionTable", (Object)sb.toString());
    }

    private String getForm(String convertName, String operation, String buttonLabel) {
        StringBuffer sb = new StringBuffer();
        sb.append("<form method=\"post\" action=\"/ats/convert\" >");
        sb.append("<input type=\"hidden\" name=\"convertName\" value=\"" + convertName + "\"/>");
        sb.append("<input type=\"hidden\" name=\"operation\" value=\"" + operation + "\"/>");
        sb.append("<input type=\"submit\" value=\"" + buttonLabel + "\" /></form>");
        return sb.toString();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public ViewModel createAction(MultivaluedMap<String, String> form, @Context UriInfo uriInfo) throws Exception {
        String convertName = (String)form.getFirst((Object)"convertName");
        String operation = (String)form.getFirst((Object)"operation");
        boolean reportOnly = !operation.equals("run");
        XResultData results = new XResultData(false);
        results.logf("Running [%s] ...\n", new Object[]{convertName});
        for (IAtsDatabaseConversion convert : this.atsServer.getDatabaseConversions()) {
            if (!convert.getName().equals(convertName)) continue;
            convert.run(results, reportOnly, (IAtsServices)this.atsServer);
        }
        if (results.isErrors()) {
            throw new OseeCoreException(results.toString(), new Object[0]);
        }
        return RestUtil.simplePage(convertName, results.toString());
    }
}

