/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.framework.core.util.XResultData;

public class ConvertCreateUpdateAtsConfig
implements IAtsDatabaseConversion {
    private final IAtsServer atsServer;

    public ConvertCreateUpdateAtsConfig(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public void run(XResultData data, boolean reportOnly, IAtsServices services) {
        if (reportOnly) {
            data.log("No REPORT-ONLY available for this conversion.\n");
        } else {
            UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsServer);
            update.createUpdateConfig(data);
            data.log("Complete");
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Updates AtsConfig artifact (optional but recommended conversion)\n\n");
        data.append("This will:\n   - Create AtsConfig artifact, if not created\n   - Create Rule Definitions from support/ruleDefinitions.ats, if not created\n   - Create/Update Views from support/views.json\n   - Create Color Team Column, if not created.\n   - Create/Update Valid State Names\n\nCan be run multiple times without corruption.\nShould be run after each release.");
        return data.toString();
    }

    public String getName() {
        return "Create or Update AtsConfig";
    }
}

