/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonGenerator;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.ConfigJsonWriter;
import org.eclipse.osee.ats.rest.util.JsonFactory;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.data.AttributeTypes;

@Provider
public class ConfigsJsonWriter
implements MessageBodyWriter<Collection<IAtsConfigObject>> {
    private org.codehaus.jackson.JsonFactory jsonFactory;
    private IAtsServer atsServer;

    public void setAtsServer(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public void start() {
        this.jsonFactory = JsonFactory.create();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(Collection<IAtsConfigObject> data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Type t;
        ParameterizedType parameterizedType;
        Type[] actualTypeArgs;
        boolean isWriteable = false;
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && (actualTypeArgs = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (t = actualTypeArgs[0]) instanceof Class) {
            Class clazz = (Class)t;
            isWriteable = IAtsConfigObject.class.isAssignableFrom(clazz);
        }
        return isWriteable;
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AttributeTypes getAttributeTypes() {
        return this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes();
    }

    public void writeTo(Collection<IAtsConfigObject> programs, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createJsonGenerator(entityStream);
            writer.writeStartArray();
            for (IAtsConfigObject program : programs) {
                ConfigJsonWriter.addProgramObject(this.atsServer, (IAtsObject)program, annotations, writer, this.matches(IdentityView.class, annotations), this.getAttributeTypes());
            }
            writer.writeEndArray();
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }
}

