/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.util.JsonFactory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeTypes;

@Provider
public class ConfigJsonWriter
implements MessageBodyWriter<IAtsConfigObject> {
    private org.codehaus.jackson.JsonFactory jsonFactory;
    private IAtsServer atsServer;

    public void setAtsServer(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public void start() {
        this.jsonFactory = JsonFactory.create();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(IAtsConfigObject data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean assignableFrom = IAtsConfigObject.class.isAssignableFrom(type);
        return assignableFrom && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AttributeTypes getAttributeTypes() {
        return this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes();
    }

    public void writeTo(IAtsConfigObject config, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createJsonGenerator(entityStream);
            writer.writeStartArray();
            ConfigJsonWriter.addProgramObject(this.atsServer, (IAtsObject)config, annotations, writer, this.matches(IdentityView.class, annotations), this.getAttributeTypes());
            writer.writeEndArray();
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    public static void addProgramObject(IAtsServer atsServer, IAtsObject atsObject, Annotation[] annotations, JsonGenerator writer, boolean identityView, AttributeTypes attributeTypes) throws IOException, JsonGenerationException, JsonProcessingException {
        ArtifactReadable artifact = (ArtifactReadable)atsObject.getStoreObject();
        writer.writeStartObject();
        writer.writeNumberField("uuid", ConfigJsonWriter.getUuid(atsObject, atsServer).longValue());
        writer.writeStringField("Name", atsObject.getName());
        writer.writeStringField("Description", atsObject.getDescription());
        if (atsObject instanceof IAtsTeamDefinition && !identityView) {
            writer.writeArrayFieldStart("version");
            for (ArtifactReadable verArt : artifact.getRelated(AtsRelationTypes.TeamDefinitionToVersion_Version)) {
                IAtsVersion version = atsServer.getConfigItemFactory().getVersion((ArtifactId)verArt);
                ConfigJsonWriter.addProgramObject(atsServer, (IAtsObject)version, annotations, writer, true, attributeTypes);
            }
            writer.writeEndArray();
        }
        if (atsObject instanceof IAtsVersion) {
            if (!identityView) {
                writer.writeArrayFieldStart("workflow");
                for (ArtifactReadable workArt : artifact.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_Workflow)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, workArt);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsInsertionActivity) {
            IAtsInsertionActivity activity = (IAtsInsertionActivity)atsObject;
            writer.writeBooleanField("Active", activity.isActive());
            if (!identityView) {
                writer.writeArrayFieldStart("insertion");
                for (ArtifactReadable insertion : artifact.getRelated(AtsRelationTypes.InsertionToInsertionActivity_Insertion)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, insertion);
                }
                writer.writeEndArray();
                writer.writeArrayFieldStart("workpackage");
                for (ArtifactReadable workPackage : artifact.getRelated(AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, workPackage);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsInsertion) {
            IAtsInsertion insertion = (IAtsInsertion)atsObject;
            writer.writeBooleanField("Active", insertion.isActive());
            if (!identityView) {
                writer.writeArrayFieldStart("program");
                for (ArtifactReadable program : artifact.getRelated(AtsRelationTypes.ProgramToInsertion_Program)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, program);
                }
                writer.writeEndArray();
                writer.writeArrayFieldStart("insertionactivity");
                for (ArtifactReadable activity : artifact.getRelated(AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, activity);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsProgram) {
            IAtsProgram program = (IAtsProgram)atsObject;
            writer.writeStringField("Namespace", atsServer.getProgramService().getNamespace(program));
            writer.writeBooleanField("Active", program.isActive());
            if (!identityView) {
                writer.writeArrayFieldStart("country");
                for (ArtifactReadable country : artifact.getRelated(AtsRelationTypes.CountryToProgram_Country)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, country);
                }
                writer.writeEndArray();
                writer.writeArrayFieldStart("insertion");
                for (ArtifactReadable insertion : artifact.getRelated(AtsRelationTypes.ProgramToInsertion_Insertion)) {
                    ConfigJsonWriter.addArtifactIdentity(writer, insertion);
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAtsCountry) {
            IAtsCountry country = (IAtsCountry)atsObject;
            if (!identityView) {
                writer.writeArrayFieldStart("programs");
                List programs = atsServer.getProgramService().getPrograms(country);
                for (IAtsProgram program : programs) {
                    writer.writeStartObject();
                    writer.writeNumberField("uuid", program.getId().longValue());
                    writer.writeStringField("Name", program.getName());
                    writer.writeBooleanField("active", program.isActive());
                    writer.writeEndObject();
                }
                writer.writeEndArray();
            }
        } else if (atsObject instanceof IAgileTeam) {
            IAgileTeam team = (IAgileTeam)atsObject;
            writer.writeBooleanField("Active", team.isActive());
            writer.writeStringField("Description", team.getDescription());
            writer.writeArrayFieldStart("featureGroups");
            Collection featureGroups = atsServer.getAgileService().getAgileFeatureGroups(team);
            for (IAgileFeatureGroup group : featureGroups) {
                writer.writeStartObject();
                writer.writeNumberField("uuid", group.getId().longValue());
                writer.writeStringField("Name", group.getName());
                writer.writeBooleanField("active", group.isActive());
                writer.writeEndObject();
            }
            writer.writeEndArray();
            writer.writeArrayFieldStart("sprints");
            Collection agileSprints = atsServer.getAgileService().getAgileSprints(team);
            for (IAgileSprint sprint : agileSprints) {
                writer.writeStartObject();
                writer.writeNumberField("uuid", sprint.getId().longValue());
                writer.writeStringField("Name", sprint.getName());
                writer.writeBooleanField("active", sprint.isActive());
                writer.writeEndObject();
            }
            writer.writeEndArray();
            ArtifactReadable teamArt = atsServer.getArtifact((IAtsObject)team);
            ArtifactReadable backlogArt = (ArtifactReadable)teamArt.getRelated(AtsRelationTypes.AgileTeamToBacklog_Backlog).getAtMostOneOrNull();
            writer.writeStringField("Backlog Uuid", backlogArt != null ? String.valueOf(backlogArt.getId()) : "");
            writer.writeStringField("Backlog", backlogArt != null ? String.valueOf(backlogArt.getName()) : "");
        }
        if (!identityView) {
            ConfigJsonWriter.addAttributeData(writer, attributeTypes, artifact);
        }
        writer.writeEndObject();
    }

    public static void addAttributeData(JsonGenerator writer, AttributeTypes attributeTypes, ArtifactReadable artifact) throws IOException, JsonGenerationException, JsonProcessingException {
        Collection attrTypes = attributeTypes.getAll();
        ResultSet attributes = artifact.getAttributes();
        if (!attributes.isEmpty()) {
            for (AttributeTypeToken attrType : attrTypes) {
                Object value2;
                List attributeValues;
                if (!artifact.isAttributeTypeValid((AttributeTypeId)attrType) || (attributeValues = artifact.getAttributeValues((AttributeTypeId)attrType)).isEmpty()) continue;
                if (attributeValues.size() > 1) {
                    writer.writeArrayFieldStart(attrType.getName());
                    for (Object value2 : attributeValues) {
                        writer.writeObject(value2);
                    }
                    writer.writeEndArray();
                    continue;
                }
                if (attributeValues.size() != 1) continue;
                value2 = attributeValues.iterator().next();
                writer.writeObjectField(attrType.getName(), value2);
            }
        }
    }

    private static void addArtifactIdentity(JsonGenerator writer, ArtifactReadable workArt) throws IOException, JsonGenerationException, JsonProcessingException {
        writer.writeStartObject();
        writer.writeNumberField("uuid", workArt.getId().longValue());
        writer.writeStringField("Name", workArt.getName());
        writer.writeEndObject();
    }

    public static Long getUuid(IAtsObject atsObject, IAtsServices services) {
        long uuid = atsObject.getId();
        if (uuid <= 0L) {
            uuid = ((ArtifactReadable)services.getArtifact(atsObject)).getId();
        }
        return uuid;
    }
}

