/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.BaseConfigEndpointApi;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public abstract class BaseConfigEndpointImpl<T extends JaxAtsObject>
implements BaseConfigEndpointApi<T> {
    protected final IAtsServer atsServer;
    protected final IArtifactType artifactType;
    protected final ArtifactToken typeFolder;

    public BaseConfigEndpointImpl(IArtifactType artifactType, ArtifactToken typeFolder, IAtsServer atsServer) {
        this.artifactType = artifactType;
        this.typeFolder = typeFolder;
        this.atsServer = atsServer;
    }

    @GET
    public List<T> get() throws Exception {
        return this.getObjects();
    }

    @GET
    @Path(value="{uuid}")
    public T get(@PathParam(value="uuid") long uuid) throws Exception {
        return this.getObject(uuid);
    }

    @POST
    public Response create(T jaxAtsObject) throws Exception {
        if (jaxAtsObject.getUuid() <= 0L) {
            throw new OseeStateException("Invalid uuid %d", new Object[0]);
        }
        if (!Strings.isValid((String)jaxAtsObject.getName())) {
            throw new OseeStateException("Invalid name [%d]", new Object[0]);
        }
        ArtifactReadable artifact = this.atsServer.getArtifact(jaxAtsObject.getUuid());
        if (artifact != null) {
            throw new OseeStateException("Artifact with uuid %d already exists", new Object[]{jaxAtsObject.getUuid()});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactToken newArtifact = changes.createArtifact(this.artifactType, jaxAtsObject.getName(), GUID.create(), jaxAtsObject.getUuid());
        IAtsConfigObject newAtsObject = this.atsServer.getConfigItemFactory().getConfigObject((ArtifactId)newArtifact);
        if (this.typeFolder != null) {
            ArtifactReadable typeFolderArtifact = this.atsServer.getArtifact((ArtifactId)this.typeFolder);
            if (typeFolderArtifact == null) {
                typeFolderArtifact = (ArtifactReadable)changes.createArtifact(AtsArtifactToken.CountryFolder);
            }
            if (typeFolderArtifact.getParent() == null) {
                ArtifactReadable headingFolder = this.atsServer.getArtifact((ArtifactId)AtsArtifactToken.HeadingFolder);
                changes.relate((Object)headingFolder, CoreRelationTypes.Default_Hierarchical__Child, (Object)typeFolderArtifact);
            }
            changes.relate((Object)typeFolderArtifact, CoreRelationTypes.Default_Hierarchical__Child, (Object)newArtifact);
        }
        if (Strings.isValid((String)jaxAtsObject.getDescription())) {
            changes.setSoleAttributeValue((IAtsObject)newAtsObject, (AttributeTypeId)AtsAttributeTypes.Description, (Object)jaxAtsObject.getDescription());
        } else {
            changes.deleteAttributes((IAtsObject)newAtsObject, (AttributeTypeId)AtsAttributeTypes.Description);
        }
        changes.setSoleAttributeValue((IAtsObject)newAtsObject, (AttributeTypeId)AtsAttributeTypes.Active, (Object)jaxAtsObject.isActive());
        this.create(jaxAtsObject, (ArtifactId)newArtifact, changes);
        changes.execute();
        return Response.created((URI)new URI("/" + jaxAtsObject.getUuid())).build();
    }

    protected void create(T jaxAtsObject, ArtifactId newArtifact, IAtsChangeSet changes) {
    }

    @DELETE
    public Response delete(@PathParam(value="uuid") long uuid) throws Exception {
        ArtifactReadable artifact = this.atsServer.getArtifact(uuid);
        if (artifact == null) {
            throw new OseeStateException("Artifact with uuid %d not found", new Object[]{uuid});
        }
        IAtsChangeSet changes = this.atsServer.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        changes.deleteArtifact((ArtifactId)artifact);
        changes.execute();
        return Response.ok().build();
    }

    public abstract T getConfigObject(ArtifactId var1);

    protected T getObject(long uuid) {
        ArtifactReadable configArt = (ArtifactReadable)((QueryBuilder)this.atsServer.getQuery().andUuid(uuid)).getResults().getExactlyOne();
        return this.getConfigObject((ArtifactId)configArt);
    }

    public abstract List<T> getObjects();
}

