/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.JaxAtsUser;
import org.eclipse.osee.ats.core.users.AbstractAtsUserService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsUserServiceServerImpl
extends AbstractAtsUserService {
    private OrcsApi orcsApi;
    ArtifactReadable atsAdminArt;
    private Supplier<List<IAtsUser>> usersCache = Suppliers.memoizeWithExpiration(this.getConfigurationsSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public String getCurrentUserId() {
        return SystemUser.OseeSystem.getUserId();
    }

    public boolean isAtsAdmin(IAtsUser user) {
        if (this.atsAdminArt == null) {
            this.atsAdminArt = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.AtsAdmin)).getResults().getAtMostOneOrNull();
        }
        return this.atsAdminArt.areRelated(CoreRelationTypes.User_Grouping__Members, (ArtifactReadable)user.getStoreObject());
    }

    private Supplier<List<IAtsUser>> getConfigurationsSupplier() {
        return new Supplier<List<IAtsUser>>(){

            public List<IAtsUser> get() {
                ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
                for (IAtsUser atsUser : AtsUserServiceServerImpl.this.getUsersFromDb()) {
                    AtsUserServiceServerImpl.this.userIdToAtsUser.put(atsUser.getUserId(), atsUser);
                    AtsUserServiceServerImpl.this.nameToAtsUser.put(atsUser.getName(), atsUser);
                    users.add(atsUser);
                }
                return users;
            }
        };
    }

    private JaxAtsUser createFromArtifact(ArtifactReadable userArt) {
        JaxAtsUser atsUser = new JaxAtsUser();
        atsUser.setName(userArt.getName());
        atsUser.setStoreObject((ArtifactToken)userArt);
        atsUser.setUserId(userArt.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.UserId, ""));
        atsUser.setEmail(userArt.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.Email, ""));
        atsUser.setActive(((Boolean)userArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Active, (Object)true)).booleanValue());
        atsUser.setUuid(userArt.getId());
        return atsUser;
    }

    public List<IAtsUser> getUsers() {
        return (List)this.usersCache.get();
    }

    public List<IAtsUser> getUsersFromDb() {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        for (ArtifactId art : ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})).getResults()) {
            ArtifactReadable userArt = (ArtifactReadable)art;
            JaxAtsUser atsUser = this.createFromArtifact(userArt);
            users.add((IAtsUser)atsUser);
        }
        return users;
    }

    public void reloadCache() {
        this.usersCache = Suppliers.memoizeWithExpiration(this.getConfigurationsSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        super.reloadCache();
    }

    protected IAtsUser loadUserFromDbByUserId(String userId) {
        ArtifactReadable userArt = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})).and((AttributeTypeId)CoreAttributeTypes.UserId, userId, new QueryOption[0])).getResults().getAtMostOneOrNull();
        if (userArt != null) {
            return this.createFromArtifact(userArt);
        }
        return null;
    }

    protected IAtsUser loadUserFromDbByUserName(String name) {
        ArtifactReadable userArt = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})).and((AttributeTypeId)CoreAttributeTypes.Name, name, new QueryOption[0])).getResults().getAtMostOneOrNull();
        if (userArt != null) {
            return this.createFromArtifact(userArt);
        }
        return null;
    }

    protected IAtsUser loadUserByAccountId(Long accountId) {
        JaxAtsUser user = null;
        ArtifactId userArt = (ArtifactId)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(accountId.longValue())).getResults().getAtMostOneOrNull();
        if (userArt != null) {
            user = this.createFromArtifact((ArtifactReadable)userArt);
        }
        return user;
    }

    public IAtsUser getUserByArtifactId(ArtifactId id) {
        ArtifactReadable userArt = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(id)).getResults().getExactlyOne();
        return this.createFromArtifact(userArt);
    }
}

