/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsConfigEndpointApi;
import org.eclipse.osee.ats.api.config.AtsConfiguration;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.config.JaxActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamDefinition;
import org.eclipse.osee.ats.api.config.JaxVersion;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.JaxAtsUser;
import org.eclipse.osee.ats.api.workdef.JaxAtsWorkDef;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.util.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class AtsConfigEndpointImpl
implements AtsConfigEndpointApi {
    private final OrcsApi orcsApi;
    private final IAtsServices services;
    private final Log logger;
    private AtsConfigurations atsConfigurations;
    private final Collection<Long> teamDefIds = new LinkedList<Long>();
    private final Collection<Long> aiIds = new LinkedList<Long>();
    private final long DEFAULT_CONFIG_LOADING_TIME = 1200000L;

    public AtsConfigEndpointImpl(IAtsServices services, OrcsApi orcsApi, Log logger) {
        this.services = services;
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.startAtsConfigurationsReloader();
    }

    private void startAtsConfigurationsReloader() {
        Thread thread = new Thread("ATS Configuration Re-Loader"){

            @Override
            public void run() {
                while (true) {
                    AtsConfigurations configs = AtsConfigEndpointImpl.this.getAtsConfigurationsFromDb();
                    AtsConfigEndpointImpl.this.atsConfigurations = configs;
                    try {
                        long reloadTime = 1200000L;
                        String reloadTimeStr = AtsConfigEndpointImpl.this.services.getConfigValue("server_config_reload_ms");
                        if (Strings.isNumeric((String)reloadTimeStr)) {
                            reloadTime = Long.valueOf(reloadTimeStr);
                        }
                        Thread.sleep(reloadTime);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
    }

    private AtsConfigurations getAtsConfigurationsFromDb() {
        this.teamDefIds.clear();
        this.aiIds.clear();
        ResultSet artifacts = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.Configuration})).getResults();
        AtsConfigurations configs = new AtsConfigurations();
        for (ArtifactReadable art : artifacts) {
            AtsConfiguration config = new AtsConfiguration();
            configs.getConfigs().add(config);
            config.setName(art.getName());
            config.setUuid(art.getId().longValue());
            config.setBranchUuid(Long.valueOf((String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.AtsConfiguredBranch, (Object)"0L")).longValue());
            config.setIsDefault(((Boolean)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Default, (Object)false)).booleanValue());
        }
        UpdateAtsConfiguration update = new UpdateAtsConfiguration((IAtsServer)this.services);
        AtsViews views = update.getConfigViews();
        configs.setViews(views);
        configs.setColorColumns(update.getColorColumns());
        configs.setValidStateNames(update.getValidStateNames());
        for (IAtsUser user : this.services.getUserService().getUsersFromDb()) {
            configs.getUsers().add((JaxAtsUser)user);
        }
        ArtifactReadable atsAdminArt = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.services.getAtsBranch()).andIds((ArtifactId)AtsArtifactToken.AtsAdmin)).getResults().getAtMostOneOrNull();
        if (atsAdminArt != null) {
            for (ArtifactReadable member : atsAdminArt.getRelated(CoreRelationTypes.Users_User)) {
                configs.getAtsAdmins().add(member.getId());
            }
        }
        HashMap<Long, ArtifactReadable> idToArtifact = new HashMap<Long, ArtifactReadable>();
        List configArts = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.services.getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition, AtsArtifactTypes.Version, AtsArtifactTypes.ActionableItem})).getResults().getList();
        for (ArtifactReadable configArtId : configArts) {
            if (this.services.getStoreService().isOfType((ArtifactId)configArtId, new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                JaxTeamDefinition teamDef = this.createJaxTeamDefinition(configArtId);
                configs.addTeamDef(teamDef);
            } else if (this.services.getStoreService().isOfType((ArtifactId)configArtId, new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
                JaxActionableItem ai = this.createJaxActionableItem(configArtId);
                configs.addAi(ai);
            } else if (this.services.getStoreService().isOfType((ArtifactId)configArtId, new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
                JaxVersion version = this.createJaxVersion(configArtId);
                configs.addVersion(version);
            }
            idToArtifact.put(configArtId.getId(), configArtId);
        }
        JaxTeamDefinition topJaxTeamDef = this.addTeamDefinitionChildrenWIthRecurse(AtsArtifactToken.TopTeamDefinition.getId(), idToArtifact, configs);
        configs.setTopTeamDefinition(topJaxTeamDef.getUuid());
        JaxActionableItem topJaxAi = this.addActionableItemChildrenWIthRecurse(AtsArtifactToken.TopActionableItem.getId(), idToArtifact, configs);
        configs.setTopActionableItem(topJaxAi.getUuid());
        for (ArtifactToken workDefArt : ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.services.getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkDefinition})).getResults()) {
            String workDefStr = this.services.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)workDefArt, (AttributeTypeId)AtsAttributeTypes.DslSheet, "");
            configs.addWorkDefinition(workDefArt.getName(), workDefStr);
        }
        return configs;
    }

    private JaxActionableItem addActionableItemChildrenWIthRecurse(Long aiId, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs) {
        ArtifactReadable aiArt = idToArtifact.get(aiId);
        if (aiArt != null && aiArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
            JaxActionableItem jaxAi = (JaxActionableItem)configs.getIdToAi().get(aiId);
            for (Long childId : aiArt.getChildrentIds()) {
                JaxActionableItem child;
                if (!this.isActionableItemId(childId) || (child = this.addActionableItemChildrenWIthRecurse(childId, idToArtifact, configs)) == null) continue;
                child.setParentId(aiId);
                jaxAi.addChild(child);
            }
            return jaxAi;
        }
        return null;
    }

    private JaxTeamDefinition addTeamDefinitionChildrenWIthRecurse(Long teamDefId, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs) {
        ArtifactReadable teamDef = idToArtifact.get(teamDefId);
        if (teamDef != null && teamDef.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
            JaxTeamDefinition jaxTeamDef = (JaxTeamDefinition)configs.getIdToTeamDef().get(teamDefId);
            for (Long childId : teamDef.getChildrentIds()) {
                JaxTeamDefinition child;
                if (!this.isTeamDefinitionId(childId) || (child = this.addTeamDefinitionChildrenWIthRecurse(childId, idToArtifact, configs)) == null) continue;
                child.setParentId(teamDefId);
                jaxTeamDef.addChild(child);
            }
            for (Long versionId : this.services.getRelationResolver().getRelatedIds((ArtifactId)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version)) {
                jaxTeamDef.addVersion(versionId);
                JaxVersion version = (JaxVersion)configs.getIdToVersion().get(versionId);
                version.setTeamDefId(teamDefId);
            }
            for (Long aiId : this.services.getRelationResolver().getRelatedIds((ArtifactId)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem)) {
                jaxTeamDef.addAi(aiId);
                JaxActionableItem jai = (JaxActionableItem)configs.getIdToAi().get(aiId);
                jai.setTeamDefId(teamDefId);
            }
            return jaxTeamDef;
        }
        return null;
    }

    private boolean isTeamDefinitionId(Long childId) {
        if (this.teamDefIds.isEmpty()) {
            for (ArtifactId art : this.services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.TeamDefinition}).getItemIds()) {
                this.teamDefIds.add(art.getId());
            }
        }
        return this.teamDefIds.contains(childId);
    }

    private boolean isActionableItemId(Long childId) {
        if (this.aiIds.isEmpty()) {
            for (ArtifactId art : this.services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.ActionableItem}).getItemIds()) {
                this.aiIds.add(art.getId());
            }
        }
        return this.aiIds.contains(childId);
    }

    private JaxVersion createJaxVersion(ArtifactReadable verArt) {
        JaxVersion jaxVersion = new JaxVersion();
        jaxVersion.setName(verArt.getName());
        jaxVersion.setUuid(verArt.getId());
        jaxVersion.setGuid((String)verArt.getGuid());
        jaxVersion.setActive(((Boolean)verArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        return jaxVersion;
    }

    private JaxActionableItem createJaxActionableItem(ArtifactReadable aiArt) {
        JaxActionableItem jaxAi = new JaxActionableItem();
        jaxAi.setName(aiArt.getName());
        jaxAi.setUuid(aiArt.getId());
        jaxAi.setGuid((String)aiArt.getGuid());
        jaxAi.setDescription((String)aiArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Description, (Object)""));
        jaxAi.setActive(((Boolean)aiArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        return jaxAi;
    }

    private JaxTeamDefinition createJaxTeamDefinition(ArtifactReadable teamDefArt) {
        JaxTeamDefinition jaxTeamDef = new JaxTeamDefinition();
        jaxTeamDef.setName(teamDefArt.getName());
        jaxTeamDef.setUuid(teamDefArt.getId());
        jaxTeamDef.setGuid((String)teamDefArt.getGuid());
        jaxTeamDef.setActive(((Boolean)teamDefArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue());
        for (ArtifactToken ai : this.services.getRelationResolver().getRelated((ArtifactId)teamDefArt, AtsRelationTypes.TeamActionableItem_ActionableItem)) {
            jaxTeamDef.getAis().add(ai.getId());
        }
        return jaxTeamDef;
    }

    @GET
    @Path(value="clearcache")
    @Produces(value={"application/json"})
    public String clearCaches() {
        this.atsConfigurations = null;
        Thread thread = new Thread(){

            @Override
            public void run() {
                super.run();
                AtsConfigEndpointImpl.this.get();
            }
        };
        thread.start();
        return "Complete";
    }

    @GET
    @Produces(value={"application/json"})
    public AtsConfigurations get() {
        if (this.atsConfigurations == null) {
            this.atsConfigurations = this.getAtsConfigurationsFromDb();
        }
        return this.atsConfigurations;
    }

    @GET
    @Path(value="fromdb")
    @Produces(value={"application/json"})
    public AtsConfigurations getFromDb() {
        return this.getAtsConfigurationsFromDb();
    }

    @GET
    @Path(value="ui/NewAtsBranchConfig")
    public ViewModel getNewSource() throws Exception {
        return new ViewModel("templates/newConfigBranch.html");
    }

    @POST
    @Path(value="branch")
    public AtsConfiguration createConfig(MultivaluedMap<String, String> form, @Context UriInfo uriInfo) {
        BranchReadable newBranch;
        String query = uriInfo.getPath();
        System.out.println("query [" + query + "]");
        BranchId fromBranchUuid = BranchId.valueOf((String)((String)form.getFirst((Object)"fromBranchUuid")));
        String newBranchName = (String)form.getFirst((Object)"newBranchName");
        Conditions.checkNotNullOrEmpty((String)newBranchName, (String)"newBranchName");
        String userId = (String)form.getFirst((Object)"userId");
        Conditions.checkNotNullOrEmpty((String)userId, (String)"UserId");
        ArtifactToken user = this.services.getUserService().getUserById(userId).getStoreObject();
        if (user == null) {
            this.logger.error("User by id [%s] does not exist", new Object[]{userId});
        }
        BranchReadable fromBranch = (BranchReadable)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(fromBranchUuid)).getResults().getExactlyOne();
        Callable newBranchCallable = this.orcsApi.getBranchOps().createTopLevelBranch(IOseeBranch.create((String)newBranchName), (ArtifactId)user);
        try {
            newBranch = (BranchReadable)newBranchCallable.call();
        }
        catch (Exception ex) {
            throw new OseeWebApplicationException((Throwable)ex, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Error creating new branch", new Object[0]);
        }
        long newBranchUuid = newBranch.getUuid();
        this.introduceAtsHeadingArtifacts(fromBranch, newBranch, (ArtifactId)user);
        AtsConfiguration config = this.createConfigArtifactOnCommon(newBranchName, (ArtifactId)user, newBranchUuid);
        return config;
    }

    private void introduceAtsHeadingArtifacts(BranchReadable fromBranch, BranchReadable newBranch, ArtifactId userArt) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)newBranch, userArt, "Add ATS Configuration");
        ArtifactId headingArt = this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.HeadingFolder, newBranch, CoreArtifactTokens.DefaultHierarchyRoot, null);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.TopActionableItem, newBranch, null, headingArt);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.TopTeamDefinition, newBranch, null, headingArt);
        ArtifactId configArt = this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.ConfigFolder, newBranch, null, headingArt);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.ConfigsFolder, newBranch, null, configArt);
        ArtifactId workDefFolder = this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDefinitionsFolder, newBranch, null, headingArt);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.Users, newBranch, null, configArt);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDef_Goal, newBranch, null, workDefFolder);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDef_Review_Decision, newBranch, null, workDefFolder);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDef_Review_PeerToPeer, newBranch, null, workDefFolder);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDef_Task_Default, newBranch, null, workDefFolder);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDef_Team_Default, newBranch, null, workDefFolder);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.WorkDef_Team_Simple, newBranch, null, workDefFolder);
        tx.commit();
    }

    private ArtifactId introduceAndRelateTo(TransactionBuilder tx, BranchReadable fromBranch, ArtifactToken introToken, BranchReadable newBranch, ArtifactToken relateToToken, ArtifactId relateToArt) {
        ArtifactReadable introArt = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)fromBranch).andIds((ArtifactId)introToken)).getResults().getAtMostOneOrNull();
        if (introArt == null) {
            introArt = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)fromBranch).andTypeEquals(new ArtifactTypeId[]{introToken.getArtifactType()})).andNameEquals(introToken.getName())).getResults().getAtMostOneOrNull();
        }
        Conditions.checkNotNull((Object)introArt, (String)("No artifact found for token " + introToken));
        ArtifactToken artifact = tx.introduceArtifact((BranchId)fromBranch, (ArtifactId)introArt);
        if (relateToToken != null && (relateToArt = (ArtifactId)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)newBranch).andIds((ArtifactId)relateToToken)).getResults().getAtMostOneOrNull()) == null) {
            relateToArt = (ArtifactId)((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)newBranch).andTypeEquals(new ArtifactTypeId[]{relateToToken.getArtifactType()})).andNameEquals(relateToToken.getName())).getResults().getAtMostOneOrNull();
        }
        tx.addChildren(relateToArt, new ArtifactId[]{artifact});
        return artifact;
    }

    private AtsConfiguration createConfigArtifactOnCommon(String branchName, ArtifactId userArt, long newBranchUuid) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userArt, "Add ATS Configuration");
        AtsConfiguration config = new AtsConfiguration();
        config.setName(branchName);
        config.setBranchUuid(newBranchUuid);
        config.setIsDefault(false);
        ArtifactToken configArt = tx.createArtifact(AtsArtifactTypes.Configuration, branchName);
        config.setUuid(((ArtifactReadable)configArt).getId().longValue());
        tx.createAttribute((ArtifactId)configArt, (AttributeTypeId)AtsAttributeTypes.AtsConfiguredBranch, (Object)String.valueOf(newBranchUuid));
        XResultData rd = new XResultData();
        UpdateAtsConfiguration update = new UpdateAtsConfiguration((IAtsServer)this.services);
        ArtifactId configsFolderArt = update.getOrCreateConfigsFolder(userArt, rd);
        if (rd.isErrors()) {
            throw new OseeStateException(rd.toString(), new Object[0]);
        }
        tx.relate(configsFolderArt, (IRelationType)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)configArt);
        tx.commit();
        return config;
    }

    @POST
    public Response createUpdateConfig() {
        XResultData resultData = new XResultData(false);
        UpdateAtsConfiguration update = new UpdateAtsConfiguration((IAtsServer)this.services);
        update.createUpdateConfig(resultData);
        if (resultData.isEmpty()) {
            resultData.log("Nothing to update");
        }
        return Response.ok((Object)resultData.toString()).build();
    }

    @PUT
    @Path(value="workDef")
    public Response storeWorkDef(JaxAtsWorkDef jaxWorkDef) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (ArtifactId)this.services.getArtifact((IAtsObject)AtsCoreUsers.SYSTEM_USER), "Store Work Definition " + jaxWorkDef.getName());
        ArtifactReadable workDefArt = (ArtifactReadable)((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.services.getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.WorkDefinition})).andNameEquals(jaxWorkDef.getName())).getResults().getAtMostOneOrNull();
        if (workDefArt == null) {
            workDefArt = (ArtifactReadable)tx.createArtifact(AtsArtifactTypes.WorkDefinition, jaxWorkDef.getName());
        }
        tx.setSoleAttributeValue((ArtifactId)workDefArt, (AttributeTypeId)AtsAttributeTypes.DslSheet, (Object)jaxWorkDef.getWorkDefDsl());
        if (workDefArt.getParent() == null) {
            ArtifactReadable workDefFolder = (ArtifactReadable)this.services.getArtifact((ArtifactId)AtsArtifactToken.WorkDefinitionsFolder);
            tx.addChildren((ArtifactId)workDefFolder, new ArtifactId[]{workDefArt});
        }
        tx.commit();
        ((IAtsServer)this.services).getWorkDefAdmin().clearCaches();
        return Response.ok().build();
    }

    public List<AtsAttributeValueColumn> generateAttrTypeViews() throws Exception {
        HashMap<String, AttributeTypeToken> idToToken = new HashMap<String, AttributeTypeToken>();
        IAtsServer atsServer = (IAtsServer)this.services;
        for (AttributeTypeToken attrType : atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().getAll()) {
            idToToken.put(attrType.getName(), attrType);
        }
        LinkedList sortedIds = new LinkedList();
        sortedIds.addAll(idToToken.keySet());
        Collections.sort(sortedIds);
        LinkedList<AtsAttributeValueColumn> columns = new LinkedList<AtsAttributeValueColumn>();
        for (String id : sortedIds) {
            AttributeTypeToken attrType = (AttributeTypeToken)idToToken.get(id);
            ColumnAlign columnAlign = ColumnAlign.Left;
            SortDataType sortDataType = SortDataType.String;
            int width = 60;
            boolean isBoolean = atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().isBooleanType((AttributeTypeId)attrType);
            if (atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().isEnumerated((AttributeTypeId)attrType)) {
                width = 40;
            } else if (isBoolean) {
                width = 50;
            } else if (atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().isIntegerType((AttributeTypeId)attrType)) {
                width = 45;
                sortDataType = SortDataType.Integer;
                columnAlign = ColumnAlign.Center;
            } else if (atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().isFloatingType((AttributeTypeId)attrType)) {
                width = 40;
                sortDataType = SortDataType.Float;
                columnAlign = ColumnAlign.Center;
            } else if (atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().isDateType((AttributeTypeId)attrType)) {
                width = 80;
                sortDataType = SortDataType.Date;
            }
            AtsAttributeValueColumn valueColumn = new AtsAttributeValueColumn();
            valueColumn.setAttrTypeId(attrType.getId().longValue());
            valueColumn.setAttrTypeName(attrType.getName());
            valueColumn.setWidth(width);
            valueColumn.setAlign(columnAlign);
            valueColumn.setVisible(true);
            valueColumn.setSortDataType(sortDataType.name());
            valueColumn.setColumnMultiEdit(true);
            valueColumn.setDescription(attrType.getDescription());
            valueColumn.setNamespace("org.eclipse.osee.ats.WorldXViewer");
            String name = attrType.getName().replaceAll("^.*\\.", "");
            valueColumn.setName(name);
            valueColumn.setId(this.generateId(attrType.getName(), name));
            if (isBoolean) {
                valueColumn.setBooleanNotSetShow("");
                valueColumn.setBooleanOnFalseShow("false");
                valueColumn.setBooleanOnTrueShow("true");
            }
            columns.add(valueColumn);
        }
        return columns;
    }

    private String generateId(String id, String name) {
        System.err.println(String.format("\nid [%s] name [%s]", id, name));
        String cleanName = name.replaceAll("-", " ");
        cleanName = cleanName.replaceAll("\\(", " ");
        cleanName = cleanName.replaceAll("\\)", " ");
        cleanName = cleanName.replaceAll("/", " ");
        cleanName = cleanName.replaceAll(" +", " ");
        cleanName = cleanName.replaceAll("^ ", "");
        System.err.println(String.format("cleanName [%s]", cleanName));
        String replaceValue = Lib.toCamelCaseFromStringsWithSpaces((String)cleanName);
        System.err.println(String.format("replaceValue [%s]", replaceValue));
        String result = id.replaceFirst(Lib.escapeForRegex((String)name), replaceValue);
        System.err.println(String.format("result [%s]", result));
        return result;
    }
}

