/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile;

import java.sql.Date;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.AgileBurndown;
import org.eclipse.osee.ats.api.agile.AgileBurndownDate;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class SprintBurndownDataBuilder {
    private static final String ART_ID_ADDED_TO_SPRINT_QUERY = "select rel.B_ART_ID, rel.GAMMA_ID, txd.TIME from OSEE_RELATION_LINK rel, osee_txs txs, osee_tx_details txd where rel.A_ART_ID = ? and rel.REL_LINK_TYPE_ID = 988214123009313457 and rel.B_ART_ID in (ART_IDS) and txs.BRANCH_ID = ? and txs.TX_CURRENT = 1 and rel.GAMMA_ID = txs.GAMMA_ID and txs.TRANSACTION_ID = txd.TRANSACTION_ID";
    private final IAtsServer atsServer;
    private final IAgileSprint sprint;
    private final IAgileTeam agileTeam;
    private final JdbcService jdbcService;

    public SprintBurndownDataBuilder(IAgileTeam agileTeam, IAgileSprint sprint, IAtsServer atsServer, JdbcService jdbcService) {
        this.agileTeam = agileTeam;
        this.sprint = sprint;
        this.atsServer = atsServer;
        this.jdbcService = jdbcService;
    }

    public AgileBurndown get() {
        AgileBurndown burn = new AgileBurndown();
        try {
            ArtifactReadable sprintArt = (ArtifactReadable)this.sprint.getStoreObject();
            burn.setSprintName(sprintArt.getName());
            burn.setAgileTeamName(this.agileTeam.getName());
            java.util.Date startDate = (java.util.Date)sprintArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.StartDate, null);
            if (startDate == null) {
                burn.setError("Start Date must be set on Sprint");
                return burn;
            }
            startDate = this.clearTimeComponent(startDate);
            burn.setStartDate(startDate);
            java.util.Date endDate = (java.util.Date)sprintArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.EndDate, null);
            if (endDate == null) {
                burn.setError("End Date must be set on Sprint");
                return burn;
            }
            endDate = this.clearTimeComponent(endDate);
            burn.setEndDate(endDate);
            burn.setHolidays(sprintArt.getAttributeValues((AttributeTypeId)AtsAttributeTypes.Holiday));
            Integer unPlannedPoints = (Integer)sprintArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.UnPlannedPoints, (Object)0);
            burn.setUnPlannedPoints(unPlannedPoints);
            Integer plannedPoints = (Integer)sprintArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PlannedPoints, (Object)0);
            burn.setPlannedPoints(plannedPoints);
            burn.setPointsAttrTypeName((String)this.atsServer.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.agileTeam, (AttributeTypeId)AtsAttributeTypes.PointsAttributeType, (Object)AtsAttributeTypes.Points.getName()));
            int totalPoints = unPlannedPoints + plannedPoints;
            long oneDay = 86400000L;
            if (startDate != null && endDate != null) {
                java.util.Date date = startDate;
                while (date.before(endDate) || date.equals(endDate)) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(date);
                    if (c.get(7) != 7 && c.get(7) != 1 && !this.isHoliday(date, burn.getHolidays())) {
                        AgileBurndownDate bdDate = new AgileBurndownDate();
                        bdDate.setDate(date);
                        burn.getDates().add(bdDate);
                    }
                    date = new java.util.Date(date.getTime() + oneDay);
                }
            }
            Collection items = this.atsServer.getAgileService().getItems(this.sprint);
            this.computeGoal(burn, totalPoints);
            java.util.Date today = new java.util.Date();
            Map<Long, java.util.Date> artIdToWalkupDate = this.retrieveWalkupAddedDate(this.sprint.getId(), items);
            for (IAgileItem item : items) {
                boolean completed = item.isCompletedOrCancelled();
                boolean unPlanned = (Boolean)this.atsServer.getAttributeResolver().getSoleAttributeValue((IAtsObject)item, (AttributeTypeId)AtsAttributeTypes.UnPlannedWork, (Object)false);
                java.util.Date completedCancelledDate = item.isCompleted() ? item.getCompletedDate() : item.getCancelledDate();
                for (AgileBurndownDate dateBucket : burn.getDates()) {
                    boolean walkupCompletedAfterDateBucket;
                    if (completed) {
                        if (completed && dateBucket.getDate().after(today)) {
                            dateBucket.setCompletedPlannedPoints(null);
                            dateBucket.setCompletedPoints(null);
                            dateBucket.setCompletedUnPlannedPoints(null);
                        } else if (completed && dateBucket.getDate().after(completedCancelledDate)) {
                            double points = this.getPoints(burn, item);
                            if (unPlanned) {
                                java.util.Date walkupAdded = artIdToWalkupDate.get(item.getId());
                                if (dateBucket.getDate().after(walkupAdded)) {
                                    if (dateBucket.getCompletedUnPlannedPoints() != null) {
                                        dateBucket.setCompletedUnPlannedPoints(Double.valueOf(dateBucket.getCompletedUnPlannedPoints() + points));
                                    } else {
                                        dateBucket.setCompletedUnPlannedPoints(Double.valueOf(points));
                                    }
                                }
                            } else if (dateBucket.getCompletedPlannedPoints() != null) {
                                dateBucket.setCompletedPlannedPoints(Double.valueOf(dateBucket.getCompletedPlannedPoints() + points));
                            } else {
                                dateBucket.setCompletedPlannedPoints(Double.valueOf(points));
                            }
                        }
                    }
                    if (!unPlanned) continue;
                    java.util.Date walkupAdded = artIdToWalkupDate.get(item.getId());
                    boolean walkupAddedBeforeDateBucket = walkupAdded.before(dateBucket.getDate());
                    boolean bl = walkupCompletedAfterDateBucket = completed ? completedCancelledDate.after(dateBucket.getDate()) : false;
                    if (!walkupAddedBeforeDateBucket || completed && !walkupCompletedAfterDateBucket) continue;
                    double points = this.getPoints(burn, item);
                    if (dateBucket.getInCompletedUnPlannedPoints() != null) {
                        dateBucket.setInCompletedUnPlannedPoints(Double.valueOf(dateBucket.getInCompletedUnPlannedPoints() + points));
                        continue;
                    }
                    dateBucket.setInCompletedUnPlannedPoints(Double.valueOf(points));
                }
            }
            this.computeCompleted(burn);
            this.computeUnrealizedWalkup(burn);
        }
        catch (Exception ex) {
            burn.setError("Error generating burndown data: \n\n" + Lib.exceptionToString((Exception)ex));
        }
        return burn;
    }

    private void computeCompleted(AgileBurndown burn) {
        for (AgileBurndownDate date : burn.getDates()) {
            double completed;
            Double copmletedPlannedPoints;
            Double completedUnPlannedPoints = date.getCompletedUnPlannedPoints();
            if (completedUnPlannedPoints == null) {
                completedUnPlannedPoints = 0.0;
            }
            if ((copmletedPlannedPoints = date.getCompletedPlannedPoints()) == null) {
                copmletedPlannedPoints = 0.0;
            }
            if ((completed = completedUnPlannedPoints + copmletedPlannedPoints) < 0.0) {
                completed = 0.0;
            }
            date.setCompletedPoints(Double.valueOf(completed));
        }
    }

    private void computeUnrealizedWalkup(AgileBurndown burn) {
        for (AgileBurndownDate date : burn.getDates()) {
            double unRealizedWalkup;
            Double inCompleteUnPlannedPoints;
            Double completedUnPlannedPoints = date.getCompletedUnPlannedPoints();
            if (completedUnPlannedPoints == null) {
                completedUnPlannedPoints = 0.0;
            }
            if ((inCompleteUnPlannedPoints = date.getInCompletedUnPlannedPoints()) == null) {
                inCompleteUnPlannedPoints = 0.0;
            }
            if ((unRealizedWalkup = (double)burn.getUnPlannedPoints().intValue() - completedUnPlannedPoints - inCompleteUnPlannedPoints) < 0.0) {
                unRealizedWalkup = 0.0;
            }
            date.setUnRealizedWalkup(Double.valueOf(unRealizedWalkup));
        }
    }

    private Map<Long, java.util.Date> retrieveWalkupAddedDate(Long sprintId, Collection<IAgileItem> items) {
        LinkedList<Long> artIds = new LinkedList<Long>();
        for (IAgileItem item : items) {
            boolean unPlanned = (Boolean)this.atsServer.getAttributeResolver().getSoleAttributeValue((IAtsObject)item, (AttributeTypeId)AtsAttributeTypes.UnPlannedWork, (Object)false);
            if (!unPlanned) continue;
            artIds.add(item.getId());
        }
        JdbcStatement chStmt = this.jdbcService.getClient().getStatement();
        HashMap<Long, java.util.Date> artIdToWalkupDate = new HashMap<Long, java.util.Date>();
        String artIdsStr = Collections.toString((String)",", artIds);
        try {
            try {
                String query = ART_ID_ADDED_TO_SPRINT_QUERY.replaceFirst("ART_IDS", artIdsStr);
                chStmt.runPreparedQuery(query, new Object[]{sprintId, this.atsServer.getAtsBranch().getId()});
                while (chStmt.next()) {
                    long artId = chStmt.getLong("B_ART_ID");
                    Date date = chStmt.getDate("time");
                    artIdToWalkupDate.put(artId, date);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                chStmt.close();
            }
        }
        finally {
            chStmt.close();
        }
        return artIdToWalkupDate;
    }

    private java.util.Date clearTimeComponent(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        cal.set(9, 1);
        return cal.getTime();
    }

    private double getPoints(AgileBurndown burn, IAgileItem item) {
        AttributeTypeId pointsType = this.atsServer.getOrcsApi().getOrcsTypes().getAttributeTypes().getByName(burn.getPointsAttrTypeName());
        String value = this.atsServer.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)item, pointsType, "");
        if (Strings.isNumeric((String)value)) {
            return Double.valueOf(value);
        }
        return 0.0;
    }

    private void computeGoal(AgileBurndown burn, int totalPoints) {
        int numDates = burn.getDates().size();
        int count = 1;
        int numWorkDays = numDates - 2;
        double pointsPerDay = totalPoints / numWorkDays;
        for (AgileBurndownDate date : burn.getDates()) {
            if (count == 1 || count == 2) {
                date.setGoalPoints(Double.valueOf(totalPoints));
            } else if (count == numDates) {
                date.setGoalPoints(Double.valueOf(0.0));
            } else {
                double goalPoints = (double)totalPoints - (double)count * pointsPerDay;
                if (goalPoints < 0.0) {
                    goalPoints = 0.0;
                }
                date.setGoalPoints(Double.valueOf(goalPoints));
            }
            ++count;
        }
    }

    private boolean isHoliday(java.util.Date date, List<java.util.Date> holidays) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        for (java.util.Date holiday : holidays) {
            boolean sameDay;
            Calendar holCal = Calendar.getInstance();
            holCal.setTime(holiday);
            boolean bl = sameDay = dateCal.get(1) == holCal.get(1) && dateCal.get(6) == holCal.get(6);
            if (!sameDay) continue;
            return true;
        }
        return false;
    }
}

