/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileBurndown;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.AgileItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxBurndownExcel;
import org.eclipse.osee.ats.api.agile.JaxNewAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxNewAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.JaxAtsObjects;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.agile.SprintBurndownDataBuilder;
import org.eclipse.osee.ats.rest.internal.agile.SprintBurndownPageBuilder;
import org.eclipse.osee.ats.rest.internal.agile.SprintPageBuilder;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.ats.rest.internal.world.WorldResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ClassBasedResourceToken;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.template.engine.PageCreator;
import org.eclipse.osee.template.engine.PageFactory;

public class AgileEndpointImpl
implements AgileEndpointApi {
    @Context
    private UriInfo uriInfo;
    private final IAtsServer atsServer;
    private final IResourceRegistry resourceRegistry;
    private static ObjectMapper mapper;
    private final JdbcService jdbcService;

    public AgileEndpointImpl(IAtsServer atsServer, IResourceRegistry resourceRegistry, JdbcService jdbcService) {
        this.atsServer = atsServer;
        this.resourceRegistry = resourceRegistry;
        this.jdbcService = jdbcService;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public String get() {
        return "Agile Resource";
    }

    public List<JaxAgileTeam> team() throws Exception {
        ArrayList<JaxAgileTeam> teams = new ArrayList<JaxAgileTeam>();
        for (IAgileTeam team : this.atsServer.getAgileService().getTeams()) {
            teams.add(this.toJaxTeam(team));
        }
        return teams;
    }

    public JaxAgileTeam getTeam(long teamUuid) {
        IAgileTeam team = this.atsServer.getAgileService().getAgileTeamById(teamUuid);
        return this.toJaxTeam(team);
    }

    public Response createTeam(JaxNewAgileTeam newTeam) {
        if (!Strings.isValid((String)newTeam.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        Long uuid = newTeam.getUuid();
        if (uuid == null || uuid <= 0L) {
            newTeam.setUuid(Lib.generateArtifactIdAsInt());
        }
        IAgileTeam updatedTeam = this.atsServer.getAgileService().createAgileTeam(newTeam);
        JaxAgileTeam created = this.toJaxTeam(updatedTeam);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(created.getUuid())).build(new Object[0]);
        Response response = Response.created((URI)location).entity((Object)created).build();
        return response;
    }

    public Response updateTeam(JaxAgileTeam team) {
        IAgileTeam updatedTeam = this.atsServer.getAgileService().updateAgileTeam(team);
        JaxAgileTeam created = this.toJaxTeam(updatedTeam);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(created.getUuid())).build(new Object[0]);
        Response response = Response.created((URI)location).entity((Object)created).build();
        return response;
    }

    private JaxAgileTeam toJaxTeam(IAgileTeam updatedTeam) {
        JaxAgileTeam created = new JaxAgileTeam();
        created.setName(updatedTeam.getName());
        created.setUuid(updatedTeam.getId());
        created.setActive(updatedTeam.isActive());
        created.getAtsTeamUuids().addAll(updatedTeam.getAtsTeamUuids());
        created.setBacklogUuid(updatedTeam.getBacklogUuid());
        created.setDescription(updatedTeam.getDescription());
        return created;
    }

    public Response deleteTeam(long teamUuid) {
        this.atsServer.getAgileService().deleteAgileTeam(teamUuid);
        return Response.ok().build();
    }

    public List<JaxAgileFeatureGroup> getFeatureGroups(long teamUuid) {
        LinkedList<JaxAgileFeatureGroup> groups = new LinkedList<JaxAgileFeatureGroup>();
        ArtifactReadable agileTeamArt = this.atsServer.getArtifact(teamUuid);
        for (ArtifactReadable child : agileTeamArt.getChildren()) {
            if (!child.getName().equals("Feature Groups")) continue;
            for (ArtifactReadable subChild : child.getChildren()) {
                if (!subChild.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) continue;
                IAgileFeatureGroup group = this.atsServer.getConfigItemFactory().getAgileFeatureGroup((ArtifactId)subChild);
                JaxAgileFeatureGroup newGroup = new JaxAgileFeatureGroup();
                newGroup.setName(group.getName());
                newGroup.setUuid(group.getId());
                newGroup.setActive(group.isActive());
                newGroup.setTeamUuid(group.getTeamUuid());
                groups.add(newGroup);
            }
        }
        return groups;
    }

    public Response createFeatureGroup(long teamUuid, JaxNewAgileFeatureGroup newFeatureGroup) {
        if (!Strings.isValid((String)newFeatureGroup.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newFeatureGroup.getTeamUuid() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "teamUuid is not valid", new Object[0]);
        }
        String guid = GUID.create();
        Long uuid = newFeatureGroup.getUuid();
        if (uuid == null || uuid <= 0L) {
            uuid = Lib.generateArtifactIdAsInt();
        }
        IAgileFeatureGroup team = this.atsServer.getAgileService().createAgileFeatureGroup(newFeatureGroup.getTeamUuid(), newFeatureGroup.getName(), guid, uuid);
        JaxAgileFeatureGroup newGroup = new JaxAgileFeatureGroup();
        newGroup.setName(team.getName());
        newGroup.setUuid(team.getId());
        newGroup.setActive(team.isActive());
        newGroup.setTeamUuid(team.getTeamUuid());
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(newGroup.getTeamUuid())).path("features").path(String.valueOf(newGroup.getUuid())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)newGroup).build();
    }

    public JaxAgileFeatureGroup getFeatureGroup(long teamUuid, long featureUuid) {
        IAgileFeatureGroup feature = (IAgileFeatureGroup)this.atsServer.getAgileService().getAgileFeatureGroups(Arrays.asList(featureUuid)).iterator().next();
        JaxAgileFeatureGroup created = new JaxAgileFeatureGroup();
        created.setName(feature.getName());
        created.setUuid(feature.getId());
        created.setTeamUuid(feature.getTeamUuid());
        created.setActive(feature.isActive());
        return created;
    }

    public Response deleteFeatureGroup(long teamUuid, long featureUuid) {
        this.atsServer.getAgileService().deleteAgileFeatureGroup(featureUuid);
        return Response.ok().build();
    }

    public Response createSprint(long teamUuid, JaxNewAgileSprint newSprint) {
        if (!Strings.isValid((String)newSprint.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newSprint.getTeamUuid() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "teamUuid is not valid", new Object[0]);
        }
        String guid = GUID.create();
        Long uuid = newSprint.getUuid();
        if (uuid == null || uuid <= 0L) {
            uuid = Lib.generateArtifactIdAsInt();
        }
        IAgileSprint sprint = this.atsServer.getAgileService().createAgileSprint(newSprint.getTeamUuid(), newSprint.getName(), guid, uuid);
        JaxAgileSprint created = this.toJaxSprint(sprint);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(newSprint.getTeamUuid())).path("sprints").path(String.valueOf(sprint.getId())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    private JaxAgileSprint toJaxSprint(IAgileSprint sprint) {
        JaxAgileSprint created = new JaxAgileSprint();
        created.setName(sprint.getName());
        created.setActive(sprint.isActive());
        created.setUuid(sprint.getId());
        created.setTeamUuid(sprint.getTeamUuid());
        return created;
    }

    public List<JaxAgileSprint> getSprints(long teamUuid) {
        if (teamUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamUuid is not valid", new Object[0]);
        }
        ArrayList<JaxAgileSprint> sprints = new ArrayList<JaxAgileSprint>();
        for (IAgileSprint sprint : this.atsServer.getAgileService().getSprintsForTeam(teamUuid)) {
            sprints.add(this.toJaxSprint(sprint));
        }
        return sprints;
    }

    public Response getSprintSummary(long teamUuid, long sprintUuid) {
        if (teamUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamUuid is not valid", new Object[0]);
        }
        if (sprintUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "sprintUuid is not valid", new Object[0]);
        }
        ArtifactReadable sprint = this.getSprint(sprintUuid);
        SprintPageBuilder page = new SprintPageBuilder(sprint);
        PageCreator appPage = PageFactory.newPageCreator((IResourceRegistry)this.resourceRegistry, (String[])new String[0]);
        String result = page.generatePage(appPage, (ResourceToken)new ClassBasedResourceToken("sprintTemplate.html", SprintPageBuilder.class));
        return Response.ok().entity((Object)result).build();
    }

    public Response getSprintBurndown(long teamUuid, long sprintUuid) {
        if (teamUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamUuid is not valid", new Object[0]);
        }
        if (sprintUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "sprintUuid is not valid", new Object[0]);
        }
        ArtifactReadable sprintArt = this.getSprint(sprintUuid);
        IAgileTeam agileTeam = this.atsServer.getAgileService().getAgileTeam(teamUuid);
        IAgileSprint sprint = this.atsServer.getAgileService().getAgileSprint((ArtifactId)sprintArt);
        SprintBurndownDataBuilder builder = new SprintBurndownDataBuilder(agileTeam, sprint, this.atsServer, this.jdbcService);
        AgileBurndown burndown = builder.get();
        return Response.ok().entity((Object)burndown).build();
    }

    public Response getSprintBurndownUi(long teamUuid, long sprintUuid) {
        if (teamUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamUuid is not valid", new Object[0]);
        }
        if (sprintUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "sprintUuid is not valid", new Object[0]);
        }
        ArtifactReadable sprintArt = this.getSprint(sprintUuid);
        IAgileTeam agileTeam = this.atsServer.getAgileService().getAgileTeam(teamUuid);
        IAgileSprint sprint = this.atsServer.getAgileService().getAgileSprint((ArtifactId)sprintArt);
        SprintBurndownDataBuilder builder = new SprintBurndownDataBuilder(agileTeam, sprint, this.atsServer, this.jdbcService);
        AgileBurndown burndown = builder.get();
        SprintBurndownPageBuilder pageBuilder = new SprintBurndownPageBuilder(burndown);
        String html = pageBuilder.getHtml();
        return Response.ok().entity((Object)html).build();
    }

    private ArtifactReadable getSprint(long sprintUuid) {
        ArtifactReadable sprint = (ArtifactReadable)((QueryBuilder)this.atsServer.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid((long)new Long(sprintUuid).intValue())).getResults().getAtMostOneOrNull();
        if (sprint == null) {
            throw new OseeCoreException("Sprint for id:%d not found", new Object[]{sprintUuid});
        }
        return sprint;
    }

    public Response deleteSprint(long teamUuid, long sprintUuid) {
        this.atsServer.getAgileService().deleteSprint(sprintUuid);
        return Response.ok().build();
    }

    public Response createBacklog(long teamUuid, JaxNewAgileBacklog newBacklog) {
        ArtifactReadable teamArt;
        if (!Strings.isValid((String)newBacklog.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newBacklog.getTeamUuid() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "teamUuid is not valid", new Object[0]);
        }
        IAgileBacklog backlog = null;
        if (!Strings.isValid((String)newBacklog.getName())) {
            new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        String guid = GUID.create();
        Long uuid = newBacklog.getUuid();
        if (uuid == null || uuid <= 0L) {
            uuid = Lib.generateArtifactIdAsInt();
        }
        if (!(teamArt = this.atsServer.getArtifact(newBacklog.getTeamUuid())).getRelated(AtsRelationTypes.AgileTeamToBacklog_Backlog).isEmpty()) {
            new OseeWebApplicationException(Response.Status.BAD_REQUEST, "Backlog already set for team %s", new Object[]{teamArt.toStringWithId()});
        }
        backlog = this.atsServer.getAgileService().createAgileBacklog(newBacklog.getTeamUuid(), newBacklog.getName(), guid, uuid);
        JaxAgileBacklog created = this.toJaxBacklog(backlog);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(backlog.getTeamUuid())).path("backlog").build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    public Response updateBacklog(long teamUuid, JaxAgileBacklog newBacklog) {
        IAgileBacklog backlog = this.atsServer.getAgileService().updateAgileBacklog(newBacklog);
        JaxAgileBacklog created = this.toJaxBacklog(backlog);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(created.getTeamUuid())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    public JaxAgileBacklog getBacklog(long teamUuid) {
        if (teamUuid <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamUuid is not valid", new Object[0]);
        }
        IAgileBacklog backlog = this.atsServer.getAgileService().getBacklogForTeam(teamUuid);
        if (backlog != null) {
            return this.toJaxBacklog(backlog);
        }
        return null;
    }

    public List<AgileItem> getBacklogItems(long teamUuid) {
        LinkedList<AgileItem> items = new LinkedList<AgileItem>();
        IAgileTeam team = this.atsServer.getAgileService().getAgileTeam(teamUuid);
        IAgileBacklog backlog = this.atsServer.getAgileService().getAgileBacklog(team);
        if (backlog != null) {
            int x = 1;
            for (IAgileItem aItem : this.atsServer.getAgileService().getItems(backlog)) {
                AgileItem item = new AgileItem();
                item.setName(aItem.getName());
                item.setFeatureGroups(Collections.toString((String)"; ", (Iterable)this.atsServer.getAgileService().getFeatureGroups(aItem)));
                item.setUuid(aItem.getId());
                item.setAssignees(Collections.toString((String)"; ", (Object[])new Object[]{aItem.getStateMgr().getAssigneesStr()}));
                item.setAtsId(aItem.getAtsId());
                item.setState(aItem.getStateMgr().getCurrentStateName());
                item.setOrder(x++);
                IAgileSprint sprint = this.atsServer.getAgileService().getSprint(aItem);
                if (sprint != null) {
                    item.setSprint(sprint.getName());
                }
                items.add(item);
            }
        }
        return items;
    }

    private JaxAgileBacklog toJaxBacklog(IAgileBacklog backlog) {
        JaxAgileBacklog result = new JaxAgileBacklog();
        result.setActive(backlog.isActive());
        result.setActive(backlog.isActive());
        result.setName(backlog.getName());
        result.setUuid(backlog.getId());
        result.setTeamUuid(backlog.getTeamUuid());
        return result;
    }

    public Response updateItem(long itemUuid, JaxAgileItem newItem) {
        if (newItem.getUuids().isEmpty()) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "itemUuid is not valid", new Object[0]);
        }
        JaxAgileItem sprint = this.atsServer.getAgileService().updateItem(newItem);
        JaxAgileItem item = new JaxAgileItem();
        item.getUuids().addAll(sprint.getUuids());
        item.getFeatures().addAll(sprint.getFeatures());
        item.setSprintUuid(sprint.getSprintUuid());
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("team").path(String.valueOf(item.getSprintUuid())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)item).build();
    }

    public Response updateItems(JaxAgileItem newItem) {
        JaxAgileItem sprint = this.atsServer.getAgileService().updateItem(newItem);
        JaxAgileItem item = new JaxAgileItem();
        item.getUuids().addAll(sprint.getUuids());
        item.getFeatures().addAll(sprint.getFeatures());
        item.setSprintUuid(sprint.getSprintUuid());
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("team").path(String.valueOf(item.getSprintUuid())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)item).build();
    }

    public JaxAtsObjects getSprintItemsAsJax(long teamUuid, long sprintUuid) {
        ArtifactReadable sprintArt = this.atsServer.getArtifact(sprintUuid);
        JaxAtsObjects objs = new JaxAtsObjects();
        for (IAtsWorkItem workItem : this.atsServer.getWorkItemFactory().getWorkItems((Collection)sprintArt.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem).getList())) {
            objs.getAtsObjects().add(JaxAtsObjects.create((IAtsObject)workItem));
        }
        return objs;
    }

    public Collection<IAtsWorkItem> getSprintItems(long teamUuid, long sprintUuid) {
        ArtifactReadable sprintArt = this.atsServer.getArtifact(sprintUuid);
        return this.atsServer.getWorkItemFactory().getWorkItems((Collection)sprintArt.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem).getList());
    }

    public Response getSprintItemsUI(long teamUuid, long sprintUuid) {
        ArtifactReadable sprintArt = this.atsServer.getArtifact(sprintUuid);
        Conditions.assertNotNull((Object)sprintArt, (String)"Sprint not found with id %s", (Object[])new Object[]{sprintUuid});
        Collection<IAtsWorkItem> myWorldItems = this.getSprintItems(teamUuid, sprintUuid);
        CustomizeData custData = this.getDefaultAgileCustData();
        Conditions.assertNotNull((Object)custData, (String)"Can't retrieve default customization", (Object[])new Object[0]);
        String table = WorldResource.getCustomizedTable(this.atsServer, "Sprint - " + sprintArt.getName(), custData, myWorldItems);
        return Response.ok().entity((Object)table).build();
    }

    private CustomizeData getDefaultAgileCustData() {
        CustomizeData result = null;
        try {
            String custDataStr = RestUtil.getResource("support/DefaultAgileCustomization.json");
            if (Strings.isValid((String)custDataStr)) {
                result = (CustomizeData)AgileEndpointImpl.getMapper().readValue(custDataStr, CustomizeData.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Response getSprintItemsUICustomized(long teamUuid, long sprintUuid, String customizeGuid) {
        ArtifactReadable sprintArt = this.atsServer.getArtifact(sprintUuid);
        Conditions.assertNotNull((Object)sprintArt, (String)"Sprint not found with id %s", (Object[])new Object[]{sprintUuid});
        Collection<IAtsWorkItem> myWorldItems = this.getSprintItems(teamUuid, sprintUuid);
        CustomizeData custData = this.atsServer.getCustomizationByGuid(customizeGuid);
        Conditions.assertNotNull((Object)custData, (String)"Can't retrieve customization with id %s", (Object[])new Object[]{customizeGuid});
        String table = WorldResource.getCustomizedTable(this.atsServer, "Sprint - " + sprintArt.getName(), custData, myWorldItems);
        return Response.ok().entity((Object)table).build();
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("MMM d, yyyy h:mm:ss aa"));
        }
        return mapper;
    }

    @PUT
    @Path(value="item/{itemId}/feature")
    public Response addFeatureGroup(@PathParam(value="itemId") long itemId, String featureGroupName) {
        ArtifactReadable itemArt = this.atsServer.getArtifact(itemId);
        Conditions.assertNotNull((Object)itemArt, (String)"Work Item not found with id %s", (Object[])new Object[]{itemId});
        IAgileItem item = this.atsServer.getWorkItemFactory().getAgileItem((ArtifactId)itemArt);
        boolean found = false;
        for (IAgileFeatureGroup feature : this.atsServer.getAgileService().getFeatureGroups(item)) {
            if (!feature.getName().equals(featureGroupName)) continue;
            found = true;
            break;
        }
        if (!found) {
            IAgileTeam team = this.atsServer.getAgileService().getAgileTeam(item);
            for (ArtifactReadable featureArt : ((ArtifactReadable)team.getStoreObject()).getRelated(AtsRelationTypes.AgileTeamToFeatureGroup_FeatureGroup)) {
                if (!featureArt.getName().equals(featureGroupName)) continue;
                IAtsChangeSet changes = this.atsServer.createChangeSet("Add Feature Group to WorkItem", AtsCoreUsers.SYSTEM_USER);
                changes.relate((Object)featureArt, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)item);
                changes.execute();
                return Response.ok().build();
            }
        }
        return Response.notModified().build();
    }

    @PUT
    @Path(value="item/{itemId}/unplanned")
    public Response setUnPlanned(@PathParam(value="itemId") long itemId, boolean unPlanned) {
        ArtifactReadable itemArt = this.atsServer.getArtifact(itemId);
        Conditions.assertNotNull((Object)itemArt, (String)"Work Item not found with id %s", (Object[])new Object[]{itemId});
        IAgileItem item = this.atsServer.getWorkItemFactory().getAgileItem((ArtifactId)itemArt);
        IAtsChangeSet changes = this.atsServer.createChangeSet("Set Agile UnPlanned", AtsCoreUsers.SYSTEM_USER);
        changes.setSoleAttributeValue((IAtsObject)item, (AttributeTypeId)AtsAttributeTypes.UnPlannedWork, (Object)unPlanned);
        changes.execute();
        return Response.ok().build();
    }

    @PUT
    @Path(value="item/{itemId}/points")
    public Response setPoints(@PathParam(value="itemId") long itemId, String points) {
        ArtifactReadable itemArt = this.atsServer.getArtifact(itemId);
        Conditions.assertNotNull((Object)itemArt, (String)"Work Item not found with id %s", (Object[])new Object[]{itemId});
        IAgileItem item = this.atsServer.getWorkItemFactory().getAgileItem((ArtifactId)itemArt);
        IAgileTeam team = this.atsServer.getAgileService().getAgileTeam(item);
        AttributeTypeId agileTeamPointsAttributeType = this.atsServer.getAgileService().getAgileTeamPointsAttributeType(team);
        IAtsChangeSet changes = this.atsServer.createChangeSet("Set Points", AtsCoreUsers.SYSTEM_USER);
        changes.setSoleAttributeValue((IAtsWorkItem)item, agileTeamPointsAttributeType, points);
        changes.execute();
        return Response.ok().build();
    }

    @GET
    @Path(value="team/{teamUuid}/sprint/{sprintUuid}/burndownExcel")
    @Produces(value={"application/json"})
    public Response getSprintBurndownExcel(@PathParam(value="teamUuid") long teamUuid, @PathParam(value="sprintUuid") long sprintUuid) {
        JaxBurndownExcel report = new JaxBurndownExcel();
        ArtifactReadable sprintArt = this.atsServer.getArtifact(sprintUuid);
        IAgileSprint sprint = this.atsServer.getWorkItemFactory().getAgileSprint((ArtifactToken)sprintArt);
        Conditions.assertNotNull((Object)sprintArt, (String)"Sprint not found with id %s", (Object[])new Object[]{sprintUuid});
        ArtifactReadable burndownExcel = null;
        ArtifactReadable burndownQuery = null;
        for (ArtifactReadable art : sprintArt.getChildren()) {
            if (art.getName().equals("OSEE_Sprint_Burndown") && ((String)art.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, (Object)"")).equals("xls")) {
                burndownExcel = art;
                continue;
            }
            if (!art.getName().equals("OSEE_Sprint_Burndown") || !((String)art.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, (Object)"")).equals("iqy")) continue;
            burndownQuery = art;
        }
        if (burndownExcel != null && burndownQuery == null || burndownExcel == null && burndownQuery != null) {
            report.setError("Either OSEE_Sprint_Burndown.xls or OSEE_Sprint_Burndown.iqy was found.  Both need to be found or none.  Names must match exactly.");
            return Response.ok((Object)report).build();
        }
        try {
            if (burndownExcel == null) {
                IAtsChangeSet changes = this.atsServer.createChangeSet("Create Burndown Artifacts", AtsCoreUsers.SYSTEM_USER);
                File burndownXls = RestUtil.getResourceAsFile("support/OSEE_Sprint_Burndown.xls");
                FileInputStream burndownFileInputStream = new FileInputStream(burndownXls);
                ArtifactId burndownExcelArt = changes.createArtifact(CoreArtifactTypes.GeneralDocument, "OSEE_Sprint_Burndown");
                changes.setSoleAttributeValue(burndownExcelArt, (AttributeTypeId)CoreAttributeTypes.Extension, (Object)"xls");
                changes.setSoleAttributeFromStream(burndownExcelArt, (AttributeTypeId)CoreAttributeTypes.NativeContent, (InputStream)burndownFileInputStream);
                changes.relate((Object)sprint, CoreRelationTypes.Default_Hierarchical__Child, (Object)burndownExcelArt);
                report.setExcelSheetUuid(burndownExcelArt.getUuid());
                String burndownqry = RestUtil.getResource("support/OSEE_Sprint_Burndown.iqy");
                burndownqry = burndownqry.replace("BASE_URI", this.uriInfo.getBaseUri().toString());
                IAgileTeam team = this.atsServer.getConfigItemFactory().getAgileTeam((ArtifactId)this.atsServer.getArtifact(sprint.getTeamUuid()));
                burndownqry = burndownqry.replace("TEAM_ID", team.getIdString());
                burndownqry = burndownqry.replace("SPRINT_ID", sprintArt.getIdString());
                ArtifactId burndownQryArt = changes.createArtifact(CoreArtifactTypes.GeneralDocument, "OSEE_Sprint_Burndown");
                changes.setSoleAttributeValue(burndownQryArt, (AttributeTypeId)CoreAttributeTypes.Extension, (Object)"iqy");
                changes.setSoleAttributeFromStream(burndownQryArt, (AttributeTypeId)CoreAttributeTypes.NativeContent, Lib.stringToInputStream((String)burndownqry));
                changes.relate((Object)sprint, CoreRelationTypes.Default_Hierarchical__Child, (Object)burndownQryArt);
                report.setExcelQueryUuid(burndownQryArt.getUuid());
                changes.execute();
            } else {
                ArtifactReadable excelArt = null;
                ArtifactReadable queryArt = null;
                for (ArtifactReadable child : sprintArt.getChildren()) {
                    if (((String)child.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, (Object)"")).equals("xls")) {
                        excelArt = child;
                        report.setExcelSheetUuid(excelArt.getUuid());
                        continue;
                    }
                    if (!((String)child.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, (Object)"")).equals("iqy")) continue;
                    queryArt = child;
                    report.setExcelQueryUuid(queryArt.getUuid());
                }
                if (excelArt == null) {
                    report.setError("Could not access Excel burndown artifact.");
                }
                if (queryArt == null) {
                    report.setError(String.valueOf(report.getError()) + "\nCould not access Excel Query burndown artifact.");
                }
            }
        }
        catch (Exception ex) {
            throw new OseeWebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok((Object)report).build();
    }
}

