/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.IWorkDefinitionStringProvider;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionListener;
import org.eclipse.osee.ats.core.agile.AgileService;
import org.eclipse.osee.ats.core.ai.ActionableItemManager;
import org.eclipse.osee.ats.core.util.ActionFactory;
import org.eclipse.osee.ats.core.util.AtsCoreFactory;
import org.eclipse.osee.ats.core.util.AtsCoreServiceImpl;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.convert.ConvertBaselineGuidToBaselineUuid;
import org.eclipse.osee.ats.rest.internal.convert.ConvertFavoriteBranchGuidToUuid;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotificationEventProcessor;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotifierServiceImpl;
import org.eclipse.osee.ats.rest.internal.notify.WorkItemNotificationProcessor;
import org.eclipse.osee.ats.rest.internal.query.AtsQueryServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.ArtifactResolverImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsAttributeResolverServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsBranchServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsEarnedValueImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsRelationResolverServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsStoreServiceImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTaskService;
import org.eclipse.osee.ats.rest.internal.workitem.ConfigItemFactory;
import org.eclipse.osee.ats.rest.internal.workitem.WorkItemFactory;
import org.eclipse.osee.ats.rest.util.ChangeTypeUtil;
import org.eclipse.osee.ats.rest.util.IAtsNotifierServer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsServerImpl
extends AtsCoreServiceImpl
implements IAtsServer {
    public static String PLUGIN_ID = "org.eclipse.osee.ats.rest";
    private OrcsApi orcsApi;
    private AtsNotifierServiceImpl notifyService;
    private AtsNotificationEventProcessor notificationEventProcessor;
    private IAgileService agileService;
    private volatile boolean emailEnabled = true;
    private boolean loggedNotificationDisabled = false;
    private final List<IAtsNotifierServer> notifiers = new CopyOnWriteArrayList<IAtsNotifierServer>();
    private final Map<String, IAtsDatabaseConversion> externalConversions = new ConcurrentHashMap<String, IAtsDatabaseConversion>();
    private AtsConfigEndpointImpl configurationsProvider;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public void addAtsDatabaseConversion(IAtsDatabaseConversion conversion) {
        this.externalConversions.put(conversion.getName(), conversion);
    }

    public void removeAtsDatabaseConversion(IAtsDatabaseConversion conversion) {
        this.externalConversions.remove(conversion.getName());
    }

    public void addNotifier(IAtsNotifierServer notifier) {
        this.notifiers.add(notifier);
    }

    public void removeNotifier(IAtsNotifierServer notifier) {
        this.notifiers.remove(notifier);
    }

    public void start() throws OseeCoreException {
        this.attributeResolverService = new AtsAttributeResolverServiceImpl();
        super.start();
        this.notifyService = new AtsNotifierServiceImpl();
        this.workItemFactory = new WorkItemFactory(this);
        this.configItemFactory = new ConfigItemFactory(this.logger, this);
        this.artifactResolver = new ArtifactResolverImpl(this, this.orcsApi);
        this.branchService = new AtsBranchServiceImpl(this.getServices(), this.orcsApi, (ITeamWorkflowProvidersLazy)this.teamWorkflowProvidersLazy);
        this.relationResolver = new AtsRelationResolverServiceImpl(this);
        ((AtsAttributeResolverServiceImpl)this.attributeResolverService).setOrcsApi(this.orcsApi);
        ((AtsAttributeResolverServiceImpl)this.attributeResolverService).setServices(this);
        this.workDefService.setWorkDefinitionStringProvider((IWorkDefinitionStringProvider)this);
        this.logFactory = AtsCoreFactory.newLogFactory();
        this.stateFactory = AtsCoreFactory.newStateFactory((IAtsServices)this.getServices(), (IAtsLogFactory)this.logFactory);
        this.storeService = new AtsStoreServiceImpl(this.attributeResolverService, this, this.stateFactory, this.logFactory, this, this.jdbcService);
        this.queryService = new AtsQueryServiceImpl(this, this.jdbcService);
        this.actionableItemManager = new ActionableItemManager(this.attributeResolverService, this.storeService, (IAtsServices)this);
        this.actionFactory = new ActionFactory(this.workItemFactory, this.actionableItemManager, this.attributeResolverService, this.stateFactory, this.getServices());
        this.agileService = new AgileService(this.logger, (IAtsServices)this);
        this.taskService = new AtsTaskService(this);
        this.earnedValueService = new AtsEarnedValueImpl(this.logger, this);
        this.addAtsDatabaseConversion(new ConvertBaselineGuidToBaselineUuid(this.logger, this.jdbcService.getClient(), this.orcsApi, this));
        this.addAtsDatabaseConversion(new ConvertFavoriteBranchGuidToUuid(this.logger, this.jdbcService.getClient(), this.orcsApi, this));
        this.logger.info("ATS Application started", new Object[0]);
    }

    public void stop() {
        super.stop();
    }

    @Override
    public OrcsApi getOrcsApi() throws OseeCoreException {
        return this.orcsApi;
    }

    @Override
    public ArtifactReadable getArtifact(ArtifactId artifact) throws OseeCoreException {
        IAtsObject atsObject;
        ArtifactReadable result = null;
        result = artifact instanceof ArtifactReadable ? (ArtifactReadable)artifact : (artifact instanceof IAtsObject ? ((atsObject = (IAtsObject)artifact).getStoreObject() instanceof ArtifactReadable ? (ArtifactReadable)atsObject.getStoreObject() : (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andUuid(atsObject.getId().longValue())).getResults().getAtMostOneOrNull()) : (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andId(artifact)).getResults().getOneOrNull());
        return result;
    }

    @Override
    public ArtifactReadable getArtifact(IAtsObject atsObject) throws OseeCoreException {
        ArtifactReadable result = null;
        if (atsObject.getStoreObject() instanceof ArtifactReadable) {
            result = (ArtifactReadable)atsObject.getStoreObject();
        } else {
            result = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andUuid(atsObject.getId().longValue())).getResults().getAtMostOneOrNull();
            if (result != null) {
                atsObject.setStoreObject((ArtifactToken)result);
            }
        }
        return result;
    }

    @Override
    public ArtifactReadable getArtifactByGuid(String guid) throws OseeCoreException {
        ArtifactReadable artifact = null;
        try {
            artifact = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andGuid(guid)).getResults().getExactlyOne();
        }
        catch (ItemDoesNotExist itemDoesNotExist) {}
        return artifact;
    }

    @Override
    public Iterable<IAtsDatabaseConversion> getDatabaseConversions() {
        return this.externalConversions.values();
    }

    @Override
    public ArtifactReadable getArtifactByAtsId(String id) {
        return (ArtifactReadable)super.getArtifactByAtsId(id);
    }

    public ArtifactReadable getArtifactById(String id) {
        ArtifactReadable action = null;
        if (GUID.isValid((String)id)) {
            action = this.getArtifactByGuid(id);
        }
        Long uuid = null;
        try {
            uuid = Long.parseLong(id);
        }
        catch (NumberFormatException numberFormatException) {}
        if (uuid != null) {
            action = this.getArtifact(uuid);
        }
        if (action == null) {
            action = this.getArtifactByAtsId(id);
        }
        return action;
    }

    @Override
    public ArtifactReadable getArtifact(Long uuid) {
        return (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andUuid(uuid.longValue())).getResults().getOneOrNull();
    }

    @Override
    public Collection<ArtifactToken> getArtifacts(List<Long> uuids) {
        LinkedList<ArtifactToken> artifacts = new LinkedList<ArtifactToken>();
        Iterator iterator = ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andUuids(uuids)).getResults().iterator();
        while (iterator.hasNext()) {
            artifacts.add((ArtifactToken)iterator.next());
        }
        return artifacts;
    }

    @Override
    public List<ArtifactReadable> getArtifactListByIds(String ids) {
        ArrayList<ArtifactReadable> actions = new ArrayList<ArtifactReadable>();
        String[] stringArray = ids.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            id = id.replaceAll("^ +", "");
            ArtifactReadable action = this.getArtifactById(id = id.replaceAll(" +$", ""));
            if (action != null) {
                actions.add(action);
            }
            ++n2;
        }
        return actions;
    }

    @Override
    public QueryBuilder getQuery() {
        return this.getOrcsApi().getQueryFactory().fromBranch((BranchId)this.getAtsBranch());
    }

    public String getConfigValue(String key) {
        String result = null;
        ArtifactReadable atsConfig = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds((ArtifactId)AtsArtifactToken.AtsConfig)).getResults().getAtMostOneOrNull();
        if (atsConfig != null) {
            for (Object obj : atsConfig.getAttributeValues((AttributeTypeId)CoreAttributeTypes.GeneralStringData)) {
                String str = (String)obj;
                if (!str.startsWith(key)) continue;
                result = str.replaceFirst(String.valueOf(key) + "=", "");
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isProduction() {
        return this.jdbcService.getClient().getConfig().isProduction();
    }

    @Override
    public IAtsServices getServices() {
        return this;
    }

    public void sendNotifications(final AtsNotificationCollector notifications) {
        if (this.isEmailEnabled()) {
            if (this.notifiers.isEmpty() || !this.isProduction()) {
                if (!this.loggedNotificationDisabled) {
                    this.logger.info("Osee Notification Disabled", new Object[0]);
                    this.loggedNotificationDisabled = true;
                }
            } else {
                final WorkItemNotificationProcessor workItemNotificationProcessor = new WorkItemNotificationProcessor(this.logger, this, this.workItemFactory, this.userService, this.attributeResolverService);
                Thread thread = new Thread("ATS Notification Sender"){

                    @Override
                    public void run() {
                        super.run();
                        AtsServerImpl.this.notificationEventProcessor = new AtsNotificationEventProcessor(workItemNotificationProcessor, AtsServerImpl.this.userService, AtsServerImpl.this.getConfigValue("NoReplyEmail"));
                        AtsServerImpl.this.notificationEventProcessor.sendNotifications(notifications, AtsServerImpl.this.notifiers);
                    }
                };
                thread.start();
            }
        }
    }

    public AtsNotifierServiceImpl getNotifyService() {
        return this.notifyService;
    }

    @Override
    public List<IAtsWorkItem> getWorkItemListByIds(String ids) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (ArtifactReadable art : this.getArtifactListByIds(ids)) {
            IAtsWorkItem workItem = this.workItemFactory.getWorkItem((ArtifactId)art);
            if (workItem == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public void setChangeType(IAtsObject atsObject, ChangeType changeType, IAtsChangeSet changes) {
        ChangeTypeUtil.setChangeType(atsObject, changeType, changes);
    }

    public ChangeType getChangeType(IAtsAction fromAction) {
        return ChangeTypeUtil.getChangeType((IAtsObject)fromAction);
    }

    public Collection<IArtifactType> getArtifactTypes() {
        ArrayList<IArtifactType> types = new ArrayList<IArtifactType>();
        types.addAll(this.orcsApi.getOrcsTypes().getArtifactTypes().getAll());
        return types;
    }

    public boolean isEmailEnabled() {
        return this.emailEnabled;
    }

    @Override
    public void setEmailEnabled(boolean emailEnabled) {
        this.emailEnabled = emailEnabled;
    }

    public IAgileService getAgileService() {
        return this.agileService;
    }

    public <A extends IAtsConfigObject> A getSoleByUuid(long uuid, Class<A> clazz) throws OseeCoreException {
        return (A)((IAtsConfigObject)this.getCache().getAtsObject(Long.valueOf(uuid)));
    }

    public Collection<ITransitionListener> getTransitionListeners() {
        return Collections.emptyList();
    }

    public void clearImplementersCache(IAtsWorkItem workItem) {
    }

    public ArtifactToken getArtifactByName(IArtifactType artifactType, String name) {
        return (ArtifactToken)((QueryBuilder)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).andIsOfType(new ArtifactTypeId[]{artifactType})).andNameEquals(name)).getResults().getAtMostOneOrNull();
    }

    public AtsConfigurations getConfigurations() {
        if (this.configurationsProvider == null) {
            this.configurationsProvider = new AtsConfigEndpointImpl(this, this.orcsApi, this.logger);
        }
        return this.configurationsProvider.get();
    }

    public void clearConfigurationsCaches() {
    }

    @Override
    public CustomizeData getCustomizationByGuid(String customize_guid) {
        CustomizeData cust = null;
        ArtifactReadable customizeStoreArt = (ArtifactReadable)((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.getAtsBranch()).and((AttributeTypeId)CoreAttributeTypes.XViewerCustomization, customize_guid, QueryOption.CONTAINS_MATCH_OPTIONS)).getResults().getAtMostOneOrNull();
        if (customizeStoreArt != null) {
            for (String custXml : this.getAttributeResolver().getAttributesToStringList((ArtifactId)customizeStoreArt, (AttributeTypeId)CoreAttributeTypes.XViewerCustomization)) {
                if (!custXml.contains(customize_guid)) continue;
                cust = new CustomizeData(custXml);
                break;
            }
        }
        return cust;
    }

    private List<ArtifactId> getCustomizeArts() {
        List<ArtifactId> customizationArts = this.getGlobalCustomizeArts();
        for (ArtifactId artifact : ((QueryBuilder)this.getQuery().andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})).getResults()) {
            customizationArts.add(artifact);
        }
        return customizationArts;
    }

    private List<ArtifactId> getGlobalCustomizeArts() {
        ArrayList<ArtifactId> customizationArts = new ArrayList<ArtifactId>();
        for (ArtifactId artifact : ((QueryBuilder)this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.XViewerGlobalCustomization})).getResults()) {
            customizationArts.add(artifact);
        }
        return customizationArts;
    }

    @Override
    public Collection<CustomizeData> getCustomizations(String namespace) {
        ArrayList<CustomizeData> customizations = new ArrayList<CustomizeData>();
        for (ArtifactId customizationArt : this.getCustomizeArts()) {
            this.addCustomizationsFromArts(namespace, customizations, customizationArt);
        }
        return customizations;
    }

    private void addCustomizationsFromArts(String namespace, List<CustomizeData> customizations, ArtifactId customizationArt) {
        for (String custXml : this.getAttributeResolver().getAttributesToStringList(customizationArt, (AttributeTypeId)CoreAttributeTypes.XViewerCustomization)) {
            if (!custXml.contains("\"" + namespace + "\"")) continue;
            CustomizeData data = new CustomizeData(custXml);
            customizations.add(data);
        }
    }

    @Override
    public Collection<CustomizeData> getCustomizationsGlobal(String namespace) {
        ArrayList<CustomizeData> customizations = new ArrayList<CustomizeData>();
        for (ArtifactId customizationArt : this.getGlobalCustomizeArts()) {
            this.addCustomizationsFromArts(namespace, customizations, customizationArt);
        }
        return customizations;
    }

    public IAtsChangeSet createChangeSet(String comment) {
        return this.getStoreService().createAtsChangeSet(comment, this.userService.getCurrentUser());
    }

    public boolean isNotificationsEnabled() {
        throw new UnsupportedOperationException();
    }

    public void setNotifactionsEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }
}

