/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.agile.AgileEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ActionableItemResource;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ConvertCreateUpdateAtsConfig;
import org.eclipse.osee.ats.rest.internal.config.ConvertResource;
import org.eclipse.osee.ats.rest.internal.config.CountryEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.CountryResource;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityResource;
import org.eclipse.osee.ats.rest.internal.config.InsertionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionResource;
import org.eclipse.osee.ats.rest.internal.config.ProgramEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ProgramResource;
import org.eclipse.osee.ats.rest.internal.config.ReportResource;
import org.eclipse.osee.ats.rest.internal.config.TeamResource;
import org.eclipse.osee.ats.rest.internal.config.UserResource;
import org.eclipse.osee.ats.rest.internal.config.VersionResource;
import org.eclipse.osee.ats.rest.internal.cpa.CpaResource;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotifyEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.ActionUiResource;
import org.eclipse.osee.ats.rest.internal.workitem.AtsActionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsRuleEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTaskEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsWorkPackageEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.StateResource;
import org.eclipse.osee.ats.rest.internal.world.WorldResource;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceRegistry;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.template.engine.OseeTemplateTokens;

@ApplicationPath(value="ats")
public class AtsApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private Log logger;
    private OrcsApi orcsApi;
    private IAtsServer atsServer;
    private CpaServiceRegistry cpaRegistry;
    private JdbcService jdbcService;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setAtsServer(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setCpaServiceRegistry(CpaServiceRegistry cpaRegistry) {
        this.cpaRegistry = cpaRegistry;
    }

    public void start() {
        ResourceRegistry registry = new ResourceRegistry();
        OseeTemplateTokens.register((IResourceRegistry)registry);
        ConvertCreateUpdateAtsConfig conversion = new ConvertCreateUpdateAtsConfig(this.atsServer);
        this.atsServer.addAtsDatabaseConversion(conversion);
        this.singletons.add(new VersionResource(this.atsServer));
        this.singletons.add(new TeamResource(this.atsServer));
        this.singletons.add(new ActionableItemResource(this.atsServer));
        this.singletons.add(new CountryResource(this.atsServer));
        this.singletons.add(new ProgramResource(this.atsServer));
        this.singletons.add(new InsertionResource(this.atsServer));
        this.singletons.add(new InsertionActivityResource(this.atsServer));
        this.singletons.add(new AtsActionEndpointImpl(this.atsServer, this.orcsApi));
        this.singletons.add(new AtsRuleEndpointImpl(this.atsServer));
        this.singletons.add(new StateResource(this.atsServer));
        this.singletons.add(new ConvertResource(this.atsServer));
        this.singletons.add(new CpaResource(this.orcsApi, this.atsServer, this.cpaRegistry));
        this.singletons.add(new UserResource(this.atsServer.getUserService()));
        this.singletons.add(new WorldResource(this.atsServer));
        this.singletons.add(new AgileEndpointImpl(this.atsServer, (IResourceRegistry)registry, this.jdbcService));
        this.singletons.add(new CountryEndpointImpl(this.atsServer));
        this.singletons.add(new ProgramEndpointImpl(this.atsServer));
        this.singletons.add(new InsertionEndpointImpl(this.atsServer));
        this.singletons.add(new InsertionActivityEndpointImpl(this.atsServer));
        this.singletons.add(new AtsConfigEndpointImpl(this.atsServer, this.orcsApi, this.logger));
        this.singletons.add(new AtsTaskEndpointImpl(this.atsServer));
        this.singletons.add(new AtsNotifyEndpointImpl(this.atsServer));
        this.singletons.add(new AtsWorkPackageEndpointImpl(this.atsServer, this.logger));
        this.singletons.add(new ActionUiResource(this.atsServer, this.logger));
        this.singletons.add(new ReportResource(this.orcsApi, this.atsServer));
        this.logger.warn("ATS Application Started - %s", new Object[]{System.getProperty("OseeApplicationServer")});
    }

    public void stop() {
        this.singletons.clear();
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

