/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.spi.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexDelta;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.db.ddl.delta.IDBTableDelta;
import org.eclipse.net4j.internal.db.bundle.OM;
import org.eclipse.net4j.internal.db.ddl.DBField;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class DBAdapter
implements IDBAdapter {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SQL, DBAdapter.class);
    private static final String[] SQL92_RESERVED_WORDS = new String[]{"ABSOLUTE", "ACTION", "ADD", "AFTER", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BIT_LENGTH", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "ELSEIF", "END", "EQUALS", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HANDLER", "HAVING", "HOLD", "HOUR", "IDENTITY", "IF", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEAVE", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOOP", "LOWER", "MAP", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OCTET_LENGTH", "OF", "OLD", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARAMETER", "PARTIAL", "PARTITION", "PATH", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "RANGE", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "RELEASE", "REPEAT", "RESIGNAL", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SENSITIVE", "SESSION", "SESSION_USER", "SET", "SETS", "SIGNAL", "SIMILAR", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATIC", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UNDER", "UNDO", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UNTIL", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
    private static final String NULLABLE_DEFAULT = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.spi.db.DBAdapter.NO_NULLABLE_DEFAULT") ? "" : "NULL";
    private String name;
    private String version;
    private Set<String> reservedWords;

    public DBAdapter(String name, String version) {
        this.name = name;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public String getDefaultSchemaName(Connection connection) {
        return null;
    }

    @Override
    public IDBConnectionProvider createConnectionProvider(DataSource dataSource) {
        return DBUtil.createConnectionProvider(dataSource);
    }

    @Override
    public Connection modifyConnection(Connection connection) {
        return connection;
    }

    @Override
    public void createSchema(Connection connection, String schemaName) {
        DBUtil.execute(connection, "CREATE SCHEMA " + DBUtil.quoted(schemaName));
    }

    public IDBSchemaTransaction openSchemaTransaction(IDBDatabase database, IDBConnection currentConnection) {
        return database.openSchemaTransaction(currentConnection);
    }

    @Override
    public IDBSchema readSchema(Connection connection, String name) {
        return DBUtil.readSchema((IDBAdapter)this, connection, name);
    }

    @Override
    public void readSchema(Connection connection, IDBSchema schema) {
        boolean wasTrackConstruction = DBField.isTrackConstruction();
        DBField.trackConstruction(false);
        try {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String schemaName = schema.getName();
                boolean caseSensitive = schema.isCaseSensitive();
                DBUtil.forEachTable(connection, schemaName, caseSensitive, (ConsumerWithException<String, SQLException>)((ConsumerWithException)tableName -> {
                    IDBTable table = schema.addTable((String)tableName);
                    this.readFields(connection, table);
                    this.readIndices(connection, metaData, table, schemaName);
                }));
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        finally {
            DBField.trackConstruction(wasTrackConstruction);
        }
    }

    protected ResultSet readTables(Connection connection, DatabaseMetaData metaData, String schemaName) throws SQLException {
        String catalog = connection.getCatalog();
        return metaData.getTables(catalog, schemaName, null, new String[]{"TABLE"});
    }

    protected void readFields(Connection connection, IDBTable table) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            statement.setMaxRows(1);
            resultSet = statement.executeQuery("SELECT * FROM " + table);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int i = 0;
            while (i < metaData.getColumnCount()) {
                int column = i + 1;
                String name = metaData.getColumnName(column);
                if (name != null) {
                    DBType type = DBType.getTypeByCode(metaData.getColumnType(column));
                    int precision = metaData.getPrecision(column);
                    int scale = metaData.getScale(column);
                    boolean notNull = metaData.isNullable(column) == 0;
                    table.addField(name, type, precision, scale, notNull);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close(statement);
            throw throwable;
        }
        DBUtil.close(resultSet);
        DBUtil.close(statement);
    }

    protected void readIndices(Connection connection, DatabaseMetaData metaData, IDBTable table, String schemaName) throws SQLException {
        DBAdapter.getIndexInfos(metaData, schemaName, table.getName(), indexInfo -> this.addIndex(connection, table, indexInfo.name, indexInfo.type, indexInfo.fieldInfos));
    }

    protected void addIndex(Connection connection, IDBTable table, String name, IDBIndex.Type type, List<FieldInfo> fieldInfos) {
        IDBField[] fields = new IDBField[fieldInfos.size()];
        Collections.sort(fieldInfos);
        int i = 0;
        while (i < fieldInfos.size()) {
            FieldInfo fieldInfo = fieldInfos.get(i);
            IDBField field = table.getField(fieldInfo.name);
            if (field == null) {
                throw new IllegalStateException("Field not found: " + fieldInfo.name);
            }
            fields[i] = field;
            ++i;
        }
        if (!this.isPrimaryKeyShadow(connection, table, name, type, fields)) {
            table.addIndex(name, type, fields);
        }
    }

    protected boolean isPrimaryKeyShadow(Connection connection, IDBTable table, String name, IDBIndex.Type type, IDBField[] fields) {
        if (type != IDBIndex.Type.UNIQUE) {
            return false;
        }
        IDBIndex primaryKey = table.getPrimaryKeyIndex();
        if (primaryKey == null) {
            return false;
        }
        Object[] primaryKeyFields = primaryKey.getFields();
        return Arrays.equals(primaryKeyFields, fields);
    }

    @Override
    public void updateSchema(final Connection connection, final IDBSchema schema, IDBSchemaDelta delta) throws DBException {
        delta.applyTo(schema);
        IDBDeltaVisitor.Default schemaUpdater = new IDBDeltaVisitor.Default(){

            @Override
            public void visit(IDBTableDelta delta) {
                IDBTable table = delta.getSchemaElement(schema);
                IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                switch (changeKind) {
                    case ADD: {
                        DBAdapter.this.createTable(connection, table, delta);
                        break;
                    }
                    case CHANGE: {
                        if (table == null) break;
                        DBAdapter.this.alterTable(connection, table, delta);
                        break;
                    }
                    case REMOVE: {
                        if (table == null) break;
                        DBAdapter.this.dropTable(connection, table, delta);
                        break;
                    }
                    default: {
                        throw 1.illegalChangeKind(changeKind);
                    }
                }
            }

            @Override
            public void visit(IDBIndexDelta delta) {
                InternalDBIndex index = (InternalDBIndex)delta.getSchemaElement(schema);
                IDBDelta.ChangeKind changeKind = delta.getChangeKind();
                switch (changeKind) {
                    case ADD: {
                        try {
                            DBAdapter.this.createIndex(connection, index, delta);
                            break;
                        }
                        catch (RuntimeException ex) {
                            if (index.isOptional()) break;
                            throw ex;
                        }
                    }
                    case CHANGE: {
                        if (index == null) break;
                        DBAdapter.this.dropIndex(connection, index, delta);
                        try {
                            DBAdapter.this.createIndex(connection, index, delta);
                            break;
                        }
                        catch (RuntimeException ex) {
                            if (index.isOptional()) break;
                            throw ex;
                        }
                    }
                    case REMOVE: {
                        if (index == null) break;
                        DBAdapter.this.dropIndex(connection, index, delta);
                        break;
                    }
                    default: {
                        throw 1.illegalChangeKind(changeKind);
                    }
                }
                this.stopRecursion();
            }

            @Override
            public void visit(IDBFieldDelta delta) {
                this.stopRecursion();
            }
        };
        delta.accept(schemaUpdater);
    }

    protected void createTable(Connection connection, IDBTable table, IDBTableDelta delta) {
        CheckUtil.checkArg((delta.getChangeKind() == IDBDelta.ChangeKind.ADD ? 1 : 0) != 0, (String)("Not added: " + delta.getName()));
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        builder.append(table);
        builder.append(" (");
        this.appendFieldDefs(builder, table, this.createFieldDefinitions(table));
        builder.append(")");
        DBUtil.execute(connection, builder);
    }

    protected void dropTable(Connection connection, IDBTable table, IDBTableDelta delta) {
        String sql = this.getDropTableSQL(table);
        DBUtil.execute(connection, sql);
    }

    protected void alterTable(Connection connection, IDBTable table, IDBTableDelta delta) {
        for (IDBFieldDelta fieldDelta : delta.getFieldDeltas().values()) {
            IDBDelta.ChangeKind changeKind = fieldDelta.getChangeKind();
            String fieldName = fieldDelta.getName();
            IDBField field = table.getField(fieldName);
            switch (changeKind) {
                case ADD: {
                    this.createField(connection, field);
                    break;
                }
                case CHANGE: {
                    this.dropField(connection, field);
                    this.createField(connection, field);
                    break;
                }
                case REMOVE: {
                    this.dropField(connection, field);
                    break;
                }
                default: {
                    throw IDBDeltaVisitor.Default.illegalChangeKind(changeKind);
                }
            }
        }
    }

    protected void createField(Connection connection, IDBField field) {
        DBUtil.execute(connection, "ALTER TABLE " + field.getTable() + " ADD COLUMN " + field + " " + this.createFieldDefinition(field));
    }

    protected void dropField(Connection connection, IDBField field) {
        DBUtil.execute(connection, "ALTER TABLE " + field.getTable() + " DROP COLUMN " + field);
    }

    protected void createIndex(Connection connection, IDBIndex index, IDBIndexDelta delta) {
        StringBuilder builder = new StringBuilder();
        if (index.getType() == IDBIndex.Type.PRIMARY_KEY) {
            this.createPrimaryKey(index, builder);
        } else {
            this.createIndex(index, builder);
        }
        this.createIndexFields(index, builder);
        DBUtil.execute(connection, builder);
    }

    protected void createPrimaryKey(IDBIndex index, StringBuilder builder) {
        builder.append("ALTER TABLE ");
        builder.append(index.getTable());
        builder.append(" ADD CONSTRAINT ");
        builder.append(index);
        builder.append(" PRIMARY KEY");
    }

    protected void createIndex(IDBIndex index, StringBuilder builder) {
        builder.append("CREATE ");
        if (index.getType() == IDBIndex.Type.UNIQUE) {
            builder.append("UNIQUE ");
        }
        builder.append("INDEX ");
        builder.append(index);
        builder.append(" ON ");
        builder.append(index.getTable());
    }

    protected void createIndexFields(IDBIndex index, StringBuilder builder) {
        builder.append(" (");
        IDBField[] fields = index.getFields();
        int i = 0;
        while (i < fields.length) {
            if (i != 0) {
                builder.append(", ");
            }
            this.addIndexField(builder, fields[i]);
            ++i;
        }
        builder.append(")");
    }

    protected void dropIndex(Connection connection, IDBIndex index, IDBIndexDelta delta) {
        StringBuilder builder = new StringBuilder();
        if (index.getType() == IDBIndex.Type.PRIMARY_KEY) {
            this.dropPrimaryKey(index, builder);
        } else {
            this.dropIndex(index, builder);
        }
        DBUtil.execute(connection, builder);
    }

    protected void dropPrimaryKey(IDBIndex index, StringBuilder builder) {
        builder.append("ALTER TABLE ");
        builder.append(index.getTable());
        builder.append(" DROP CONSTRAINT ");
        builder.append(index);
    }

    protected void dropIndex(IDBIndex index, StringBuilder builder) {
    }

    @Override
    public Set<IDBTable> createTables(Iterable<? extends IDBTable> tables, Connection connection) throws DBException {
        HashSet<IDBTable> createdTables = new HashSet<IDBTable>();
        for (IDBTable iDBTable : tables) {
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    if (!this.createTable(iDBTable, statement)) continue;
                    createdTables.add(iDBTable);
                }
                catch (SQLException ex) {
                    throw new DBException(ex);
                }
            }
            finally {
                DBUtil.close(statement);
            }
        }
        return createdTables;
    }

    @Override
    public boolean createTable(IDBTable table, Statement statement) throws DBException {
        boolean created;
        block2: {
            created = true;
            try {
                this.doCreateTable(table, statement);
            }
            catch (SQLException ex) {
                created = false;
                if (!TRACER.isEnabled()) break block2;
                TRACER.trace("-- " + ex.getMessage());
            }
        }
        this.validateTable(table, statement);
        return created;
    }

    @Override
    public Collection<IDBTable> dropTables(Iterable<? extends IDBTable> tables, Connection connection) throws DBException {
        ArrayList<IDBTable> droppedTables = new ArrayList<IDBTable>();
        for (IDBTable iDBTable : tables) {
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    if (this.dropTable(iDBTable, statement)) {
                        droppedTables.add(iDBTable);
                    }
                }
                catch (SQLException ex) {
                    OM.LOG.error((Throwable)ex);
                    DBUtil.close(statement);
                    continue;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
            DBUtil.close(statement);
        }
        return droppedTables;
    }

    @Override
    public boolean dropTable(IDBTable table, Statement statement) {
        try {
            String sql = this.getDropTableSQL(table);
            if (TRACER.isEnabled()) {
                TRACER.trace(sql);
            }
            statement.execute(sql);
            return true;
        }
        catch (SQLException ex) {
            if (TRACER.isEnabled()) {
                TRACER.trace(ex.getMessage());
            }
            return false;
        }
    }

    protected String getDropTableSQL(IDBTable table) {
        return "DROP TABLE " + table;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxFieldNameLength() {
        return 128;
    }

    @Override
    public int getFieldLength(DBType type) {
        return DBAdapter.getDefaultDBLength(type);
    }

    @Override
    public boolean isTypeIndexable(DBType type) {
        switch (type) {
            case LONGVARCHAR: 
            case CLOB: 
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: 
            case BLOB: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "-" + this.getVersion();
    }

    public String convertString(PreparedStatement preparedStatement, int parameterIndex, String value) {
        return value;
    }

    public String convertString(ResultSet resultSet, int columnIndex, String value) {
        return value;
    }

    public String convertString(ResultSet resultSet, String columnLabel, String value) {
        return value;
    }

    protected void doCreateTable(IDBTable table, Statement statement) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        builder.append(table);
        builder.append(" (");
        this.appendFieldDefs(builder, table, this.createFieldDefinitions(table));
        String constraints = this.createConstraints(table);
        if (constraints != null) {
            builder.append(", ");
            builder.append(constraints);
        }
        builder.append(")");
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        statement.execute(sql);
        IDBIndex[] indices = table.getIndices();
        int i = 0;
        while (i < indices.length) {
            block7: {
                InternalDBIndex index = (InternalDBIndex)indices[i];
                try {
                    this.createIndex(index, statement, i);
                }
                catch (SQLException ex) {
                    if (!index.isOptional()) {
                        throw ex;
                    }
                }
                catch (RuntimeException ex) {
                    if (index.isOptional()) break block7;
                    throw ex;
                }
            }
            ++i;
        }
    }

    protected void createIndex(IDBIndex index, Statement statement, int num) throws SQLException {
        IDBTable table = index.getTable();
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (index.getType() == IDBIndex.Type.UNIQUE || index.getType() == IDBIndex.Type.PRIMARY_KEY) {
            builder.append("UNIQUE ");
        }
        builder.append("INDEX ");
        builder.append(index);
        builder.append(" ON ");
        builder.append(table);
        this.createIndexFields(index, builder);
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        statement.execute(sql);
    }

    protected void addIndexField(StringBuilder builder, IDBField field) {
        builder.append(field);
    }

    protected String createConstraints(IDBTable table) {
        return null;
    }

    protected String createFieldDefinition(IDBField field) {
        String nullable;
        String fieldDefinition = this.getTypeName(field);
        String string = nullable = field.isNotNull() ? "NOT NULL" : this.getNullableConstraint();
        if (!StringUtil.isEmpty((String)nullable)) {
            fieldDefinition = String.valueOf(fieldDefinition) + " " + nullable;
        }
        return fieldDefinition;
    }

    protected String getNullableConstraint() {
        return NULLABLE_DEFAULT;
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BOOLEAN: 
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case LONGVARCHAR: 
            case CLOB: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case LONGVARBINARY: 
            case BLOB: {
                return type.toString();
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return String.valueOf(type.toString()) + field.formatPrecision();
            }
            case NUMERIC: 
            case DECIMAL: {
                return String.valueOf(type.toString()) + field.formatPrecisionAndScale();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    public String[] getSQL92ReservedWords() {
        return SQL92_RESERVED_WORDS;
    }

    @Override
    public boolean isReservedWord(String word) {
        if (this.reservedWords == null) {
            this.reservedWords = new HashSet<String>();
            String[] stringArray = this.getReservedWords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String reservedWord = stringArray[n2];
                this.reservedWords.add(reservedWord.toUpperCase());
                ++n2;
            }
        }
        word = word.toUpperCase();
        return this.reservedWords.contains(word);
    }

    protected void validateTable(IDBTable table, Statement statement) throws DBException {
        int maxRows = 1;
        try {
            maxRows = statement.getMaxRows();
            statement.setMaxRows(1);
            String sql = null;
            try {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append("SELECT ");
                    this.appendFieldNames(builder, table);
                    builder.append(" FROM ");
                    builder.append(table);
                    sql = builder.toString();
                    if (TRACER.isEnabled()) {
                        TRACER.format("{0}", new Object[]{sql});
                    }
                    ResultSet resultSet = statement.executeQuery(sql);
                    try {
                        ResultSetMetaData metaData = resultSet.getMetaData();
                        int columnCount = metaData.getColumnCount();
                        if (columnCount != table.getFieldCount()) {
                            throw new DBException("DBTable " + table + " has " + columnCount + " columns instead of " + table.getFieldCount());
                        }
                    }
                    finally {
                        DBUtil.close(resultSet);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException("Problem with table " + table, ex, sql);
                }
            }
            finally {
                if (maxRows != 1) {
                    statement.setMaxRows(maxRows);
                }
            }
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    protected String[] createFieldDefinitions(IDBTable table) {
        IDBField[] fields = table.getFields();
        int fieldCount = fields.length;
        String[] result = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            IDBField field = fields[i];
            result[i] = this.createFieldDefinition(field);
            ++i;
        }
        return result;
    }

    public void appendFieldNames(Appendable appendable, IDBTable table) {
        try {
            IDBField[] fields = table.getFields();
            int i = 0;
            while (i < fields.length) {
                IDBField field = fields[i];
                if (i != 0) {
                    appendable.append(", ");
                }
                String fieldName = field.getName();
                appendable.append(fieldName);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void appendFieldDefs(Appendable appendable, IDBTable table, String[] defs) {
        try {
            IDBField[] fields = table.getFields();
            int i = 0;
            while (i < fields.length) {
                IDBField field = fields[i];
                if (i != 0) {
                    appendable.append(", ");
                }
                appendable.append(field.toString());
                appendable.append(" ");
                appendable.append(defs[i]);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public DBType adaptType(DBType type) {
        return type;
    }

    @Override
    public boolean isValidFirstChar(char ch) {
        return true;
    }

    @Override
    public boolean isDuplicateKeyException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "23001".equals(sqlState);
    }

    @Override
    public boolean isTableNotFoundException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "42S02".equals(sqlState);
    }

    @Override
    public boolean isColumnNotFoundException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "42S22".equals(sqlState);
    }

    @Override
    public String sqlRenameField(IDBField field, String oldName) {
        return "ALTER TABLE " + field.getTable() + " RENAME COLUMN " + oldName + " TO " + field;
    }

    @Override
    public String sqlModifyField(IDBField field) {
        String tableName = field.getTable().getName();
        String fieldName = field.getName();
        String definition = this.createFieldDefinition(field);
        return this.sqlModifyField(tableName, fieldName, definition);
    }

    protected String sqlModifyField(String tableName, String fieldName, String definition) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + fieldName + " " + definition;
    }

    @Override
    public String sqlCharIndex(Object substring, Object string) {
        return String.valueOf(this.sqlCharIndexFunction()) + "(" + substring + ", " + string + ")";
    }

    protected String sqlCharIndexFunction() {
        return "CHARINDEX";
    }

    @Override
    public String sqlSubstring(Object string, Object startIndex, Object length) {
        String sql = String.valueOf(this.sqlSubstringFunction()) + "(" + string + ", " + startIndex;
        if (length != null) {
            sql = String.valueOf(sql) + ", " + length;
        }
        return String.valueOf(sql) + ")";
    }

    @Override
    public String sqlSubstring(Object string, Object startIndex) {
        return this.sqlSubstring(string, startIndex, null);
    }

    protected String sqlSubstringFunction() {
        return "SUBSTRING";
    }

    @Override
    public String sqlConcat(Object ... strings) {
        StringJoiner joiner = new StringJoiner(" || ");
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            if (string != null) {
                joiner.add(string.toString());
            }
            ++n2;
        }
        return joiner.toString();
    }

    public String format(PreparedStatement stmt) {
        return stmt.toString();
    }

    public String format(ResultSet resultSet) {
        try {
            StringBuilder builder = new StringBuilder();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(metaData.getColumnName(i + 1).toLowerCase());
                builder.append("=");
                builder.append(resultSet.getObject(i + 1));
                ++i;
            }
            return builder.toString();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public Object convertToSQL(Object value) {
        return value;
    }

    public static void getIndexInfos(DatabaseMetaData metaData, String schemaName, String tableName, Consumer<IndexInfo> consumer) throws SQLException {
        Connection connection = metaData.getConnection();
        String catalog = connection.getCatalog();
        ResultSet primaryKeys = metaData.getPrimaryKeys(catalog, schemaName, tableName);
        DBAdapter.getIndexInfos(primaryKeys, 6, 0, 4, 5, consumer);
        ResultSet indexInfo = metaData.getIndexInfo(catalog, schemaName, tableName, false, true);
        DBAdapter.getIndexInfos(indexInfo, 6, 4, 9, 8, consumer);
    }

    private static void getIndexInfos(ResultSet resultSet, int indexNameColumn, int indexTypeColumn, int fieldNameColumn, int fieldPositionColumn, Consumer<IndexInfo> consumer) throws SQLException {
        HashMap<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
        try {
            while (resultSet.next()) {
                String name = resultSet.getString(indexNameColumn);
                if (name == null) continue;
                IDBIndex.Type indexType = IDBIndex.Type.PRIMARY_KEY;
                if (indexTypeColumn != 0) {
                    boolean nonUnique = resultSet.getBoolean(indexTypeColumn);
                    indexType = nonUnique ? IDBIndex.Type.NON_UNIQUE : IDBIndex.Type.UNIQUE;
                }
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.name = resultSet.getString(fieldNameColumn);
                fieldInfo.position = resultSet.getShort(fieldPositionColumn);
                IndexInfo indexInfo2 = indexInfos.computeIfAbsent(name, key -> new IndexInfo());
                indexInfo2.name = name;
                indexInfo2.type = indexType;
                indexInfo2.fieldInfos.add(fieldInfo);
            }
        }
        finally {
            DBUtil.close(resultSet);
        }
        indexInfos.values().forEach(indexInfo -> {
            indexInfo.fieldInfos.sort(null);
            consumer.accept((IndexInfo)indexInfo);
        });
    }

    public static int getDefaultDBLength(DBType type) {
        return type == DBType.VARCHAR ? 32672 : -1;
    }

    protected static void generateReservedWords(Connection connection, String[] words) throws SQLException {
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            try {
                String sql = "CREATE TABLE table" + i + " (" + word + " INT)";
                DBUtil.execute(connection, sql);
            }
            catch (Exception ex) {
                if (i != 0) {
                    System.out.print(", ");
                }
                System.out.println("\"" + word + "\"");
            }
            ++i;
        }
    }

    @Deprecated
    protected void readIndices(Connection connection, ResultSet resultSet, IDBTable table, int indexNameColumn, int indexTypeColumn, int fieldNameColumn, int fieldPositionColumn) throws SQLException {
        DBAdapter.getIndexInfos(resultSet, indexNameColumn, indexTypeColumn, fieldNameColumn, fieldPositionColumn, indexInfo -> this.addIndex(connection, table, indexInfo.name, indexInfo.type, indexInfo.fieldInfos));
    }

    @Deprecated
    protected void createField(Connection connection, String tableName, IDBField field) {
        this.createField(connection, field);
    }

    @Deprecated
    protected void dropField(Connection connection, String tableName, String fieldName) {
        DBUtil.execute(connection, "ALTER TABLE " + tableName + " DROP COLUMN " + fieldName);
    }

    @Override
    @Deprecated
    public Driver getJDBCDriver() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public DataSource createJDBCDataSource() {
        throw new UnsupportedOperationException();
    }

    public static final class FieldInfo
    implements Comparable<FieldInfo> {
        public String name;
        public int position;

        @Override
        public int compareTo(FieldInfo o) {
            return this.position - o.position;
        }
    }

    public static final class IndexInfo {
        public String name;
        public IDBIndex.Type type;
        public List<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
    }
}

