/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.ICrypter;
import org.eclipse.net4j.util.security.IUserManagement;
import org.eclipse.net4j.util.security.SecurityUtil;

public class FileUserAuthenticator
extends IRepositoryProtector.UserAuthenticator
implements IUserManagement,
Entity.Store.Provider {
    private static final Map<String, String> NO_ATTRIBUTES = Collections.emptyMap();
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_\\-.]*) *= *(.*)");
    private Path path;
    private boolean portable;
    private ICrypter passwordCrypter;
    private FileTime fileModifiedTime;
    private final Map<String, FileUserInfo> userInfos = new HashMap<String, FileUserInfo>();
    private final FileEntityStore entityStore = new FileEntityStore();

    @Override
    public Class<? extends IRepositoryProtector.UserInfo> getUserInfoClass() {
        return FileUserInfo.class;
    }

    public final Path getPath() {
        return this.path;
    }

    @AnnotationFactory.InjectAttribute(name="path")
    public final void setPath(Path path) {
        this.checkInactive();
        this.path = path;
    }

    public final boolean isPortable() {
        return this.portable;
    }

    @AnnotationFactory.InjectAttribute(name="portable")
    public final void setPortable(boolean portable) {
        this.checkInactive();
        this.portable = portable;
    }

    public final ICrypter getPasswordCrypter() {
        return this.passwordCrypter;
    }

    @AnnotationFactory.InjectElement(name="passwordCrypter", productGroup="org.eclipse.net4j.util.security.crypters", descriptionAttribute="params")
    public final void setPasswordCrypter(ICrypter passwordCrypter) {
        this.checkInactive();
        this.passwordCrypter = passwordCrypter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userID, char[] password) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            if (this.userInfos.containsKey(userID)) {
                throw new IllegalStateException("User " + userID + " does already exist");
            }
            String convertedPassword = this.convertPassword(password);
            this.userInfos.put(userID, new FileUserInfo(userID, convertedPassword, false));
            try {
                this.saveFile();
            }
            catch (Exception ex) {
                this.userInfos.remove(userID);
                throw WrappedException.wrap((Exception)ex);
            }
            catch (Error ex) {
                this.userInfos.remove(userID);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userID) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            FileUserInfo userInfo = this.userInfos.remove(userID);
            if (userInfo == null) {
                throw new IllegalStateException("User " + userID + " does not exist");
            }
            try {
                this.saveFile();
            }
            catch (Exception ex) {
                this.userInfos.put(userID, userInfo);
                throw WrappedException.wrap((Exception)ex);
            }
            catch (Error ex) {
                this.userInfos.put(userID, userInfo);
                throw ex;
            }
        }
    }

    public void setPassword(String userID, char[] newPassword) {
        this.checkActive();
        this.modifyUser(userID, oldUserInfo -> new FileUserInfo(userID, this.convertPassword(newPassword), oldUserInfo.administrator(), oldUserInfo.attributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdministrator(String userID) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            try {
                this.reconcileFile();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            FileUserInfo userInfo = this.userInfos.get(userID);
            return userInfo != null && userInfo.administrator();
        }
    }

    public void setAdministrator(String userID, boolean administrator) {
        this.checkActive();
        this.modifyUser(userID, oldUserInfo -> new FileUserInfo(userID, ((FileUserInfo)oldUserInfo).convertedPassword, administrator, oldUserInfo.attributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAttributes(String userID) {
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            try {
                this.reconcileFile();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            FileUserInfo userInfo = this.userInfos.get(userID);
            if (userInfo != null) {
                return userInfo.attributes();
            }
            return NO_ATTRIBUTES;
        }
    }

    public void setAttributes(String userID, Map<String, String> attributes) {
        this.checkActive();
        this.modifyUser(userID, oldUserInfo -> new FileUserInfo(userID, ((FileUserInfo)oldUserInfo).convertedPassword, oldUserInfo.administrator(), attributes));
    }

    public Entity.Store getEntityStore() {
        return this.entityStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUserInfo authenticateUser(String userID, char[] password) {
        String convertedPassword;
        FileUserInfo userInfo;
        this.checkActive();
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            try {
                this.reconcileFile();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            userInfo = this.userInfos.get(userID);
            if (userInfo == null) {
                return null;
            }
        }
        String storedPassword = userInfo.convertedPassword;
        if (storedPassword == null) {
            return null;
        }
        ICrypter crypter = this.passwordCrypter;
        if (this.portable && storedPassword.startsWith("$")) {
            String config = storedPassword.substring(1);
            int firstDollar = config.indexOf(36);
            int lastDollar = config.lastIndexOf(36);
            if (firstDollar != -1 && lastDollar != -1) {
                String type = config.substring(0, firstDollar);
                String params = firstDollar == lastDollar ? null : config.substring(firstDollar + 1, lastDollar);
                crypter = (ICrypter)this.getContainer().getElement("org.eclipse.net4j.util.security.crypters", type, params);
            }
        }
        if ((convertedPassword = this.convertPassword(password, crypter)) == null) {
            return null;
        }
        if (!Objects.equals(convertedPassword, storedPassword)) {
            return null;
        }
        return userInfo;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.path, "path");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.passwordCrypter);
        this.reconcileFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            this.userInfos.clear();
            this.fileModifiedTime = null;
        }
        LifecycleUtil.deactivate((Object)this.passwordCrypter);
        super.doDeactivate();
    }

    protected final void saveFile() throws Exception {
        ArrayList<FileUserInfo> list = new ArrayList<FileUserInfo>(this.userInfos.values());
        list.sort(null);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            for (FileUserInfo userInfo : list) {
                String line = FileUserAuthenticator.toLine(userInfo);
                writer.write(line);
                writer.write(StringUtil.NL);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fileModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void reconcileFile() throws Exception {
        if (!Files.exists(this.path, new LinkOption[0])) {
            Files.createFile(this.path, new FileAttribute[0]);
            this.fileModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            this.userInfos.clear();
            return;
        }
        FileTime lastModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
        if (this.fileModifiedTime != null) {
            if (this.fileModifiedTime.compareTo(lastModifiedTime) >= 0) return;
        }
        this.fileModifiedTime = lastModifiedTime;
        this.userInfos.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return;
                }
                try {
                    FileUserInfo userInfo = FileUserAuthenticator.parseLine(line);
                    if (userInfo == null) continue;
                    this.userInfos.put(userInfo.userID(), userInfo);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyUser(String userID, Function<FileUserInfo, FileUserInfo> modifier) {
        Map<String, FileUserInfo> map = this.userInfos;
        synchronized (map) {
            FileUserInfo oldUserInfo = this.userInfos.remove(userID);
            if (oldUserInfo == null) {
                throw new IllegalStateException("User " + userID + " does not exist");
            }
            FileUserInfo newUserInfo = modifier.apply(oldUserInfo);
            this.userInfos.put(userID, newUserInfo);
            try {
                this.saveFile();
            }
            catch (Exception ex) {
                this.userInfos.put(userID, oldUserInfo);
                throw WrappedException.wrap((Exception)ex);
            }
            catch (Error ex) {
                this.userInfos.put(userID, oldUserInfo);
                throw ex;
            }
        }
    }

    private String convertPassword(char[] password) {
        return this.convertPassword(password, this.passwordCrypter);
    }

    private String convertPassword(char[] password, ICrypter crypter) {
        String convertedPassword = SecurityUtil.toString((char[])password);
        if (crypter != null) {
            byte[] data = convertedPassword.getBytes(StandardCharsets.UTF_8);
            byte[] crypted = crypter.apply(data);
            convertedPassword = Base64.getEncoder().encodeToString(crypted);
            if (this.portable) {
                convertedPassword = FileUserAuthenticator.makePortable(convertedPassword, crypter);
            }
        }
        return convertedPassword;
    }

    private static String toLine(FileUserInfo userInfo) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.escape((String)userInfo.userID(), (char)':'));
        builder.append(':');
        builder.append(StringUtil.escape((String)userInfo.convertedPassword, (char)':'));
        boolean administrator = userInfo.administrator();
        Map<String, String> attributes = userInfo.attributes();
        if (administrator || !attributes.isEmpty()) {
            builder.append(':');
            if (administrator) {
                builder.append("true");
            }
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                builder.append(':');
                builder.append(StringUtil.escape((String)entry.getKey()));
                builder.append('=');
                builder.append(StringUtil.escape((String)entry.getValue()));
            }
        }
        return builder.toString();
    }

    private static FileUserInfo parseLine(String line) {
        String[] tokens;
        int length;
        if (!StringUtil.isEmpty((String)(line = line.trim())) && !line.startsWith("#") && (length = (tokens = line.split(":")).length) > 0) {
            String userID = FileUserAuthenticator.unescape(tokens[0]);
            String convertedPassword = length > 1 ? FileUserAuthenticator.unescape(tokens[1]) : null;
            boolean administrator = length > 2 ? StringUtil.isTrue((String)FileUserAuthenticator.unescape(tokens[2])) : false;
            HashMap<String, String> attributes = new HashMap<String, String>();
            int i = 3;
            while (i < length) {
                String attribute = FileUserAuthenticator.unescape(tokens[i]);
                FileUserAuthenticator.parseAttribute(attribute, attributes);
                ++i;
            }
            return new FileUserInfo(userID, convertedPassword, administrator, attributes);
        }
        return null;
    }

    private static String unescape(String token) {
        return StringUtil.unescape((String)token, (char)':').trim();
    }

    private static void parseAttribute(String attribute, Map<String, String> attributes) {
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(attribute);
        if (matcher.matches()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            attributes.put(name, value);
        }
    }

    private static String makePortable(String convertedPassword, ICrypter crypter) {
        String prefix = "$" + StringUtil.escape((String)crypter.getType(), (char)'$') + "$";
        String params = crypter.getParams();
        if (params != null) {
            prefix = String.valueOf(prefix) + StringUtil.escape((String)params, (char)'$') + "$";
        }
        return String.valueOf(prefix) + convertedPassword;
    }

    public static void checkValidAttribute(String name, String value) {
        String attribute = String.valueOf(name) + "=" + value;
        if (!ATTRIBUTE_PATTERN.matcher(attribute).matches()) {
            throw new IllegalArgumentException("Illegal attribute: " + attribute);
        }
    }

    private final class FileEntityStore
    extends Entity.SingleNamespaceComputer {
        public FileEntityStore() {
            super("cdo/user/info");
        }

        protected Collection<String> computeNames() {
            return Collections.emptySet();
        }

        protected Entity computeEntity(String name) {
            FileUserInfo userInfo = (FileUserInfo)FileUserAuthenticator.this.userInfos.get(name);
            if (userInfo != null) {
                Map<String, String> attributes = userInfo.attributes();
                Entity.Builder builder = this.entityBuilder(name);
                String[] stringArray = CDOProtocolConstants.USER_INFO_PROPERTIES;
                int n = CDOProtocolConstants.USER_INFO_PROPERTIES.length;
                int n2 = 0;
                while (n2 < n) {
                    String propertyName = stringArray[n2];
                    String attribute = attributes.get(propertyName);
                    if (attribute != null) {
                        builder.property(propertyName, attribute);
                    }
                    ++n2;
                }
                return builder.build();
            }
            return null;
        }
    }

    public static class FileUserInfo
    extends IRepositoryProtector.UserInfo {
        private final String convertedPassword;
        private final boolean administrator;
        private final Map<String, String> attributes;

        public FileUserInfo(String userID, String convertedPassword, boolean administrator) {
            this(userID, convertedPassword, administrator, null);
        }

        public FileUserInfo(String userID, String convertedPassword, boolean administrator, Map<String, String> attributes) {
            super(userID);
            this.convertedPassword = convertedPassword;
            this.administrator = administrator;
            this.attributes = ObjectUtil.isEmpty(attributes) ? NO_ATTRIBUTES : Collections.unmodifiableMap(new HashMap<String, String>(attributes));
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                FileUserAuthenticator.checkValidAttribute(entry.getKey(), entry.getValue());
            }
        }

        public final boolean administrator() {
            return this.administrator;
        }

        public final Map<String, String> attributes() {
            return this.attributes;
        }

        @Override
        protected boolean isStructurallyEqual(IRepositoryProtector.UserInfo userInfo) {
            FileUserInfo other = (FileUserInfo)userInfo;
            return this.administrator == other.administrator && this.attributes.equals(other.attributes);
        }
    }
}

