/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui;

import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPluginImages;
import org.eclipse.pde.internal.ui.util.SharedLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PDEUserAssistanceLabelProvider
extends SharedLabelProvider {
    public String getText(Object obj) {
        if (obj instanceof ISimpleCSObject) {
            return this.getObjectText((ISimpleCSObject)obj);
        }
        if (obj instanceof ICompCSObject) {
            return this.getObjectText((ICompCSObject)obj);
        }
        if (obj instanceof TocObject) {
            return this.getObjectText((TocObject)obj);
        }
        if (obj instanceof CtxHelpObject) {
            return this.getObjectText((CtxHelpObject)obj);
        }
        return super.getText(obj);
    }

    public String getObjectText(ISimpleCSObject obj) {
        int limit = 50;
        if (obj.getType() == 0) {
            limit = 40;
        } else if (obj.getType() == 6) {
            limit = 36;
        } else if (obj.getType() == 5) {
            limit = 36;
        } else if (obj.getType() == 10) {
            limit = 32;
        }
        return PDETextHelper.truncateAndTrailOffText((String)PDETextHelper.translateReadText((String)obj.getName()), (int)limit);
    }

    public String getObjectText(ICompCSObject obj) {
        int limit = 40;
        ICompCSObject parent = obj.getParent();
        while (parent != null) {
            limit -= 4;
            parent = parent.getParent();
        }
        return PDETextHelper.truncateAndTrailOffText((String)PDETextHelper.translateReadText((String)obj.getName()), (int)limit);
    }

    public String getObjectText(TocObject obj) {
        return PDETextHelper.translateReadText((String)obj.getName());
    }

    public String getObjectText(CtxHelpObject obj) {
        return PDETextHelper.translateReadText((String)obj.getName());
    }

    public Image getImage(Object obj) {
        if (obj instanceof ISimpleCSObject) {
            return this.getObjectImage((ISimpleCSObject)obj);
        }
        if (obj instanceof ICompCSObject) {
            return this.getObjectImage((ICompCSObject)obj);
        }
        if (obj instanceof TocObject) {
            return this.getObjectImage((TocObject)obj);
        }
        if (obj instanceof CtxHelpObject) {
            return this.getObjectImage((CtxHelpObject)obj);
        }
        return super.getImage(obj);
    }

    private Image getObjectImage(ISimpleCSObject object) {
        if (object.getType() == 6) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSITEM_OBJ);
        }
        if (object.getType() == 10) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSSUBITEM_OBJ);
        }
        if (object.getType() == 9) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSUNSUPPORTED_OBJ);
        }
        if (object.getType() == 3) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSUNSUPPORTED_OBJ);
        }
        if (object.getType() == 0) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_SIMPLECS_OBJ);
        }
        if (object.getType() == 5) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSINTRO_OBJ);
        }
        if (object.getType() == 8) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSUNSUPPORTED_OBJ);
        }
        return this.get(PDEUserAssistanceUIPluginImages.DESC_SIMPLECS_OBJ, 1);
    }

    private Image getObjectImage(ICompCSObject object) {
        if (object.getType() == 2) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_SIMPLECS_OBJ);
        }
        if (object.getType() == 1) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_CSTASKGROUP_OBJ);
        }
        if (object.getType() == 0) {
            return this.get(PDEUserAssistanceUIPluginImages.DESC_COMPCS_OBJ);
        }
        return this.get(PDEUserAssistanceUIPluginImages.DESC_SIMPLECS_OBJ, 1);
    }

    private Image getObjectImage(TocObject object) {
        switch (object.getType()) {
            case 0: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_OBJ);
            }
            case 1: {
                if (object.getChildren().isEmpty()) {
                    return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_LEAFTOPIC_OBJ);
                }
                return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_TOPIC_OBJ);
            }
            case 3: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_LINK_OBJ);
            }
            case 2: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_ANCHOR_OBJ);
            }
        }
        return this.get(PDEUserAssistanceUIPluginImages.DESC_SIMPLECS_OBJ, 1);
    }

    private Image getObjectImage(CtxHelpObject object) {
        switch (object.getType()) {
            case 0: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_OBJ);
            }
            case 1: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_CTXHELP_CONTEXT_OBJ);
            }
            case 2: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_CTXHELP_DESC_OBJ);
            }
            case 3: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_TOC_LEAFTOPIC_OBJ);
            }
            case 4: {
                return this.get(PDEUserAssistanceUIPluginImages.DESC_CTXHELP_COMMAND_OBJ);
            }
        }
        return this.get(PDEUserAssistanceUIPluginImages.DESC_SIMPLECS_OBJ, 1);
    }
}

