/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.eclipse.net4j.util.WrappedException;

public final class BufferUtil {
    public static final String UTF8_CHAR_SET_NAME = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final byte FALSE = 0;
    private static final byte TRUE = 1;
    private static final short NULL_STRING = -1;

    private BufferUtil() {
    }

    @Deprecated
    public static byte[] toUTF8(String str) {
        String test;
        byte[] bytes;
        if (str == null) {
            return new byte[0];
        }
        try {
            bytes = str.getBytes(UTF8_CHAR_SET_NAME);
            test = new String(bytes, UTF8_CHAR_SET_NAME);
        }
        catch (UnsupportedEncodingException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        if (!test.equals(str)) {
            throw new IllegalArgumentException("String not encodable: " + str);
        }
        return bytes;
    }

    @Deprecated
    public static String fromUTF8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_CHAR_SET_NAME);
        }
        catch (UnsupportedEncodingException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Deprecated
    public static void putUTF8(ByteBuffer byteBuffer, String str) {
        BufferUtil.putString(byteBuffer, str, false);
    }

    public static void putObject(ByteBuffer byteBuffer, Object object) throws IOException {
        if (object != null) {
            byteBuffer.put((byte)1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(baos);
            stream.writeObject(object);
            byte[] array = baos.toByteArray();
            BufferUtil.putByteArray(byteBuffer, array);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public static Object getObject(ByteBuffer byteBuffer) throws IOException, ClassNotFoundException {
        boolean nonNull;
        boolean bl = nonNull = byteBuffer.get() == 1;
        if (nonNull) {
            byte[] array = BufferUtil.getByteArray(byteBuffer);
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            ObjectInputStream stream = new ObjectInputStream(bais);
            return stream.readObject();
        }
        return null;
    }

    public static void putByteArray(ByteBuffer byteBuffer, byte[] array) {
        short length = array == null ? (short)0 : (short)array.length;
        byteBuffer.putShort(length);
        if (length != 0) {
            byteBuffer.put(array);
        }
    }

    public static byte[] getByteArray(ByteBuffer byteBuffer) {
        short length = byteBuffer.getShort();
        byte[] array = new byte[length];
        if (length != 0) {
            byteBuffer.get(array);
        }
        return array;
    }

    public static void putString(ByteBuffer byteBuffer, String str, boolean bestEffort) {
        int sizePosition = byteBuffer.position();
        byteBuffer.putShort((short)-1);
        if (str != null) {
            CoderResult result;
            CharsetEncoder encoder = CHARSET.newEncoder();
            CharBuffer input = CharBuffer.wrap(str);
            int start = byteBuffer.position();
            int max = -1;
            while ((result = encoder.encode(input, byteBuffer, true)).isError()) {
                if (result.isOverflow() && bestEffort) {
                    max = max == -1 ? (int)((float)byteBuffer.remaining() / encoder.maxBytesPerChar()) : --max;
                    if (max > 0) {
                        str = str.substring(0, max);
                        byteBuffer.position(start);
                        continue;
                    }
                }
                try {
                    result.throwException();
                    break;
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
            int end = byteBuffer.position();
            short size = (short)Math.abs(end - start);
            byteBuffer.position(sizePosition);
            byteBuffer.putShort(size);
            byteBuffer.position(end);
        }
    }

    public static String getString(ByteBuffer byteBuffer) {
        short size = byteBuffer.getShort();
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return "";
        }
        byte[] bytes = new byte[size];
        byteBuffer.get(bytes);
        try {
            return new String(bytes, UTF8_CHAR_SET_NAME);
        }
        catch (UnsupportedEncodingException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }
}

