/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.FieldInfo;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalNonAuditMappingStrategy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class NonAuditListTableMapping
extends AbstractListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, NonAuditListTableMapping.class);
    private String sqlClear;
    private String sqlUpdateValue;
    private String sqlUpdateIndex;
    private String sqlInsertValue;
    private String sqlDeleteItem;
    private String sqlShiftDownIndex;
    private String sqlReadCurrentIndexOffset;
    private String sqlShiftUpIndex;

    public NonAuditListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
    }

    @Override
    protected void initSQLStrings() {
        super.initSQLStrings();
        IDBTable table = this.getTable();
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(table);
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=?");
        this.sqlClear = builder.toString();
        builder.append(" AND ");
        builder.append(this.indexField);
        builder.append("=?");
        this.sqlDeleteItem = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.valueField);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=?");
        this.sqlUpdateValue = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append(" (");
        builder.append(this.sourceField);
        builder.append(", ");
        builder.append(this.indexField);
        builder.append(", ");
        builder.append(this.valueField);
        builder.append(") VALUES(?, ?, ?)");
        this.sqlInsertValue = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.indexField);
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.indexField);
        builder.append("=");
        builder.append(this.indexField);
        builder.append("+? WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.indexField);
        builder.append(" BETWEEN ? AND ?");
        builder.append(" /*! ORDER BY ");
        builder.append(this.indexField);
        this.sqlShiftDownIndex = String.valueOf(builder.toString()) + " */";
        builder.append(" DESC");
        this.sqlShiftUpIndex = String.valueOf(builder.toString()) + " */";
        builder = new StringBuilder();
        builder.append("SELECT MIN(");
        builder.append(this.indexField);
        builder.append(") FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=?");
        this.sqlReadCurrentIndexOffset = builder.toString();
    }

    @Override
    public void addSimpleChunkWhere(IDBStoreAccessor accessor, CDOID cdoid, StringBuilder builder, int index) {
        int offset = this.getCurrentIndexOffset(accessor, cdoid);
        super.addSimpleChunkWhere(accessor, cdoid, builder, index + offset);
    }

    @Override
    public void addRangedChunkWhere(IDBStoreAccessor accessor, CDOID cdoid, StringBuilder builder, int fromIndex, int toIndex) {
        int offset = this.getCurrentIndexOffset(accessor, cdoid);
        super.addRangedChunkWhere(accessor, cdoid, builder, fromIndex + offset, toIndex + offset);
    }

    @Override
    protected void addKeyFields(List<FieldInfo> list) {
    }

    @Override
    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        idHandler.setCDOID(stmt, 1, revision.getID());
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        this.clearList(accessor, id);
    }

    @Override
    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        this.clearList(accessor, id);
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        if (this.getTable() == null) {
            this.initTable(accessor);
        }
        List listChanges = delta.getListChanges();
        int oldListSize = delta.getOriginSize();
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for object {0} - original list size: {1}", new Object[]{id, oldListSize});
        }
        ListDeltaWriter writer = new ListDeltaWriter(accessor, id, listChanges, oldListSize);
        writer.writeListDeltas();
    }

    private void clearList(IDBStoreAccessor accessor, CDOID id) {
        if (this.getTable() == null) {
            return;
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlClear, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private int getCurrentIndexOffset(IDBStoreAccessor accessor, CDOID id) {
        int n;
        IDBResultSet rset;
        IDBPreparedStatement stmt;
        block6: {
            if (this.getTable() == null) {
                return 0;
            }
            IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
            stmt = accessor.getDBConnection().prepareStatement(this.sqlReadCurrentIndexOffset, IDBPreparedStatement.ReuseProbability.HIGH);
            rset = null;
            idHandler.setCDOID((PreparedStatement)stmt, 1, id);
            rset = stmt.executeQuery();
            if (rset.next()) break block6;
            DBUtil.close((ResultSet)rset);
            DBUtil.close((Statement)stmt);
            return 0;
        }
        try {
            n = rset.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rset);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rset);
        DBUtil.close((Statement)stmt);
        return n;
    }

    private final class ListDeltaWriter
    extends AbstractBasicListTableMapping.AbstractListDeltaWriter {
        private IDBPreparedStatement stmtDelete;
        private IDBPreparedStatement stmtMove;
        private IDBPreparedStatement stmtSet;
        private IDBPreparedStatement stmtInsert;
        private IDBPreparedStatement stmtShiftDown;
        private IDBPreparedStatement stmtShiftUp;
        private int countDelete;
        private int countMove;
        private int countSet;
        private int countInsert;
        private int countShiftDown;
        private int countShiftUp;

        public ListDeltaWriter(IDBStoreAccessor accessor, CDOID id, List<CDOFeatureDelta> listChanges, int oldListSize) {
            super(accessor, id, listChanges, oldListSize);
        }

        @Override
        protected boolean isZeroBasedIndex() {
            return ((HorizontalNonAuditMappingStrategy)NonAuditListTableMapping.this.getMappingStrategy()).shallForceZeroBasedIndex();
        }

        @Override
        protected ITypeMapping getTypeMapping() {
            return NonAuditListTableMapping.this.getTypeMapping();
        }

        @Override
        protected int getCurrentIndexOffset() {
            return NonAuditListTableMapping.this.getCurrentIndexOffset(this.accessor, this.id);
        }

        @Override
        protected void clearList() {
            NonAuditListTableMapping.this.clearList(this.accessor, this.id);
        }

        @Override
        protected void writeResultToDatabase() throws SQLException {
            try {
                super.writeResultToDatabase();
                if (this.countMove > 0) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} move operations", new Object[]{this.countMove});
                    }
                    DBUtil.executeBatch((PreparedStatement)this.stmtMove, (int)this.countMove);
                }
                if (this.countInsert > 0) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} insert operations", new Object[]{this.countInsert});
                    }
                    DBUtil.executeBatch((PreparedStatement)this.stmtInsert, (int)this.countInsert);
                }
                if (this.countSet > 0) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} set operations", new Object[]{this.countSet});
                    }
                    DBUtil.executeBatch((PreparedStatement)this.stmtSet, (int)this.countSet);
                }
            }
            catch (Throwable throwable) {
                ListDeltaWriter.close(new PreparedStatement[]{this.stmtDelete, this.stmtMove, this.stmtInsert, this.stmtSet});
                throw throwable;
            }
            ListDeltaWriter.close(new PreparedStatement[]{this.stmtDelete, this.stmtMove, this.stmtInsert, this.stmtSet});
        }

        @Override
        protected void writeShifts(IIDHandler idHandler) throws SQLException {
            if (this.countDelete > 0) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Performing {0} delete operations", new Object[]{this.countDelete});
                }
                DBUtil.executeBatch((PreparedStatement)this.stmtDelete, (int)this.countDelete);
            }
            if (this.countMove > 0) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Performing {0} move operations", new Object[]{this.countMove});
                }
                DBUtil.executeBatch((PreparedStatement)this.stmtMove, (int)this.countMove);
                this.countMove = 0;
            }
            super.writeShifts(idHandler);
        }

        @Override
        protected void writeShiftsDown(IIDHandler idHandler, ListIterator<AbstractBasicListTableMapping.AbstractListDeltaWriter.Shift> operationIt) throws SQLException {
            try {
                super.writeShiftsDown(idHandler, operationIt);
                if (this.countShiftDown > 0) {
                    DBUtil.executeBatch((PreparedStatement)this.stmtShiftDown, (int)this.countShiftDown, (boolean)false);
                }
            }
            catch (Throwable throwable) {
                ListDeltaWriter.close(new PreparedStatement[]{this.stmtShiftDown});
                throw throwable;
            }
            ListDeltaWriter.close(new PreparedStatement[]{this.stmtShiftDown});
        }

        @Override
        protected void writeShiftsUp(IIDHandler idHandler, ListIterator<AbstractBasicListTableMapping.AbstractListDeltaWriter.Shift> operationIt) throws SQLException {
            try {
                super.writeShiftsUp(idHandler, operationIt);
                if (this.countShiftUp > 0) {
                    DBUtil.executeBatch((PreparedStatement)this.stmtShiftUp, (int)this.countShiftUp, (boolean)false);
                }
            }
            catch (Throwable throwable) {
                ListDeltaWriter.close(new PreparedStatement[]{this.stmtShiftUp});
                throw throwable;
            }
            ListDeltaWriter.close(new PreparedStatement[]{this.stmtShiftUp});
        }

        @Override
        protected void dbDelete(IIDHandler idHandler, int index) throws SQLException {
            if (this.stmtDelete == null) {
                this.stmtDelete = this.accessor.getDBConnection().prepareStatement(NonAuditListTableMapping.this.sqlDeleteItem, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)this.stmtDelete, 1, this.id);
            }
            this.stmtDelete.setInt(2, index);
            this.stmtDelete.addBatch();
            ++this.countDelete;
        }

        @Override
        protected void dbMove(IIDHandler idHandler, int fromIndex, int toIndex, int srcIndex) throws SQLException {
            if (this.stmtMove == null) {
                this.stmtMove = this.accessor.getDBConnection().prepareStatement(NonAuditListTableMapping.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)this.stmtMove, 2, this.id);
            }
            this.stmtMove.setInt(3, fromIndex);
            this.stmtMove.setInt(1, toIndex);
            this.stmtMove.addBatch();
            ++this.countMove;
        }

        @Override
        protected void dbSet(IIDHandler idHandler, ITypeMapping typeMapping, int index, Object value, int srcIndex) throws SQLException {
            if (this.stmtSet == null) {
                this.stmtSet = this.accessor.getDBConnection().prepareStatement(NonAuditListTableMapping.this.sqlUpdateValue, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)this.stmtSet, 2, this.id);
            }
            this.stmtSet.setInt(3, index);
            typeMapping.setValue((PreparedStatement)this.stmtSet, 1, value);
            this.stmtSet.addBatch();
            ++this.countSet;
        }

        @Override
        protected void dbInsert(IIDHandler idHandler, ITypeMapping typeMapping, int index, Object value) throws SQLException {
            if (this.stmtInsert == null) {
                this.stmtInsert = this.accessor.getDBConnection().prepareStatement(NonAuditListTableMapping.this.sqlInsertValue, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)this.stmtInsert, 1, this.id);
            }
            this.stmtInsert.setInt(2, index);
            typeMapping.setValue((PreparedStatement)this.stmtInsert, 3, value);
            this.stmtInsert.addBatch();
            ++this.countInsert;
        }

        @Override
        protected void dbShiftDown(IIDHandler idHandler, int offset, int startIndex, int endIndex) throws SQLException {
            if (this.stmtShiftDown == null) {
                this.stmtShiftDown = this.accessor.getDBConnection().prepareStatement(NonAuditListTableMapping.this.sqlShiftDownIndex, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)this.stmtShiftDown, 2, this.id);
            }
            this.stmtShiftDown.setInt(1, offset);
            this.stmtShiftDown.setInt(3, startIndex);
            this.stmtShiftDown.setInt(4, endIndex);
            this.stmtShiftDown.addBatch();
            ++this.countShiftDown;
        }

        @Override
        protected void dbShiftUp(IIDHandler idHandler, int offset, int startIndex, int endIndex) throws SQLException {
            if (this.stmtShiftUp == null) {
                this.stmtShiftUp = this.accessor.getDBConnection().prepareStatement(NonAuditListTableMapping.this.sqlShiftUpIndex, IDBPreparedStatement.ReuseProbability.HIGH);
                idHandler.setCDOID((PreparedStatement)this.stmtShiftUp, 2, this.id);
            }
            this.stmtShiftUp.setInt(1, offset);
            this.stmtShiftUp.setInt(3, startIndex);
            this.stmtShiftUp.setInt(4, endIndex);
            this.stmtShiftUp.addBatch();
            ++this.countShiftUp;
        }
    }
}

