/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.evolution.IModelEvolutionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.ParameterAware;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DBStoreFactory
implements IStoreFactory,
IManagedContainer.ContainerAware,
ParameterAware {
    private IManagedContainer container;
    private Map<String, String> parameters;

    public String getStoreType() {
        return "db";
    }

    public void setManagedContainer(IManagedContainer container) {
        this.container = container;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public IStore createStore(String repositoryName, Map<String, String> repositoryProperties, Element storeConfig) {
        IMappingStrategy mappingStrategy = this.getMappingStrategy(repositoryName, repositoryProperties, storeConfig);
        IDBAdapter dbAdapter = this.getDBAdapter(storeConfig);
        IDBConnectionProvider connectionProvider = dbAdapter.createConnectionProvider(this.getDataSource(storeConfig));
        IModelEvolutionSupport modelEvolutionSupport = this.getModelEvolutionSupport(storeConfig);
        Map storeProperties = RepositoryConfigurator.getProperties((Element)storeConfig, (int)1, this.parameters, (IManagedContainer)this.container);
        DBStore store = new DBStore();
        store.setMappingStrategy(mappingStrategy);
        store.setDBAdapter(dbAdapter);
        store.setDBConnectionProvider(connectionProvider);
        store.setModelEvolutionSupport(modelEvolutionSupport);
        store.setProperties(storeProperties);
        return store;
    }

    private IMappingStrategy getMappingStrategy(String repositoryName, Map<String, String> repositoryProperties, Element storeConfig) {
        NodeList mappingStrategyConfigs = storeConfig.getElementsByTagName("mappingStrategy");
        if (mappingStrategyConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one mapping strategy must be configured for DB store");
        }
        Element mappingStrategyConfig = (Element)mappingStrategyConfigs.item(0);
        String mappingStrategyType = this.getAttribute(mappingStrategyConfig, "type");
        IMappingStrategy mappingStrategy = CDODBUtil.createMappingStrategy(mappingStrategyType);
        if (mappingStrategy == null) {
            throw new IllegalArgumentException("Unknown mapping strategy: " + mappingStrategyType);
        }
        Map properties = RepositoryConfigurator.getProperties((Element)mappingStrategyConfig, (int)1, this.parameters, (IManagedContainer)this.container);
        properties.put("repositoryName", repositoryName);
        properties.putAll(repositoryProperties);
        mappingStrategy.setProperties(properties);
        return mappingStrategy;
    }

    private IDBAdapter getDBAdapter(Element storeConfig) {
        NodeList dbAdapterConfigs = storeConfig.getElementsByTagName("dbAdapter");
        if (dbAdapterConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one dbAdapter must be configured for DB store");
        }
        Element dbAdapterConfig = (Element)dbAdapterConfigs.item(0);
        String dbAdapterName = this.getAttribute(dbAdapterConfig, "name");
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)dbAdapterName);
        if (dbAdapter == null) {
            throw new IllegalArgumentException("Unknown DB adapter: " + dbAdapterName);
        }
        return dbAdapter;
    }

    private DataSource getDataSource(Element storeConfig) {
        NodeList dataSourceConfigs = storeConfig.getElementsByTagName("dataSource");
        if (dataSourceConfigs.getLength() != 1) {
            throw new IllegalStateException("Exactly one dataSource must be configured for DB store");
        }
        Properties properties = new Properties();
        Element dataSourceConfig = (Element)dataSourceConfigs.item(0);
        NamedNodeMap attributes = dataSourceConfig.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            String value = attribute.getValue();
            value = RepositoryConfigurator.expandValue((String)value, this.parameters, (IManagedContainer)this.container);
            properties.put(attribute.getName(), value);
            ++i;
        }
        return DBUtil.createDataSource((Map)properties);
    }

    private IModelEvolutionSupport getModelEvolutionSupport(Element storeConfig) {
        NodeList modelEvolutionSupportConfigs = storeConfig.getElementsByTagName("modelEvolutionSupport");
        if (modelEvolutionSupportConfigs.getLength() > 1) {
            throw new IllegalStateException("At most one modelEvolutionSupport must be configured for DB store");
        }
        if (modelEvolutionSupportConfigs.getLength() == 0) {
            OM.LOG.info("Model evolution support disabled");
            return null;
        }
        Element modelEvolutionSupportConfig = (Element)modelEvolutionSupportConfigs.item(0);
        String type = this.getAttribute(modelEvolutionSupportConfig, "type");
        if (StringUtil.isEmpty((String)type)) {
            type = "phased";
        }
        Tree config = Tree.XMLConverter.convertElementToTree((Element)modelEvolutionSupportConfig, this.parameters);
        return (IModelEvolutionSupport)this.container.createElement("org.eclipse.emf.cdo.server.db.evolution.supports", type, config);
    }

    private String getAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        value = RepositoryConfigurator.expandValue((String)value, this.parameters, (IManagedContainer)this.container);
        return value;
    }
}

