/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;

public class ChangeLambdaBodyToBlockFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ChangeLambdaBodyToBlockFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ChangeLambdaBodyToBlockFixCore createChangeLambdaBodyToBlockFix(CompilationUnit compilationUnit, ASTNode node) {
        LambdaExpression lambda;
        if (node instanceof LambdaExpression) {
            lambda = (LambdaExpression)node;
        } else if (node.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)node.getParent();
        } else {
            return null;
        }
        if (!(lambda.getBody() instanceof Expression)) {
            return null;
        }
        if (lambda.resolveMethodBinding() == null) {
            return null;
        }
        String label = CorrectionMessages.QuickAssistProcessor_change_lambda_body_to_block;
        return new ChangeLambdaBodyToBlockFixCore(label, compilationUnit, new ChangeLambdaBodyToBlockProposalOperation(lambda));
    }

    private static class ChangeLambdaBodyToBlockProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private LambdaExpression lambda;

        public ChangeLambdaBodyToBlockProposalOperation(LambdaExpression lambda) {
            this.lambda = lambda;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            QuickAssistProcessorUtil.changeLambdaBodyToBlock(this.lambda, cuRewrite.getAST(), cuRewrite.getASTRewrite());
        }
    }
}

