/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ui.container;

import org.eclipse.net4j.internal.ui.bundle.OM;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.container.ElementWizard;
import org.eclipse.net4j.util.ui.container.ElementWizardFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TCPAcceptorWizard
extends ElementWizard
implements ModifyListener {
    private Text addressText;
    private Text portText;

    protected void create(Composite parent) {
        this.addressText = TCPAcceptorWizard.addText((Composite)parent, (String)"Address:");
        this.addressText.addModifyListener((ModifyListener)this);
        this.portText = TCPAcceptorWizard.addText((Composite)parent, (String)"Port:");
        this.portText.addModifyListener((ModifyListener)this);
        String description = this.getDefaultDescription();
        if (description != null) {
            try {
                TCPUtil.AcceptorData data = new TCPUtil.AcceptorData(description);
                this.addressText.setText(data.getAddress());
                this.portText.setText(Integer.toString(data.getPort()));
            }
            catch (NoClassDefFoundError error) {
                OM.LOG.error((Throwable)error);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        Object host = this.addressText.getText();
        if (((String)host).length() == 0) {
            this.setValidationError(this.addressText, "Address is empty.");
            return;
        }
        String port = this.portText.getText();
        if (port.length() != 0) {
            host = (String)host + ":" + port;
        }
        this.setResultDescription((String)host);
        this.setValidationError(this.addressText, null);
    }

    public static class Factory
    extends ElementWizardFactory {
        public Factory() {
            super("org.eclipse.net4j.acceptors", "tcp");
        }

        public TCPAcceptorWizard create(String description) throws ProductCreationException {
            return new TCPAcceptorWizard();
        }
    }
}

