/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class DefinitionListBlock
extends Block {
    static final Pattern itemLinePattern = Pattern.compile("(\\s+)([^\\:\\:]*+)(\\:\\:\\s*)(.*+)");
    static final Pattern definitionLinePattern = Pattern.compile("(\\s+)(.*+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private boolean listBlockOpened;
    private boolean definitionBlockOpened;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, new Attributes());
            this.listBlockOpened = true;
            return this.processItemLine(line, this.matcher);
        }
        Matcher itemLineMatcher = itemLinePattern.matcher(line);
        if (!itemLineMatcher.matches()) {
            Matcher definitionLineMatcher = definitionLinePattern.matcher(line);
            if (definitionLineMatcher.matches()) {
                return this.processDefinitionLine(line, definitionLineMatcher);
            }
            this.setClosed(true);
            return 0;
        }
        return this.processItemLine(line, itemLineMatcher);
    }

    private int processItemLine(String line, Matcher itemLineMatcher) {
        this.closeDefinitionBlock();
        ++this.blockLineCount;
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes());
        int offset = itemLineMatcher.start(2);
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line.substring(0, itemLineMatcher.end(2)), offset);
        this.builder.endBlock();
        if (itemLineMatcher.group(4).length() > 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
            this.definitionBlockOpened = true;
            offset = itemLineMatcher.start(4);
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        }
        return -1;
    }

    private int processDefinitionLine(String line, Matcher definitionLineMatcher) {
        ++this.blockLineCount;
        int offset = definitionLineMatcher.start(2);
        if (this.definitionBlockOpened) {
            --offset;
        } else {
            this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
            this.definitionBlockOpened = true;
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = itemLinePattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.closeDefinitionBlock();
            this.closeListBlock();
        }
        super.setClosed(closed);
    }

    private void closeDefinitionBlock() {
        if (this.definitionBlockOpened) {
            this.builder.endBlock();
            this.definitionBlockOpened = false;
        }
    }

    private void closeListBlock() {
        if (this.listBlockOpened) {
            this.builder.endBlock();
            this.listBlockOpened = false;
        }
    }
}

