/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IWorkspaceClassifierResolver;
import org.eclipse.m2e.core.project.IWorkspaceClassifierResolverManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IWorkspaceClassifierResolverManager.class})
public class WorkspaceClassifierResolverManager
implements IWorkspaceClassifierResolverManager {
    protected static final Logger log = LoggerFactory.getLogger(WorkspaceClassifierResolverManager.class);
    private static final String EXTENSION_WORKSPACE_CLASSIFIER_RESOLVERS = "org.eclipse.m2e.core.workspaceClassifierResolvers";
    private volatile List<IWorkspaceClassifierResolver> classifierResolvers;
    private final IWorkspaceClassifierResolver defaultResolver = new IWorkspaceClassifierResolver(){

        @Override
        public IPath resolveClassifier(IMavenProjectFacade project, String classifier) {
            for (IWorkspaceClassifierResolver resolver : WorkspaceClassifierResolverManager.this.getResolvers()) {
                IPath res = resolver.resolveClassifier(project, classifier);
                if (res == null) continue;
                log.info("Resolving {} with classifier {} to {}", new Object[]{project, classifier, res});
                return res;
            }
            return null;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IWorkspaceClassifierResolver> getResolvers() {
        if (this.classifierResolvers == null) {
            WorkspaceClassifierResolverManager workspaceClassifierResolverManager = this;
            synchronized (workspaceClassifierResolverManager) {
                if (this.classifierResolvers == null) {
                    this.classifierResolvers = WorkspaceClassifierResolverManager.readExtensions();
                }
            }
        }
        return this.classifierResolvers;
    }

    @Override
    public IWorkspaceClassifierResolver getResolver() {
        return this.defaultResolver;
    }

    protected static List<IWorkspaceClassifierResolver> readExtensions() {
        ArrayList<IWorkspaceClassifierResolver> resolvers = new ArrayList<IWorkspaceClassifierResolver>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ccpExtensionPoint = registry.getExtensionPoint(EXTENSION_WORKSPACE_CLASSIFIER_RESOLVERS);
        if (ccpExtensionPoint != null) {
            IExtension[] ccpExtensions;
            IExtension[] iExtensionArray = ccpExtensions = ccpExtensionPoint.getExtensions();
            int n = ccpExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        resolvers.add((IWorkspaceClassifierResolver)element.createExecutableExtension("class"));
                    }
                    catch (CoreException ex) {
                        log.error("Cannot instantiate IWorkspaceClassifierResolver", (Throwable)ex);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        resolvers.sort((l, r) -> l.getPriority() - r.getPriority());
        return resolvers;
    }
}

