/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocLocations;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocContentAccessUtility;
import org.eclipse.jdt.core.manipulation.internal.javadoc.IJavadocContentFactory;
import org.eclipse.jdt.core.manipulation.internal.javadoc.InheritDocVisitor;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavaDocMessages;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavadocLookup;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;

public class CoreJavadocAccess {
    protected static final String BASE_URL_COMMENT_INTRO = "<!-- baseURL=\"";
    protected IJavadocContentFactory fFactory;

    public CoreJavadocAccess() {
        this(JavadocLookup.DEFAULT_FACTORY);
    }

    public CoreJavadocAccess(IJavadocContentFactory factory) {
        this.fFactory = factory;
    }

    public String extractBaseURL(String content) {
        int introLength;
        int endIndex;
        int introStart = content.indexOf(BASE_URL_COMMENT_INTRO);
        if (introStart != -1 && (endIndex = content.indexOf(34, introStart + (introLength = BASE_URL_COMMENT_INTRO.length()))) != -1) {
            return content.substring(introStart + introLength, endIndex);
        }
        return null;
    }

    public String getHTMLContent(IPackageDeclaration packageDeclaration) throws CoreException {
        IJavaElement element = packageDeclaration.getAncestor(4);
        if (element instanceof IPackageFragment) {
            return this.getHTMLContent((IPackageFragment)element);
        }
        return null;
    }

    public String getHTMLContent(IPackageFragment packageFragment) throws CoreException {
        return this.readHTMLContent(packageFragment);
    }

    protected String readHTMLContent(IPackageFragment packageFragment) throws CoreException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        boolean isBinary = root.getKind() == 2;
        Object packageInfo = isBinary ? packageFragment.getClassFile("package-info.class") : packageFragment.getCompilationUnit("package-info.java");
        if (packageInfo != null && packageInfo.exists()) {
            Javadoc packageJavadocNode;
            String cuSource = packageInfo.getSource();
            if (cuSource != null && (packageJavadocNode = CoreJavadocContentAccessUtility.getPackageJavadocNode((IJavaElement)packageFragment, cuSource)) != null) {
                Object element = isBinary ? ((IOrdinaryClassFile)packageInfo).getType() : packageInfo.getParent();
                return this.fFactory.createJavadocAccess((IJavaElement)element, packageJavadocNode, cuSource, null).toHTML();
            }
        } else {
            Object nonJavaResource;
            Object[] nonJavaResources;
            Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
            int n = nonJavaResources.length;
            int n2 = 0;
            while (n2 < n) {
                IFile iFile;
                nonJavaResource = objectArray[n2];
                if (nonJavaResource instanceof IFile && (iFile = (IFile)nonJavaResource).exists() && "package.html".equals(iFile.getName())) {
                    return CoreJavadocContentAccessUtility.getIFileContent(iFile);
                }
                ++n2;
            }
            if (isBinary) {
                objectArray = nonJavaResources;
                n = nonJavaResources.length;
                n2 = 0;
                while (n2 < n) {
                    nonJavaResource = objectArray[n2];
                    if (nonJavaResource instanceof IJarEntryResource) {
                        IJarEntryResource jarEntryResource = (IJarEntryResource)nonJavaResource;
                        String encoding = CoreJavadocContentAccessUtility.getSourceAttachmentEncoding(root);
                        if ("package.html".equals(jarEntryResource.getName()) && jarEntryResource.isFile()) {
                            return CoreJavadocContentAccessUtility.getHTMLContent(jarEntryResource, encoding);
                        }
                    }
                    ++n2;
                }
                String contents = this.getHTMLContentFromAttachedSource(root, packageFragment);
                if (contents != null) {
                    return contents;
                }
            }
        }
        if (root.isArchive() || root.isExternal()) {
            return packageFragment.getAttachedJavadoc(null);
        }
        return "";
    }

    protected String getHTMLContentFromAttachedSource(IPackageFragmentRoot root, IPackageFragment packageFragment) throws CoreException {
        Javadoc packageJavadocNode;
        String filePath = packageFragment.getElementName().replace('.', '/') + "/package-info.java";
        String contents = CoreJavadocContentAccessUtility.getFileContentFromAttachedSource(root, filePath);
        if (contents != null && (packageJavadocNode = CoreJavadocContentAccessUtility.getPackageJavadocNode((IJavaElement)packageFragment, contents)) != null) {
            return this.fFactory.createJavadocAccess((IJavaElement)packageFragment, packageJavadocNode, contents, null).toHTML();
        }
        filePath = packageFragment.getElementName().replace('.', '/') + "/package.html";
        return CoreJavadocContentAccessUtility.getFileContentFromAttachedSource(root, filePath);
    }

    public String getHTMLContent(IJavaElement element, boolean useAttachedJavadoc) throws CoreException {
        if (element instanceof IPackageFragment) {
            return this.getHTMLContent((IPackageFragment)element);
        }
        if (element instanceof IPackageDeclaration) {
            return this.getHTMLContent((IPackageDeclaration)element);
        }
        if (!(element instanceof IMember || element instanceof ITypeParameter || element instanceof ILocalVariable && ((ILocalVariable)element).isParameter())) {
            return null;
        }
        String sourceJavadoc = this.getHTMLContentFromSource(element);
        if ((sourceJavadoc == null || sourceJavadoc.length() == 0 || "{@inheritDoc}".equals(sourceJavadoc.trim())) && useAttachedJavadoc) {
            if (element.getOpenable().getBuffer() == null) {
                try {
                    return element.getAttachedJavadoc(null);
                }
                catch (Exception e) {
                    JavaManipulationPlugin.log(e);
                    return null;
                }
            }
            IMember member = null;
            if (element instanceof ILocalVariable) {
                member = ((ILocalVariable)element).getDeclaringMember();
            } else if (element instanceof ITypeParameter) {
                member = ((ITypeParameter)element).getDeclaringMember();
            } else if (element instanceof IMember) {
                member = (IMember)element;
            }
            if (CoreJavadocContentAccessUtility.canInheritJavadoc(member)) {
                IMethod method = (IMethod)member;
                String attachedDocInHierarchy = this.findAttachedDocInHierarchy(method);
                if (attachedDocInHierarchy == null) {
                    return sourceJavadoc;
                }
                StringBuffer superMethodReferences = this.createSuperMethodReferences(method);
                if (superMethodReferences == null) {
                    return attachedDocInHierarchy;
                }
                superMethodReferences.append(attachedDocInHierarchy);
                return superMethodReferences.toString();
            }
        }
        return sourceJavadoc;
    }

    static SuperclassReferenceMethodData getSuperclassReferenceMethodData(final IMethod method) throws JavaModelException {
        boolean hasSuperInterfaceMethods;
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        final ArrayList<IMethod> superInterfaceMethods = new ArrayList<IMethod>();
        final IMethod[] superClassMethod = new IMethod[1];
        new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws JavaModelException {
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (currType.isInterface()) {
                    superInterfaceMethods.add(overridden);
                } else {
                    superClassMethod[0] = overridden;
                }
                return STOP_BRANCH;
            }
        }.visitInheritDoc(type, hierarchy);
        boolean bl = hasSuperInterfaceMethods = !superInterfaceMethods.isEmpty();
        if (!hasSuperInterfaceMethods && superClassMethod[0] == null) {
            return null;
        }
        return new SuperclassReferenceMethodData(superInterfaceMethods, superClassMethod[0]);
    }

    protected StringBuffer createSuperMethodReferences(IMethod method) throws JavaModelException {
        SuperclassReferenceMethodData data = CoreJavadocAccess.getSuperclassReferenceMethodData(method);
        if (data == null) {
            return null;
        }
        return this.createSuperMethodReferencesHTML(data.superInterfaceMethods(), data.superClassMethod());
    }

    protected StringBuffer createSuperMethodReferencesHTML(ArrayList<IMethod> superInterfaceMethods, IMethod superClassMethod) {
        return CoreJavadocAccess.createSuperMethodReferencesHTMLStaticImpl(superInterfaceMethods, superClassMethod);
    }

    static StringBuffer createSuperMethodReferencesHTMLStaticImpl(ArrayList<IMethod> superInterfaceMethods, IMethod superClassMethod) {
        boolean hasSuperInterfaceMethods = !superInterfaceMethods.isEmpty();
        StringBuffer buf = new StringBuffer();
        buf.append("<div>");
        if (hasSuperInterfaceMethods) {
            buf.append("<b>");
            buf.append(JavaDocMessages.JavaDoc2HTMLTextReader_specified_by_section);
            buf.append("</b> ");
            Iterator<IMethod> iter = superInterfaceMethods.iterator();
            while (iter.hasNext()) {
                IMethod overridden = iter.next();
                buf.append(CoreJavadocContentAccessUtility.createMethodInTypeLinks(overridden));
                if (!iter.hasNext()) continue;
                buf.append(JavaElementLabelsCore.COMMA_STRING);
            }
        }
        if (superClassMethod != null) {
            if (hasSuperInterfaceMethods) {
                buf.append(JavaElementLabelsCore.COMMA_STRING);
            }
            buf.append("<b>");
            buf.append(JavaDocMessages.JavaDoc2HTMLTextReader_overrides_section);
            buf.append("</b> ");
            buf.append(CoreJavadocContentAccessUtility.createMethodInTypeLinks(superClassMethod));
        }
        buf.append("</div>");
        return buf;
    }

    protected String getHTMLContentFromSource(IJavaElement element) throws JavaModelException {
        Object member;
        if (element instanceof ILocalVariable) {
            member = ((ILocalVariable)element).getDeclaringMember();
        } else if (element instanceof ITypeParameter) {
            member = ((ITypeParameter)element).getDeclaringMember();
        } else if (element instanceof IMember) {
            IField field;
            member = element instanceof IField && (field = (IField)element).isRecordComponent() ? ((IField)element).getDeclaringType() : (IMember)element;
        } else {
            return null;
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange == null) {
            String inheritedJavadoc;
            if (CoreJavadocContentAccessUtility.canInheritJavadoc(member) && (inheritedJavadoc = this.javadoc2HTML((IMember)member, element, "/***/")) != null && inheritedJavadoc.length() > 0) {
                return inheritedJavadoc;
            }
            return this.getJavaFxPropertyDoc((IMember)member);
        }
        String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
        return this.javadoc2HTML((IMember)member, element, rawJavadoc);
    }

    protected String formatJavaFxGetterSetterPropertyDoc(String content, String propertyName, boolean isSetter) {
        if (content != null) {
            content = isSetter ? MessageFormat.format(JavaDocMessages.JavadocContentAccess2_setproperty_message, propertyName, content) : MessageFormat.format(JavaDocMessages.JavadocContentAccess2_getproperty_message, propertyName, content);
        }
        return content;
    }

    protected String getJavaFxPropertyDoc(IMember member) throws JavaModelException {
        if (member instanceof IMethod) {
            boolean isSetter;
            String name = member.getElementName();
            boolean isGetter = name.startsWith("get") && name.length() > 3;
            boolean isBooleanGetter = name.startsWith("is") && name.length() > 2;
            boolean bl = isSetter = name.startsWith("set") && name.length() > 3;
            if (isGetter || isBooleanGetter || isSetter) {
                String propertyName = this.firstToLower(name.substring(isBooleanGetter ? 2 : 3));
                IType type = member.getDeclaringType();
                IMethod method = type.getMethod(propertyName + "Property", new String[0]);
                if (method.exists()) {
                    String content = this.getHTMLContentFromSource((IJavaElement)method);
                    return this.formatJavaFxGetterSetterPropertyDoc(content, propertyName, isSetter);
                }
            } else if (name.endsWith("Property")) {
                String propertyName = name.substring(0, name.length() - 8);
                IType type = member.getDeclaringType();
                IField field = type.getField(propertyName);
                if (field.exists()) {
                    return this.getHTMLContentFromSource((IJavaElement)field);
                }
            }
        }
        return null;
    }

    protected String firstToLower(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return String.valueOf(c);
    }

    protected String javadoc2HTML(IMember member, IJavaElement element, String rawJavadoc) {
        Javadoc javadoc = CoreJavadocContentAccessUtility.getJavadocNode((IJavaElement)member, rawJavadoc);
        if (javadoc == null) {
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (Reader contentReader = CoreJavadocContentAccessUtility.getHTMLContentReader(member, false, false);){
                    if (contentReader != null) {
                        return CoreJavadocContentAccessUtility.getString(contentReader);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | JavaModelException e1) {
                JavaManipulationPlugin.log(e1);
            }
            return null;
        }
        if (CoreJavadocContentAccessUtility.canInheritJavadoc(member)) {
            IMethod method = (IMethod)member;
            return this.fFactory.createJavadocAccess(element, javadoc, rawJavadoc, new JavadocLookup(method.getDeclaringType(), this.fFactory)).toHTML();
        }
        return this.fFactory.createJavadocAccess(element, javadoc, rawJavadoc, null).toHTML();
    }

    protected String findAttachedDocInHierarchy(final IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        return (String)new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws JavaModelException {
                Object attachedJavadoc;
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (overridden.getOpenable().getBuffer() == null && (attachedJavadoc = overridden.getAttachedJavadoc(null)) != null) {
                    String baseURL = CoreJavaDocLocations.getBaseURL((IJavaElement)overridden, overridden.isBinary(), null);
                    if (baseURL != null) {
                        attachedJavadoc = CoreJavadocAccess.BASE_URL_COMMENT_INTRO + baseURL + "\"--> " + (String)attachedJavadoc;
                    }
                    return attachedJavadoc;
                }
                return CONTINUE;
            }
        }.visitInheritDoc(type, hierarchy);
    }

    record SuperclassReferenceMethodData(ArrayList<IMethod> superInterfaceMethods, IMethod superClassMethod) {
    }
}

