/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class StripInvalidXMLCharsReader
extends FilterReader {
    public StripInvalidXMLCharsReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int r = -1;
        while ((r = super.read()) != -1) {
            if (!this.isValidXMLChar((char)r)) continue;
            return r;
        }
        return -1;
    }

    private boolean isValidXMLChar(char c) {
        return c >= ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read;
        int remaining = read = super.read(cbuf, off, len);
        int i = off;
        while (i < off + remaining) {
            char c = cbuf[i];
            if (!this.isValidXMLChar(c)) {
                int after;
                if ((after = off + --remaining - i) <= 0) continue;
                System.arraycopy(cbuf, i + 1, cbuf, i, after);
                cbuf[remaining] = '\u0000';
                continue;
            }
            ++i;
        }
        return remaining;
    }
}

