/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.e4.ui.internal.workbench.E4XMISave;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class E4XMIResource
extends XMIResourceImpl {
    public static final String OPTION_FILTER_PERSIST_STATE = "E4_FILTER_PERSISTED_STATE";
    private final Map<EObject, String> objectMap = new WeakHashMap<EObject, String>();
    private final Set<String> knownIds = new HashSet<String>();

    public E4XMIResource() {
    }

    public E4XMIResource(URI uri) {
        super(uri);
    }

    public void setInternalId(EObject object, String id) {
        this.objectMap.put(object, id);
        this.knownIds.add(id);
    }

    public String getInternalId(EObject object) {
        return this.objectMap.get(object);
    }

    protected boolean useIDs() {
        return true;
    }

    private String createId() {
        return EcoreUtil.generateUUID();
    }

    private String getUniqueId() {
        String id = this.createId();
        while (this.knownIds.contains(id)) {
            id = this.createId();
        }
        return id;
    }

    public void setID(EObject eObject, String id) {
        if (id != null) {
            String internalId = this.objectMap.get(eObject);
            if (internalId != null) {
                super.setID(eObject, internalId);
            }
            this.objectMap.put(eObject, id);
            this.knownIds.add(id);
        }
        super.setID(eObject, id);
    }

    public String getID(EObject eObject) {
        if (eObject instanceof Map.Entry) {
            return null;
        }
        String id = super.getID(eObject);
        if (id != null) {
            return id;
        }
        id = this.objectMap.get(eObject);
        if (id != null) {
            this.setID(eObject, id);
            return id;
        }
        id = this.getUniqueId();
        this.setID(eObject, id);
        return id;
    }

    protected XMLSave createXMLSave(Map<?, ?> options) {
        if (options != null && Boolean.TRUE.equals(options.get(OPTION_FILTER_PERSIST_STATE))) {
            return new E4XMISave(this.createXMLHelper());
        }
        return super.createXMLSave(options);
    }
}

