"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultMarkdownFileExtension = exports.PreferredMdPathExtensionStyle = void 0;
exports.getLsConfiguration = getLsConfiguration;
exports.isExcludedPath = isExcludedPath;
const picomatch = require("picomatch");
/**
 * Preferred style for file paths to {@link markdownFileExtensions markdown files}.
 */
var PreferredMdPathExtensionStyle;
(function (PreferredMdPathExtensionStyle) {
    /**
     * Try to maintain the existing of the path.
     */
    PreferredMdPathExtensionStyle["auto"] = "auto";
    /**
     * Include the file extension when possible.
     */
    PreferredMdPathExtensionStyle["includeExtension"] = "includeExtension";
    /**
     * Drop the file extension when possible.
     */
    PreferredMdPathExtensionStyle["removeExtension"] = "removeExtension";
})(PreferredMdPathExtensionStyle || (exports.PreferredMdPathExtensionStyle = PreferredMdPathExtensionStyle = {}));
exports.defaultMarkdownFileExtension = 'md';
const defaultConfig = {
    markdownFileExtensions: [exports.defaultMarkdownFileExtension],
    knownLinkedToFileExtensions: [
        'jpg',
        'jpeg',
        'png',
        'gif',
        'webp',
        'bmp',
        'tiff',
    ],
    excludePaths: [
        '**/.*',
        '**/node_modules/**',
    ]
};
function getLsConfiguration(overrides) {
    return new Proxy(Object.create(null), {
        get(_target, p, _receiver) {
            return p in overrides ? overrides[p] : defaultConfig[p];
        },
    });
}
function isExcludedPath(configuration, uri) {
    return configuration.excludePaths.some(excludePath => picomatch.isMatch(uri.path, excludePath));
}
//# sourceMappingURL=config.js.map