"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentSlots = getComponentSlots;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getComponentSlots(ts, program, virtualCode) {
    const codegen = language_core_1.tsCodegen.get(virtualCode.sfc);
    if (!codegen) {
        return [];
    }
    const assignName = codegen.getSetupSlotsAssignName() ?? `__VLS_slots`;
    const slots = (0, utils_1.getVariableType)(ts, program, virtualCode.fileName, assignName);
    if (!slots) {
        return [];
    }
    return slots.type.getProperties().map(({ name }) => name);
}
//# sourceMappingURL=getComponentSlots.js.map