/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.GrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.osgi.service.prefs.BackingStoreException;

final class PreferenceHelper {
    private static final String GRAMMARS = "org.eclipse.tm4e.registry.grammars";
    private static final Gson DEFAULT_GSON = new GsonBuilder().registerTypeAdapter(IGrammarDefinition.class, type -> new GrammarDefinition()).create();

    static @Nullable List<IGrammarDefinition> loadGrammars() {
        String json = TMEclipseRegistryPlugin.getPreference(GRAMMARS, null);
        if (json == null) {
            return null;
        }
        return (List)DEFAULT_GSON.fromJson(json, new TypeToken<ArrayList<GrammarDefinition>>(){}.getType());
    }

    static void saveGrammars(Collection<IGrammarDefinition> definitions) throws BackingStoreException {
        String json = DEFAULT_GSON.toJson(definitions);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.registry");
        prefs.put(GRAMMARS, json);
        prefs.flush();
    }

    private PreferenceHelper() {
    }
}

