/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.lang.reflect.Field;
import java.util.Map;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.LifecycleManager;
import org.eclipse.sisu.plexus.PlexusLifecycleManager;

public class LifecycleManagerDisposer
implements ClassWorldListener {
    private DefaultPlexusContainer container;

    public LifecycleManagerDisposer(DefaultPlexusContainer container) {
        this.container = container;
    }

    public void realmCreated(ClassRealm realm) {
    }

    public void realmDisposed(ClassRealm realm) {
        try {
            BeanManager beanManager = (BeanManager)this.container.lookup(BeanManager.class);
            if (beanManager instanceof PlexusLifecycleManager) {
                PlexusLifecycleManager plexus = (PlexusLifecycleManager)beanManager;
                Field delegateField = plexus.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(plexus);
                if (delegate instanceof LifecycleManager) {
                    LifecycleManager manager = (LifecycleManager)delegate;
                    this.disposeOutdatedEntries(realm, manager);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void disposeOutdatedEntries(ClassRealm realm, LifecycleManager manager) throws NoSuchFieldException, IllegalAccessException {
        Field lifecyclesMapField = manager.getClass().getDeclaredField("lifecycles");
        lifecyclesMapField.setAccessible(true);
        Object lifecycles = lifecyclesMapField.get(manager);
        if (lifecycles instanceof Map) {
            Map map = (Map)lifecycles;
            map.keySet().removeIf(key -> {
                Class clazz;
                return key instanceof Class && (clazz = (Class)key).getClassLoader() == realm;
            });
        }
    }
}

