/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.RGB;

public final class TerminalColor
extends Enum<TerminalColor> {
    public static final /* enum */ TerminalColor BLACK;
    public static final /* enum */ TerminalColor RED;
    public static final /* enum */ TerminalColor GREEN;
    public static final /* enum */ TerminalColor YELLOW;
    public static final /* enum */ TerminalColor BLUE;
    public static final /* enum */ TerminalColor MAGENTA;
    public static final /* enum */ TerminalColor CYAN;
    public static final /* enum */ TerminalColor WHITE;
    public static final /* enum */ TerminalColor BRIGHT_BLACK;
    public static final /* enum */ TerminalColor BRIGHT_RED;
    public static final /* enum */ TerminalColor BRIGHT_GREEN;
    public static final /* enum */ TerminalColor BRIGHT_YELLOW;
    public static final /* enum */ TerminalColor BRIGHT_BLUE;
    public static final /* enum */ TerminalColor BRIGHT_MAGENTA;
    public static final /* enum */ TerminalColor BRIGHT_CYAN;
    public static final /* enum */ TerminalColor BRIGHT_WHITE;
    public static final /* enum */ TerminalColor FOREGROUND;
    public static final /* enum */ TerminalColor BACKGROUND;
    public static final /* enum */ TerminalColor SELECTION_FOREGROUND;
    public static final /* enum */ TerminalColor SELECTION_BACKGROUND;
    private static final TerminalColor[] table8bitIndexedTerminalColors;
    private static final RGB[] table8bitIndexedRGB;
    private TerminalColor invertColor;
    private TerminalColor brightColor;
    private static final /* synthetic */ TerminalColor[] ENUM$VALUES;

    static {
        int g;
        BLACK = new TerminalColor();
        RED = new TerminalColor();
        GREEN = new TerminalColor();
        YELLOW = new TerminalColor();
        BLUE = new TerminalColor();
        MAGENTA = new TerminalColor();
        CYAN = new TerminalColor();
        WHITE = new TerminalColor();
        BRIGHT_BLACK = new TerminalColor();
        BRIGHT_RED = new TerminalColor();
        BRIGHT_GREEN = new TerminalColor();
        BRIGHT_YELLOW = new TerminalColor();
        BRIGHT_BLUE = new TerminalColor();
        BRIGHT_MAGENTA = new TerminalColor();
        BRIGHT_CYAN = new TerminalColor();
        BRIGHT_WHITE = new TerminalColor();
        FOREGROUND = new TerminalColor();
        BACKGROUND = new TerminalColor();
        SELECTION_FOREGROUND = new TerminalColor();
        SELECTION_BACKGROUND = new TerminalColor();
        ENUM$VALUES = new TerminalColor[]{BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE, BRIGHT_BLACK, BRIGHT_RED, BRIGHT_GREEN, BRIGHT_YELLOW, BRIGHT_BLUE, BRIGHT_MAGENTA, BRIGHT_CYAN, BRIGHT_WHITE, FOREGROUND, BACKGROUND, SELECTION_FOREGROUND, SELECTION_BACKGROUND};
        table8bitIndexedTerminalColors = new TerminalColor[16];
        table8bitIndexedRGB = new RGB[240];
        TerminalColor[] values = TerminalColor.values();
        int index = 0;
        while (index < 16) {
            TerminalColor c;
            TerminalColor.table8bitIndexedTerminalColors[index] = c = values[index];
            ++index;
        }
        int[] nArray = new int[6];
        nArray[1] = 95;
        nArray[2] = 135;
        nArray[3] = 175;
        nArray[4] = 215;
        nArray[5] = 255;
        int[] vals = nArray;
        Assert.isTrue((index == 16 ? 1 : 0) != 0);
        int r = 0;
        while (r < 6) {
            g = 0;
            while (g < 6) {
                int b = 0;
                while (b < 6) {
                    TerminalColor.table8bitIndexedRGB[index++ - 16] = new RGB(vals[r], vals[g], vals[b]);
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        int[] greys = new int[]{8, 18, 28, 38, 48, 58, 68, 78, 88, 98, 108, 118, 128, 138, 148, 158, 168, 178, 188, 198, 208, 218, 228, 238};
        Assert.isTrue((index == 232 ? 1 : 0) != 0);
        int[] nArray2 = greys;
        int n = greys.length;
        int n2 = 0;
        while (n2 < n) {
            g = nArray2[n2];
            TerminalColor.table8bitIndexedRGB[index++ - 16] = new RGB(g, g, g);
            ++n2;
        }
        Assert.isTrue((index == 256 ? 1 : 0) != 0);
        int i = 0;
        while (i < 8) {
            values[i].brightColor = values[i + 8];
            ++i;
        }
        i = 8;
        while (i < values.length) {
            values[i].brightColor = values[i];
            ++i;
        }
        i = 0;
        while (i < values.length) {
            values[i].invertColor = values[i];
            ++i;
        }
        TerminalColor.inverts(BLACK, WHITE);
        TerminalColor.inverts(BRIGHT_BLACK, BRIGHT_WHITE);
        TerminalColor.inverts(BACKGROUND, FOREGROUND);
    }

    private static void inverts(TerminalColor a, TerminalColor b) {
        a.invertColor = b;
        b.invertColor = a;
    }

    public TerminalColor convertColor(boolean invert, boolean bright) {
        TerminalColor selected = this;
        if (invert) {
            selected = selected.invertColor;
        }
        if (bright) {
            selected = selected.brightColor;
        }
        return selected;
    }

    public static boolean isIndexedTerminalColor(int index) {
        Assert.isLegal((index >= 0 && index < 256 ? 1 : 0) != 0, (String)"Invalid 8-bit table index out of range 0-255");
        return index < table8bitIndexedTerminalColors.length && index >= 0;
    }

    public static TerminalColor getIndexedTerminalColor(int index) {
        Assert.isLegal((boolean)TerminalColor.isIndexedTerminalColor(index), (String)"Invalid table index used for ANSI Color");
        return table8bitIndexedTerminalColors[index];
    }

    public static RGB getIndexedRGBColor(int index) {
        Assert.isLegal((index >= 16 && index < 256 ? 1 : 0) != 0, (String)"Invalid table index used for RGB Color");
        return table8bitIndexedRGB[index - 16];
    }

    public static TerminalColor[] values() {
        TerminalColor[] terminalColorArray = ENUM$VALUES;
        int n = terminalColorArray.length;
        TerminalColor[] terminalColorArray2 = new TerminalColor[n];
        System.arraycopy(ENUM$VALUES, 0, terminalColorArray2, 0, n);
        return terminalColorArray2;
    }

    public static TerminalColor valueOf(String string) {
        return Enum.valueOf(TerminalColor.class, string);
    }
}

