/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.event.internal.model;

import org.eclipse.pde.spy.event.internal.model.Messages;

public enum Operator {
    NotSelected(Messages.Operator_Title, false),
    Equals(Messages.Operator_EqualsTo, true),
    NotEquals(Messages.Operator_NotEqualsTo, false),
    Contains(Messages.Operator_Contains, true),
    NotContains(Messages.Operator_NotContains, false),
    StartsWith(Messages.Operator_StartsWith, true),
    NotStartsWith(Messages.Operator_NotStartsWith, false);

    private final String text;
    private final boolean positive;

    private Operator(String text, boolean positive) {
        this.text = text;
        this.positive = positive;
    }

    public String toString() {
        return this.text;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public static Operator toOperator(String text) {
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator operator = operatorArray[n2];
            if (operator.text.equals(text)) {
                return operator;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.format(Messages.Operator_NotFoundFor, Operator.class.getSimpleName(), text));
    }
}

