/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenLauncherConfigurationHandler;
import org.eclipse.m2e.internal.launch.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MavenRuntimeLaunchSupport {
    private final AbstractMavenRuntime runtime;
    private final MavenLauncherConfigurationHandler cwconf;
    private final boolean resolveWorkspaceArtifacts;
    private final File cwconfFile;

    MavenRuntimeLaunchSupport(AbstractMavenRuntime runtime, MavenLauncherConfigurationHandler cwconf, File cwconfFile, boolean resolveWorkspaceArtifacts) {
        this.runtime = runtime;
        this.cwconf = cwconf;
        this.cwconfFile = cwconfFile;
        this.resolveWorkspaceArtifacts = resolveWorkspaceArtifacts;
    }

    public static Builder builder(ILaunchConfiguration configuration) throws CoreException {
        return new Builder(configuration);
    }

    public static MavenRuntimeLaunchSupport create(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        return MavenRuntimeLaunchSupport.builder(configuration).build(monitor);
    }

    public String getLocation() {
        return this.runtime.getLocation();
    }

    public File getClassworldConfFile() {
        return this.cwconfFile;
    }

    public List<String> getBootClasspath() {
        return this.cwconf.getRealmEntries("]launcher");
    }

    public String getSettings() {
        return this.runtime.getSettings();
    }

    public String getVersion() {
        return this.runtime.getVersion();
    }

    public VMArguments getVMArguments() {
        VMArguments properties = new VMArguments();
        this.applyMavenRuntime(properties);
        if (this.resolveWorkspaceArtifacts) {
            MavenRuntimeLaunchSupport.applyWorkspaceArtifacts(properties);
        }
        return properties;
    }

    public void applyMavenRuntime(VMArguments properties) {
        String location = this.runtime.getLocation();
        if (location != null) {
            properties.appendProperty("maven.home", MavenLaunchUtils.quote(location));
        }
        properties.appendProperty("classworlds.conf", MavenLaunchUtils.quote(this.cwconfFile.getAbsolutePath()));
    }

    public static void applyWorkspaceArtifacts(VMArguments properties) {
        File state = ((MavenProjectManager)MavenPluginActivator.getDefault().getMavenProjectManager()).getWorkspaceStateFile();
        properties.appendProperty("m2e.workspace.state", MavenLaunchUtils.quote(state.getAbsolutePath()));
    }

    public IVMRunner decorateVMRunner(IVMRunner runner) {
        return (runnerConfiguration, launch, monitor) -> {
            runner.run(runnerConfiguration, launch, monitor);
            IProcess[] processes = launch.getProcesses();
            if (processes != null && processes.length > 0) {
                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                new BackgroundResourceRefresher(configuration, launch).init();
            } else {
                this.getClassworldConfFile().delete();
            }
        };
    }

    private class BackgroundResourceRefresher
    implements IDebugEventSetListener {
        private final ILaunchConfiguration configuration;
        private final IProcess process;

        public BackgroundResourceRefresher(ILaunchConfiguration configuration, ILaunch launch) {
            this.configuration = configuration;
            this.process = launch.getProcesses()[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            IProcess iProcess = this.process;
            synchronized (iProcess) {
                if (this.process.isTerminated()) {
                    this.processResources();
                } else {
                    DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                }
            }
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (Arrays.stream(events).anyMatch(e -> e.getSource() == this.process && e.getKind() == 8)) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.processResources();
            }
        }

        protected void processResources() {
            MavenRuntimeLaunchSupport.this.getClassworldConfFile().delete();
            Job.create((String)Messages.MavenLaunchDelegate_job_name, monitor -> {
                try {
                    RefreshTab.refreshResources((ILaunchConfiguration)this.configuration, (IProgressMonitor)monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }).schedule();
        }
    }

    public static class Builder {
        private final ILaunchConfiguration configuration;
        private boolean resolveWorkspaceArtifacts;
        private boolean injectWorkspaceResolver;

        Builder(ILaunchConfiguration configuration) throws CoreException {
            this.configuration = configuration;
            this.enableWorkspaceResolution(configuration.getAttribute("M2_WORKSPACE_RESOLUTION", false));
        }

        public Builder enableWorkspaceResolution(boolean enable) {
            this.resolveWorkspaceArtifacts = enable;
            this.injectWorkspaceResolver = enable;
            return this;
        }

        public Builder enableWorkspaceResolver(boolean enable) {
            this.injectWorkspaceResolver = enable;
            return this;
        }

        public MavenRuntimeLaunchSupport build(IProgressMonitor monitor) throws CoreException {
            File cwconfFile;
            AbstractMavenRuntime runtime = MavenLaunchUtils.getMavenRuntime(this.configuration);
            MavenLauncherConfigurationHandler cwconf = new MavenLauncherConfigurationHandler();
            runtime.createLauncherConfiguration((AbstractMavenRuntime.IMavenLauncherConfiguration)cwconf, monitor);
            if (this.injectWorkspaceResolver) {
                for (String entry : MavenLaunchUtils.getCliResolver(runtime)) {
                    cwconf.forceArchiveEntry(entry);
                }
            }
            try {
                Bundle bundle = FrameworkUtil.getBundle(MavenRuntimeLaunchSupport.class);
                File state = Platform.getStateLocation((Bundle)bundle).toFile();
                File dir = new File(state, "launches");
                dir.mkdirs();
                cwconfFile = File.createTempFile("m2conf", ".tmp", dir);
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileOutputStream os = new FileOutputStream(cwconfFile);){
                    cwconf.save(os);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)Messages.MavenLaunchDelegate_error_cannot_create_conf, (Throwable)e));
            }
            return new MavenRuntimeLaunchSupport(runtime, cwconf, cwconfFile, this.resolveWorkspaceArtifacts);
        }
    }

    public static class VMArguments {
        private final StringBuilder properties = new StringBuilder();

        public void append(String str) {
            if (str != null) {
                str = str.trim();
            }
            if (str != null && str.length() > 0) {
                if (this.properties.length() > 0) {
                    this.properties.append(' ');
                }
                this.properties.append(str);
            }
        }

        public void appendProperty(String key, String value) {
            this.append("-D" + key + "=" + value);
        }

        public String toString() {
            return this.properties.toString();
        }
    }
}

