/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.configuration.WorkspaceConfiguration;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

final class WorkspaceConfigurationPersistence {
    private static final String GRADLE_DISTRIBUTION = "gradle.distribution";
    private static final String GRADLE_USER_HOME = "gradle.user.home";
    private static final String JAVA_HOME = "java.home";
    private static final String GRADLE_OFFLINE_MODE = "gradle.offline.mode";
    private static final String GRADLE_BUILD_SCANS = "gradle.build.scans";
    private static final String GRADLE_AUTO_SYNC = "auto.sync";
    private static final String ARGUMENTS = "arguments";
    private static final String JVM_ARGUMENTS = "jvm.arguments";
    private static final String SHOW_CONSOLE_VIEW = "show.console.view";
    private static final String SHOW_EXECUTIONS_VIEW = "show.executions.view";
    private static final String EXPERIMENTAL_ENABLE_MODULE_SUPPORT = "experimental.module.support";
    private static final String PROBLEMS_API_SUPPORT = "problems.api.support";

    WorkspaceConfigurationPersistence() {
    }

    public WorkspaceConfiguration readWorkspaceConfig() {
        GradleDistribution distribution;
        IEclipsePreferences preferences = this.getPreferences();
        String distributionString = preferences.get(GRADLE_DISTRIBUTION, null);
        try {
            distribution = GradleDistribution.fromString(distributionString);
        }
        catch (RuntimeException ignore) {
            distribution = GradleDistribution.fromBuild();
        }
        String gradleUserHomeString = preferences.get(GRADLE_USER_HOME, null);
        File gradleUserHome = gradleUserHomeString == null ? null : new File(gradleUserHomeString);
        String javaHomeString = preferences.get(JAVA_HOME, null);
        File javaHome = javaHomeString == null ? null : new File(javaHomeString);
        boolean offlineMode = preferences.getBoolean(GRADLE_OFFLINE_MODE, false);
        boolean buildScansEnabled = preferences.getBoolean(GRADLE_BUILD_SCANS, false);
        boolean autoSyncEnabled = preferences.getBoolean(GRADLE_AUTO_SYNC, false);
        String argumentsString = preferences.get(ARGUMENTS, "");
        List arguments = Splitter.on((String)File.pathSeparator).omitEmptyStrings().splitToList((CharSequence)argumentsString);
        String jvmArgumentsString = preferences.get(JVM_ARGUMENTS, "");
        List jvmArguments = Splitter.on((String)File.pathSeparator).omitEmptyStrings().splitToList((CharSequence)jvmArgumentsString);
        boolean showConsoleView = preferences.getBoolean(SHOW_CONSOLE_VIEW, true);
        boolean showExecutionsView = preferences.getBoolean(SHOW_EXECUTIONS_VIEW, true);
        boolean moduleSupport = preferences.getBoolean(EXPERIMENTAL_ENABLE_MODULE_SUPPORT, false);
        boolean problemsApiSupport = preferences.getBoolean(PROBLEMS_API_SUPPORT, false);
        return new WorkspaceConfiguration(distribution, gradleUserHome, javaHome, offlineMode, buildScansEnabled, autoSyncEnabled, arguments, jvmArguments, showConsoleView, showExecutionsView, moduleSupport, problemsApiSupport);
    }

    public void saveWorkspaceConfiguration(WorkspaceConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        IEclipsePreferences preferences = this.getPreferences();
        preferences.put(GRADLE_DISTRIBUTION, config.getGradleDistribution().toString());
        if (config.getGradleUserHome() == null) {
            preferences.remove(GRADLE_USER_HOME);
        } else {
            preferences.put(GRADLE_USER_HOME, config.getGradleUserHome().getPath());
        }
        if (config.getJavaHome() == null) {
            preferences.remove(JAVA_HOME);
        } else {
            preferences.put(JAVA_HOME, config.getJavaHome().getPath());
        }
        preferences.putBoolean(GRADLE_OFFLINE_MODE, config.isOffline());
        preferences.putBoolean(GRADLE_BUILD_SCANS, config.isBuildScansEnabled());
        preferences.putBoolean(GRADLE_AUTO_SYNC, config.isAutoSync());
        preferences.put(ARGUMENTS, Joiner.on((String)File.pathSeparator).join(config.getArguments()));
        preferences.put(JVM_ARGUMENTS, Joiner.on((String)File.pathSeparator).join(config.getJvmArguments()));
        preferences.putBoolean(SHOW_CONSOLE_VIEW, config.isShowConsoleView());
        preferences.putBoolean(SHOW_EXECUTIONS_VIEW, config.isShowExecutionsView());
        preferences.putBoolean(EXPERIMENTAL_ENABLE_MODULE_SUPPORT, config.isExperimentalModuleSupportEnabled());
        preferences.putBoolean(PROBLEMS_API_SUPPORT, config.isProblemsApiSupportEnabled());
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new GradlePluginsRuntimeException("Could not persist workspace preferences", e);
        }
    }

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.buildship.core");
    }
}

