/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.swt.graphics.Image;

public final class RefactoringDescriptorCompareInput
extends PlatformObject
implements ICompareInput {
    private static boolean fImageRegistered = false;
    private static final String TYPE_REFACTORING_DESCRIPTOR = "refactoring_descriptor";
    private final RefactoringDescriptorProxy fDescriptor;
    private final int fKind;

    public RefactoringDescriptorCompareInput(RefactoringDescriptorProxy descriptor, int kind) {
        Assert.isNotNull((Object)descriptor);
        this.fDescriptor = descriptor;
        this.fKind = kind;
        if (!fImageRegistered) {
            CompareUI.registerImageDescriptor((String)TYPE_REFACTORING_DESCRIPTOR, (ImageDescriptor)RefactoringPluginImages.DESC_OBJS_REFACTORING);
            fImageRegistered = true;
        }
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void copy(boolean leftToRight) {
    }

    public ITypedElement getAncestor() {
        return new RefactoringDescriptorElement();
    }

    public RefactoringDescriptorProxy getDescriptor() {
        return this.fDescriptor;
    }

    public Image getImage() {
        return CompareUI.getImage((String)TYPE_REFACTORING_DESCRIPTOR);
    }

    public int getKind() {
        return this.fKind;
    }

    public ITypedElement getLeft() {
        return new RefactoringDescriptorElement();
    }

    public String getName() {
        return this.fDescriptor.getDescription();
    }

    public ITypedElement getRight() {
        return new RefactoringDescriptorElement();
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    private final class RefactoringDescriptorElement
    implements ITypedElement {
        private RefactoringDescriptorElement() {
        }

        public Image getImage() {
            return RefactoringDescriptorCompareInput.this.getImage();
        }

        public String getName() {
            RefactoringDescriptorProxy refactoringDescriptorProxy = RefactoringDescriptorCompareInput.this.fDescriptor;
            if (refactoringDescriptorProxy instanceof RefactoringDescriptorSynchronizationProxy) {
                RefactoringDescriptorSynchronizationProxy proxy = (RefactoringDescriptorSynchronizationProxy)refactoringDescriptorProxy;
                if (proxy.getDirection() == 512) {
                    return ModelMessages.RefactoringDescriptorCompareInput_pending_refactoring;
                }
                return ModelMessages.RefactoringDescriptorCompareInput_performed_refactoring;
            }
            return RefactoringUIMessages.RefactoringWizard_refactoring;
        }

        public String getType() {
            return RefactoringDescriptorCompareInput.TYPE_REFACTORING_DESCRIPTOR;
        }
    }
}

