/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.DiffContainerJob;
import org.eclipse.egit.ui.internal.ToolsUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.diffmerge.DiffMergeSettings;
import org.eclipse.egit.ui.internal.merge.GitMergeEditorInput;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.egit.ui.internal.merge.MergeModeDialog;
import org.eclipse.egit.ui.internal.preferences.GitPreferenceRoot;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.MergeTools;
import org.eclipse.jgit.internal.diffmergetool.PromptContinueHandler;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.osgi.util.NLS;

public class MergeToolActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitMergeEditorInput input;
        int mergeMode = Activator.getDefault().getPreferenceStore().getInt("merge_mode");
        IPath[] locations = this.getSelectedLocations(event);
        boolean useInternalMergeTool = DiffMergeSettings.useInternalMergeTool();
        if (useInternalMergeTool) {
            if (mergeMode == 0) {
                MergeModeDialog dlg = new MergeModeDialog(this.getShell(event));
                if (dlg.open() != 0) {
                    return null;
                }
                input = new GitMergeEditorInput(dlg.getMergeMode(), locations);
            } else {
                MergeInputMode mode = MergeInputMode.fromInteger(mergeMode);
                input = new GitMergeEditorInput(mode, locations);
            }
        } else {
            input = new GitMergeEditorInput(MergeInputMode.STAGE_2, locations);
        }
        if (useInternalMergeTool) {
            MergeToolActionHandler.openMergeToolInternal(input);
        } else {
            MergeToolActionHandler.openMergeToolExternal(input);
        }
        return null;
    }

    private static void openMergeToolInternal(CompareEditorInput input) {
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    private static void openMergeToolExternal(CompareEditorInput input) throws ExecutionException {
        GitMergeEditorInput gitMergeInput = (GitMergeEditorInput)input;
        DiffContainerJob job = new DiffContainerJob(UIText.MergeToolActionHandler_openExternalMergeToolJobName, gitMergeInput);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ExecutionException(UIText.MergeToolActionHandler_openExternalMergeToolWaitInterrupted, (Throwable)e);
        }
        IDiffContainer diffCont = job.getDiffContainer();
        MergeToolActionHandler.executeExternalToolForChildren(diffCont, job.getRepository());
    }

    private static void executeExternalToolForChildren(IDiffContainer diffCont, Repository repo) throws ExecutionException {
        if (diffCont != null && diffCont.hasChildren()) {
            IDiffElement[] difContChilds;
            IDiffElement[] iDiffElementArray = difContChilds = diffCont.getChildren();
            int n = difContChilds.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement diffElement = iDiffElementArray[n2];
                int diffKind = diffElement.getKind();
                if (diffKind == 0) {
                    MergeToolActionHandler.executeExternalToolForChildren((IDiffContainer)diffElement, repo);
                } else if ((diffKind & 0xC) != 0) {
                    try {
                        MergeToolActionHandler.mergeModified((DiffNode)diffElement, repo);
                    }
                    catch (IOException | CoreException e) {
                        throw new ExecutionException(UIText.MergeToolActionHandler_externalMergeToolRunFailed, e);
                    }
                }
                ++n2;
            }
        }
    }

    private static void mergeModified(DiffNode node, Repository repo) throws IOException, CoreException {
        long modifiedAfter2;
        ResourceEditableRevision leftRevision = (ResourceEditableRevision)node.getLeft();
        IResource leftResource = ((ResourceEditableRevision)node.getLeft()).getResource();
        FileRevisionTypedElement rightRevision = (FileRevisionTypedElement)node.getRight();
        FileRevisionTypedElement baseRevision = (FileRevisionTypedElement)node.getAncestor();
        String mergedFilePath = null;
        Repository repository = repo;
        if (leftResource != null) {
            IPath relativePath = ResourceUtil.getRepositoryRelativePath((IPath)leftResource.getRawLocation(), (Repository)repository);
            mergedFilePath = relativePath == null ? leftResource.getName() : relativePath.toOSString();
        } else if (leftRevision != null) {
            mergedFilePath = leftRevision.getPath();
        }
        boolean isMergeSuccessful = true;
        FileElement merged = new FileElement(mergedFilePath, FileElement.Type.MERGED, repository.getWorkTree());
        long modifiedBefore = merged.getFile().lastModified();
        try {
            MergeTools mergeTools = new MergeTools(repository);
            Optional<String> toolNameToUse = DiffMergeSettings.getMergeToolName(repository, mergedFilePath);
            BooleanTriState prompt = BooleanTriState.FALSE;
            FileNamePromptContinueHandler promptContinueHandler = new FileNamePromptContinueHandler(mergedFilePath);
            File tempDir = mergeTools.createTempDirectory();
            File tempFilesParent = tempDir != null ? tempDir : repository.getWorkTree();
            FileElement local = MergeToolActionHandler.createFileElement(leftRevision, mergedFilePath, FileElement.Type.LOCAL, repository, tempFilesParent, true);
            FileElement remote = MergeToolActionHandler.createFileElement(rightRevision, mergedFilePath, FileElement.Type.REMOTE, repository, tempFilesParent, false);
            FileElement base = MergeToolActionHandler.createFileElement(baseRevision, mergedFilePath, FileElement.Type.BASE, repository, tempFilesParent, false);
            mergeTools.merge(local, remote, merged, base, tempDir, toolNameToUse, prompt, false, (PromptContinueHandler)promptContinueHandler, tools -> ToolsUtils.informUser(UIText.MergeToolActionHandler_noToolConfiguredDialogTitle, UIText.MergeToolActionHandler_noToolConfiguredDialogContent));
        }
        catch (ToolException e) {
            isMergeSuccessful = false;
            if (e.isCommandExecutionError()) {
                Activator.handleError(UIText.MergeToolActionHandler_mergeToolErrorDialogContent, e, true);
                return;
            }
            Activator.logWarning("Failed to run external merge tool.", e);
        }
        if (isMergeSuccessful && modifiedBefore == (modifiedAfter2 = merged.getFile().lastModified())) {
            int response = ToolsUtils.askUserAboutToolExecution(UIText.MergeToolActionHandler_mergeToolNoChangeDialogTitle, NLS.bind((String)UIText.MergeToolActionHandler_mergeToolNoChangeDialogContent, (Object)mergedFilePath));
            if (response == 128) {
                isMergeSuccessful = false;
            } else if (response == 256) {
                return;
            }
        }
        if (isMergeSuccessful && GitPreferenceRoot.autoAddToIndex()) {
            try {
                Throwable modifiedAfter2 = null;
                Object var13_18 = null;
                try (Git git = new Git(repository);){
                    git.add().addFilepattern(mergedFilePath).call();
                    if (leftResource != null) {
                        leftResource.getParent().refreshLocal(1, null);
                    }
                }
                catch (Throwable throwable) {
                    if (modifiedAfter2 == null) {
                        modifiedAfter2 = throwable;
                    } else if (modifiedAfter2 != throwable) {
                        modifiedAfter2.addSuppressed(throwable);
                    }
                    throw modifiedAfter2;
                }
            }
            catch (GitAPIException e) {
                Activator.handleError(UIText.MergeToolActionHandler_mergeToolFailedAddMergedToGit, e, true);
            }
        }
    }

    private static FileElement createFileElement(FileRevisionTypedElement revision, String path, FileElement.Type type, Repository repository, File tempFilesParent, boolean createWorktreeElement) throws CoreException, IOException {
        FileElement element = null;
        if (revision != null) {
            element = new FileElement(path, type, null, revision.getContents());
            element.createTempFile(tempFilesParent);
        } else if (createWorktreeElement) {
            element = new FileElement(path, type, repository.getWorkTree());
        }
        return element;
    }

    @Override
    public boolean isEnabled() {
        IPath[] paths = this.getSelectedLocations();
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(paths));
        if (pathsByRepository.size() != 1) {
            return false;
        }
        Map.Entry pathsEntry = pathsByRepository.entrySet().iterator().next();
        Repository repo = (Repository)pathsEntry.getKey();
        Collection selectedRepoPaths = (Collection)pathsEntry.getValue();
        if (selectedRepoPaths.isEmpty()) {
            return false;
        }
        IndexDiffCacheEntry entry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repo);
        if (entry == null || entry.getIndexDiff() == null) {
            return false;
        }
        Set conflictingFiles = entry.getIndexDiff().getConflicting();
        if (conflictingFiles.isEmpty()) {
            return false;
        }
        for (String selectedRepoPath : selectedRepoPaths) {
            Path selectedPath = new Path(selectedRepoPath);
            for (String conflictingFile : conflictingFiles) {
                if (!selectedPath.isPrefixOf((IPath)new Path(conflictingFile))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean alwaysCheckEnabled() {
        return true;
    }

    private static class FileNamePromptContinueHandler
    implements PromptContinueHandler {
        private final String fileName;

        public FileNamePromptContinueHandler(String fileName) {
            this.fileName = fileName;
        }

        public boolean prompt(String toolName) {
            int response = ToolsUtils.askUserAboutToolExecution(UIText.MergeToolActionHandler_mergeToolPromptDialogTitle, NLS.bind((String)UIText.MergeToolActionHandler_mergeToolPromptDialogContent, (Object)this.fileName, (Object)toolName));
            return response == 64;
        }
    }
}

