/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jgit.annotations.NonNull;

public final class KnownHosts {
    private static final String KNOWN_HOSTS_KEY = "EGit.KnownHosts";
    private static final String[] DEFAULT_HOSTS = new String[]{"git.eclipse.org", "github.com", "bitbucket.org"};
    private static HostStore knownHosts;

    private KnownHosts() {
    }

    public static boolean isKnownHost(String hostName) {
        return hostName != null && KnownHosts.getKnownHosts().containsKey(hostName);
    }

    public static void addKnownHost(@NonNull String hostName) {
        KnownHosts.getKnownHosts().put(hostName, null);
        Activator.getDefault().getDialogSettings().put(KNOWN_HOSTS_KEY, knownHosts.keySet().toArray(new String[0]));
    }

    private static HostStore getKnownHosts() {
        if (knownHosts == null) {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            String[] values = settings.getArray(KNOWN_HOSTS_KEY);
            if (values == null) {
                settings.put(KNOWN_HOSTS_KEY, DEFAULT_HOSTS);
                values = DEFAULT_HOSTS;
            }
            knownHosts = new HostStore(values.length);
            int i = values.length - 1;
            while (i >= 0) {
                String host = values[i];
                if (host != null && !host.isEmpty()) {
                    knownHosts.put(host, null);
                }
                --i;
            }
        }
        return knownHosts;
    }

    private static class HostStore
    extends LinkedHashMap<String, String> {
        private static final int MAXIMUM_SIZE = 200;

        public HostStore(int size) {
            super(size < 10 ? 10 : size, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 200;
        }
    }
}

