/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.jfr;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.jfr.UniqueId;

@API(status=API.Status.INTERNAL, since="6.0")
class FlightRecordingExecutionListener
implements TestExecutionListener {
    private final Map<org.junit.platform.engine.UniqueId, TestExecutionEvent> testExecutionEvents = new ConcurrentHashMap<org.junit.platform.engine.UniqueId, TestExecutionEvent>();
    private @Nullable TestPlanExecutionEvent testPlanExecutionEvent;

    FlightRecordingExecutionListener() {
    }

    @Override
    public void testPlanExecutionStarted(TestPlan plan) {
        TestPlanExecutionEvent event = new TestPlanExecutionEvent();
        if (event.isEnabled()) {
            event.begin();
            this.testPlanExecutionEvent = event;
        }
    }

    @Override
    public void testPlanExecutionFinished(TestPlan plan) {
        TestPlanExecutionEvent event = this.testPlanExecutionEvent;
        this.testPlanExecutionEvent = null;
        if (event != null && event.shouldCommit()) {
            event.containsTests = plan.containsTests();
            event.engineNames = plan.getRoots().stream().map(TestIdentifier::getDisplayName).collect(Collectors.joining(", "));
            event.commit();
        }
    }

    @Override
    public void executionSkipped(TestIdentifier test, String reason) {
        SkippedTestEvent event = new SkippedTestEvent();
        if (event.shouldCommit()) {
            event.initialize(test);
            event.reason = reason;
            event.commit();
        }
    }

    @Override
    public void executionStarted(TestIdentifier test) {
        TestExecutionEvent event = new TestExecutionEvent();
        if (event.isEnabled()) {
            event.begin();
            this.testExecutionEvents.put(test.getUniqueIdObject(), event);
        }
    }

    @Override
    public void executionFinished(TestIdentifier test, TestExecutionResult result) {
        TestExecutionEvent event = this.testExecutionEvents.remove(test.getUniqueIdObject());
        if (event != null && event.shouldCommit()) {
            event.end();
            event.initialize(test);
            event.result = result.getStatus().toString();
            Optional throwable = result.getThrowable();
            event.exceptionClass = throwable.map(Object::getClass).orElse(null);
            event.exceptionMessage = throwable.map(Throwable::getMessage).orElse(null);
            event.commit();
        }
    }

    @Override
    public void reportingEntryPublished(TestIdentifier test, ReportEntry reportEntry) {
        for (Map.Entry entry : reportEntry.getKeyValuePairs().entrySet()) {
            ReportEntryEvent event = new ReportEntryEvent();
            if (!event.shouldCommit()) continue;
            event.uniqueId = test.getUniqueId();
            event.key = (String)entry.getKey();
            event.value = (String)entry.getValue();
            event.commit();
        }
    }

    @Override
    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry file) {
        FileEntryEvent event = new FileEntryEvent();
        if (event.shouldCommit()) {
            event.uniqueId = testIdentifier.getUniqueId();
            event.path = file.getPath().toAbsolutePath().toString();
            event.commit();
        }
    }

    @Label(value="Test Execution")
    @Name(value="org.junit.TestPlanExecution")
    static class TestPlanExecutionEvent
    extends ExecutionEvent {
        @Label(value="Contains Tests")
        boolean containsTests;
        @Label(value="Engine Names")
        @Nullable String engineNames;

        TestPlanExecutionEvent() {
        }
    }

    @Label(value="Skipped Test")
    @Name(value="org.junit.SkippedTest")
    static class SkippedTestEvent
    extends TestEvent {
        @Label(value="Reason")
        @Nullable String reason;

        SkippedTestEvent() {
        }
    }

    @Label(value="Test")
    @Name(value="org.junit.TestExecution")
    static class TestExecutionEvent
    extends TestEvent {
        @Label(value="Result")
        @Nullable String result;
        @Label(value="Exception Class")
        @Nullable Class<?> exceptionClass;
        @Label(value="Exception Message")
        @Nullable String exceptionMessage;

        TestExecutionEvent() {
        }
    }

    @Label(value="Report Entry")
    @Name(value="org.junit.ReportEntry")
    static class ReportEntryEvent
    extends ExecutionEvent {
        @UniqueId
        @Label(value="Unique Id")
        @Nullable String uniqueId;
        @Label(value="Key")
        @Nullable String key;
        @Label(value="Value")
        @Nullable String value;

        ReportEntryEvent() {
        }
    }

    @Label(value="File Entry")
    @Name(value="org.junit.FileEntry")
    static class FileEntryEvent
    extends ExecutionEvent {
        @UniqueId
        @Label(value="Unique Id")
        @Nullable String uniqueId;
        @Label(value="Path")
        @Nullable String path;

        FileEntryEvent() {
        }
    }

    static abstract class TestEvent
    extends ExecutionEvent {
        @UniqueId
        @Label(value="Unique Id")
        @Nullable String uniqueId;
        @Label(value="Display Name")
        @Nullable String displayName;
        @Label(value="Tags")
        @Nullable String tags;
        @Label(value="Type")
        @Nullable String type;

        TestEvent() {
        }

        void initialize(TestIdentifier test) {
            this.uniqueId = test.getUniqueId();
            this.displayName = test.getDisplayName();
            this.tags = test.getTags().isEmpty() ? null : test.getTags().toString();
            this.type = test.getType().name();
        }
    }

    @Category(value={"JUnit", "Execution"})
    @StackTrace(value=false)
    static abstract class ExecutionEvent
    extends Event {
        ExecutionEvent() {
        }
    }
}

