/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.AbstractMethodFilter;

class IncludeMethodFilter
extends AbstractMethodFilter {
    IncludeMethodFilter(String ... patterns) {
        super(patterns);
    }

    public FilterResult apply(TestDescriptor descriptor) {
        String methodName = this.getFullyQualifiedMethodNameFromDescriptor(descriptor);
        return this.findMatchingPattern(methodName).map(pattern -> FilterResult.included((String)this.formatInclusionReason(methodName, (Pattern)pattern))).orElseGet(() -> FilterResult.excluded((String)this.formatExclusionReason(methodName)));
    }

    private String formatInclusionReason(@Nullable String methodName, Pattern pattern) {
        return "Method name [%s] matches included pattern: '%s'".formatted(methodName, pattern);
    }

    private String formatExclusionReason(@Nullable String methodName) {
        return "Method name [%s] does not match any included pattern: %s".formatted(methodName, this.patternDescription);
    }

    public String toString() {
        return "%s that includes method names that match one of the following regular expressions: %s".formatted(this.getClass().getSimpleName(), this.patternDescription);
    }
}

