/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.internal.core.IUserAuthenticator;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.JSchLocation;
import org.eclipse.jsch.internal.core.NullUserAuthenticator;
import org.eclipse.jsch.internal.core.ResponsiveSocketFactory;
import org.eclipse.jsch.internal.core.UserInfoImpl;
import org.eclipse.jsch.internal.core.Utils;
import org.eclipse.osgi.util.NLS;

class JSchProvider
implements IJSchService {
    private static JSchProvider instance;

    JSchProvider() {
    }

    @Override
    public Session createSession(String host, int port, String username) throws JSchException {
        if (JSchCorePlugin.getPlugin().isNeedToLoadKnownHosts()) {
            JSchCorePlugin.getPlugin().loadKnownHosts();
        }
        if (JSchCorePlugin.getPlugin().isNeedToLoadKeys()) {
            JSchCorePlugin.getPlugin().loadPrivateKeys();
        }
        return Utils.createSession(JSchCorePlugin.getPlugin().getJSch(), username, host, port);
    }

    @Override
    public Session createSession(IJSchLocation location, UserInfo uinfo) throws JSchException {
        Session session = this.createSession(location.getHost(), location.getPort(), location.getUsername());
        if (uinfo == null) {
            IUserAuthenticator authenticator = this.getPluggedInAuthenticator();
            if (authenticator == null) {
                authenticator = new NullUserAuthenticator();
            }
            uinfo = new UserInfoImpl(location, authenticator, JSchCorePlugin.getPlugin().getTimeout() * 1000);
        }
        if (uinfo != null) {
            session.setUserInfo(uinfo);
        }
        return session;
    }

    public Session createSession(IJSchLocation location) throws JSchException {
        return this.createSession(location, null);
    }

    @Override
    public void connect(Session session, int timeout, IProgressMonitor monitor) throws JSchException {
        session.setSocketFactory((SocketFactory)new ResponsiveSocketFactory(monitor, timeout));
        UserInfo ui = session.getUserInfo();
        if (ui != null && ui instanceof UserInfoImpl) {
            ((UserInfoImpl)ui).aboutToConnect();
        }
        try {
            session.connect();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new JSchException("invalid server's version string");
        }
        catch (JSchException e) {
            if (this.isAuthenticationFailure(e) && ui != null && ui instanceof UserInfoImpl && this.hasPromptExceededTimeout(session) && ((UserInfoImpl)ui).incReuse() == 0) {
                String host = session.getHost();
                String user = session.getUserName();
                int port = session.getPort();
                session = Utils.createSession(this.getJSch(), user, host, port);
                session.setUserInfo(ui);
                session.setTimeout(timeout);
                this.connect(session, timeout, monitor);
                return;
            }
            if (session.isConnected()) {
                session.disconnect();
            }
            throw e;
        }
        if (ui != null && ui instanceof UserInfoImpl) {
            ((UserInfoImpl)ui).connectionMade();
        }
    }

    @Override
    public Proxy getProxyForHost(String host, String proxyType) {
        return Utils.getProxyForHost(host, proxyType);
    }

    public static IJSchService getInstance() {
        if (instance == null) {
            instance = new JSchProvider();
        }
        return instance;
    }

    @Override
    public void connect(Proxy proxy, String host, int port, int timeout, IProgressMonitor monitor) throws JSchException {
        try {
            proxy.connect((SocketFactory)new ResponsiveSocketFactory(monitor, timeout), host, port, timeout);
        }
        catch (JSchException e) {
            throw e;
        }
        catch (Exception e) {
            new JSchException(e.getMessage());
        }
    }

    private IUserAuthenticator getPluggedInAuthenticator() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(JSchCorePlugin.ID, "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            JSchCorePlugin.log(4, NLS.bind((String)"User autheticator {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IUserAuthenticator)config.createExecutableExtension("run");
        }
        catch (CoreException ex) {
            JSchCorePlugin.log(4, NLS.bind((String)"Unable to instantiate user authenticator {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    @Override
    public JSch getJSch() {
        return JSchCorePlugin.getPlugin().getJSch();
    }

    private boolean isAuthenticationFailure(JSchException ee) {
        return ee.getMessage().equals("Auth fail");
    }

    private boolean hasPromptExceededTimeout(Session session) {
        if (session.getUserInfo() == null || !(session.getUserInfo() instanceof UserInfoImpl)) {
            return false;
        }
        return ((UserInfoImpl)session.getUserInfo()).hasPromptExceededTimeout();
    }

    @Override
    public IJSchLocation getLocation(String user, String host, int port) {
        JSchLocation location = null;
        location = new JSchLocation(user, host, port);
        return location;
    }
}

