/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.commands.IStepFiltersHandler;
import org.eclipse.debug.core.model.IStepFilter;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.internal.core.StepFilter;
import org.eclipse.debug.internal.core.commands.DebugCommandRequest;

public class StepFilterManager
implements ILaunchListener {
    public static final String PREF_USE_STEP_FILTERS = DebugPlugin.getUniqueIdentifier() + ".USE_STEP_FILTERS";
    private List<StepFilter> stepFilters = null;

    protected StepFilterManager() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this);
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this);
    }

    @Override
    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    @Override
    public void launchChanged(ILaunch launch) {
        IStepFiltersHandler command = (IStepFiltersHandler)launch.getAdapter(IStepFiltersHandler.class);
        if (command != null) {
            command.execute(new DebugCommandRequest(new Object[]{launch}));
        }
    }

    public boolean isUseStepFilters() {
        return Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), PREF_USE_STEP_FILTERS, false, null);
    }

    public void setUseStepFilters(boolean useFilters) {
        ILaunch[] launchs;
        Preferences.setBoolean(DebugPlugin.getUniqueIdentifier(), PREF_USE_STEP_FILTERS, useFilters, null);
        ILaunch[] iLaunchArray = launchs = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launchs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.launchChanged(launch);
            ++n2;
        }
    }

    @Override
    public void launchRemoved(ILaunch launch) {
    }

    public IStepFilter[] getStepFilters(String modelIdentifier) {
        this.initialize();
        ArrayList select = new ArrayList();
        for (StepFilter extension : this.stepFilters) {
            Collections.addAll(select, extension.getStepFilters(modelIdentifier));
        }
        return select.toArray(new IStepFilter[select.size()]);
    }

    private synchronized void initialize() {
        if (this.stepFilters == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "stepFilters");
            IConfigurationElement[] extensions = point.getConfigurationElements();
            this.stepFilters = new ArrayList<StepFilter>();
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement extension = iConfigurationElementArray[n2];
                try {
                    this.stepFilters.add(new StepFilter(extension));
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
                ++n2;
            }
        }
    }
}

