/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

@API(status=API.Status.MAINTAINED, since="1.0", consumers={"org.junit.platform.engine.support.hierarchical"})
public interface Node<C extends EngineExecutionContext> {
    default public C prepare(C context) throws Exception {
        return context;
    }

    default public void cleanUp(C context) throws Exception {
    }

    default public SkipResult shouldBeSkipped(C context) throws Exception {
        return SkipResult.doNotSkip();
    }

    default public C before(C context) throws Exception {
        return context;
    }

    default public C execute(C context, DynamicTestExecutor dynamicTestExecutor) throws Exception {
        return context;
    }

    default public void after(C context) throws Exception {
    }

    @API(status=API.Status.STABLE, since="1.10")
    default public void around(C context, Invocation<C> invocation) throws Exception {
        invocation.invoke(context);
    }

    @API(status=API.Status.STABLE, since="1.10", consumers={"org.junit.platform.engine.support.hierarchical"})
    default public void nodeSkipped(C context, TestDescriptor testDescriptor, SkipResult result) {
    }

    @API(status=API.Status.STABLE, since="1.10", consumers={"org.junit.platform.engine.support.hierarchical"})
    default public void nodeFinished(C context, TestDescriptor testDescriptor, TestExecutionResult result) {
    }

    @API(status=API.Status.STABLE, since="1.10", consumers={"org.junit.platform.engine.support.hierarchical"})
    default public Set<ExclusiveResource> getExclusiveResources() {
        return Collections.emptySet();
    }

    @API(status=API.Status.STABLE, since="1.10", consumers={"org.junit.platform.engine.support.hierarchical"})
    default public ExecutionMode getExecutionMode() {
        return ExecutionMode.CONCURRENT;
    }

    public static class SkipResult {
        private static final SkipResult alwaysExecuteSkipResult = new SkipResult(false, null);
        private final boolean skipped;
        private final Optional<String> reason;

        public static SkipResult skip(@Nullable String reason) {
            return new SkipResult(true, reason);
        }

        public static SkipResult doNotSkip() {
            return alwaysExecuteSkipResult;
        }

        private SkipResult(boolean skipped, @Nullable String reason) {
            this.skipped = skipped;
            this.reason = Optional.ofNullable(reason);
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public Optional<String> getReason() {
            return this.reason;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("skipped", (Object)this.skipped).append("reason", (Object)this.reason.orElse("<unknown>")).toString();
        }
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static interface Invocation<C extends EngineExecutionContext> {
        public void invoke(C var1) throws Exception;
    }

    @API(status=API.Status.STABLE, since="1.10", consumers={"org.junit.platform.engine.support.hierarchical"})
    public static enum ExecutionMode {
        SAME_THREAD,
        CONCURRENT;

    }

    public static interface DynamicTestExecutor {
        public void execute(TestDescriptor var1);

        @API(status=API.Status.STABLE, since="1.10")
        public Future<?> execute(TestDescriptor var1, EngineExecutionListener var2);

        public void awaitFinished() throws InterruptedException;
    }
}

