/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.highlight;

import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.DocumentOffsetAsyncCache;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.custom.StyledText;

public class HighlightReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IEclipsePreferences.IPreferenceChangeListener,
ITextViewerLifecycle {
    public static final String TOGGLE_HIGHLIGHT_PREFERENCE = "org.eclipse.ui.genericeditor.togglehighlight";
    public static final String READ_ANNOTATION_TYPE = "org.eclipse.lsp4e.read";
    public static final String WRITE_ANNOTATION_TYPE = "org.eclipse.lsp4e.write";
    public static final String TEXT_ANNOTATION_TYPE = "org.eclipse.lsp4e.text";
    private boolean enabled;
    private @Nullable ISourceViewer sourceViewer;
    private @Nullable IDocument document;
    private @Nullable Job highlightJob;
    private static final int HIGHLIGHT_DEBOUNCE_MS = 75;
    private static final DocumentOffsetAsyncCache<List<? extends DocumentHighlight>> HIGHLIGHT_CACHE = new DocumentOffsetAsyncCache(Duration.ofSeconds(10L));
    private int lastCacheKeyOffset = -1;
    private Annotation @Nullable [] fOccurrenceAnnotations = null;
    private EditorSelectionChangedListener editorSelectionChangedListener = (EditorSelectionChangedListener)NullSafetyHelper.lateNonNull();
    private List<CompletableFuture<@Nullable List<? extends DocumentHighlight>>> requests = List.of();

    private void updateHighlights(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            if (this.highlightJob != null) {
                this.highlightJob.cancel();
            }
            long timestamp = DocumentUtil.getDocumentModificationStamp(this.document);
            this.highlightJob = Job.createSystem((String)"LSP4E Highlight", monitor -> this.collectHighlights(textSelection.getOffset(), timestamp, monitor));
            this.highlightJob.schedule(75L);
        }
    }

    public void install(ITextViewer viewer) {
        if (viewer instanceof ISourceViewer) {
            ISourceViewer thisSourceViewer = (ISourceViewer)viewer;
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
            preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.enabled = preferences.getBoolean(TOGGLE_HIGHLIGHT_PREFERENCE, true);
            this.sourceViewer = thisSourceViewer;
            this.editorSelectionChangedListener = new EditorSelectionChangedListener();
            this.editorSelectionChangedListener.install(thisSourceViewer.getSelectionProvider());
        }
    }

    public void uninstall() {
        this.removeOccurrenceAnnotations();
        if (this.sourceViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.cancel();
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        ISourceViewer sourceViewer = this.sourceViewer;
        if (sourceViewer != null) {
            ISelectionProvider selectionProvider = sourceViewer.getSelectionProvider();
            StyledText textWidget = sourceViewer.getTextWidget();
            if (textWidget != null) {
                textWidget.getDisplay().asyncExec(() -> {
                    if (!textWidget.isDisposed()) {
                        this.updateHighlights(selectionProvider.getSelection());
                    }
                });
            }
        }
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    private void collectHighlights(int caretOffset, long timestamp, @Nullable IProgressMonitor monitor) {
        Position position;
        ISourceViewer sourceViewer = this.sourceViewer;
        IDocument document = this.document;
        if (sourceViewer == null || document == null || !this.enabled || monitor != null && monitor.isCanceled()) {
            return;
        }
        int cacheKeyOffset = HighlightReconcilingStrategy.normalizedOffset(document, caretOffset);
        if (cacheKeyOffset != this.lastCacheKeyOffset) {
            this.cancel();
            this.lastCacheKeyOffset = cacheKeyOffset;
        }
        if (DocumentUtil.getDocumentModificationStamp(document) != timestamp) {
            return;
        }
        try {
            position = LSPEclipseUtils.toPosition(caretOffset, document);
        }
        catch (BadLocationException e) {
            if (DocumentUtil.getDocumentModificationStamp(document) == timestamp) {
                LanguageServerPlugin.logError(e);
            }
            return;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return;
        }
        TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(uri);
        DocumentHighlightParams params = new DocumentHighlightParams(identifier, position);
        CompletableFuture<List<? extends DocumentHighlight>> request = HIGHLIGHT_CACHE.computeIfAbsent(document, cacheKeyOffset, () -> {
            this.requests = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDocumentHighlightProvider)).computeAll(ls -> ls.getTextDocumentService().documentHighlight(params));
            List reqs = this.requests;
            return CompletableFuture.supplyAsync(() -> reqs.stream().map(CompletableFuture::join).filter(Objects::nonNull).flatMap(Collection::stream).toList());
        });
        request.thenAcceptAsync(highlights -> {
            if (monitor == null || !monitor.isCanceled()) {
                this.updateAnnotations((List<? extends DocumentHighlight>)highlights, sourceViewer.getAnnotationModel());
            }
        });
    }

    private void cancel() {
        this.requests.forEach(request -> {
            boolean bl = request.cancel(true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotations(@Nullable List<? extends DocumentHighlight> highlights, IAnnotationModel annotationModel) {
        IDocument document = this.document;
        if (highlights == null || document == null) {
            return;
        }
        HashMap<Annotation, org.eclipse.jface.text.Position> annotationMap = new HashMap<Annotation, org.eclipse.jface.text.Position>(highlights.size());
        for (DocumentHighlight object : highlights) {
            try {
                int start = LSPEclipseUtils.toOffset(object.getRange().getStart(), document);
                int end = LSPEclipseUtils.toOffset(object.getRange().getEnd(), document);
                annotationMap.put(new Annotation(this.kindToAnnotationType(object.getKind()), false, null), new org.eclipse.jface.text.Position(start, end - start));
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)annotationModel;
                modelExtension.replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
            } else {
                this.removeOccurrenceAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (org.eclipse.jface.text.Position)mapEntry.getValue());
                }
            }
            this.fOccurrenceAnnotations = (Annotation[])annotationMap.keySet().toArray(Annotation[]::new);
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        ISynchronizable sync;
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = (sync = (ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private static int normalizedOffset(IDocument document, int offset) {
        try {
            int pos = Math.max(0, offset - 1);
            int docLen = document.getLength();
            while (pos >= 0 && pos < docLen) {
                if (!Character.isUnicodeIdentifierPart(document.getChar(pos))) break;
                --pos;
            }
            return Math.min(docLen, pos + 1);
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex.getMessage(), ex);
            return offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        ISourceViewer sourceViewer = this.sourceViewer;
        if (sourceViewer == null) {
            return;
        }
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        Annotation[] fOccurrenceAnnotations = this.fOccurrenceAnnotations;
        if (annotationModel == null || fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)annotationModel;
                modelExtension.replaceAnnotations(fOccurrenceAnnotations, null);
            } else {
                Annotation[] annotationArray = fOccurrenceAnnotations;
                int n = fOccurrenceAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation fOccurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(fOccurrenceAnnotation);
                    ++n2;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private String kindToAnnotationType(@Nullable DocumentHighlightKind kind) {
        if (kind == null) {
            return TEXT_ANNOTATION_TYPE;
        }
        return switch (kind) {
            case DocumentHighlightKind.Read -> READ_ANNOTATION_TYPE;
            case DocumentHighlightKind.Write -> WRITE_ANNOTATION_TYPE;
            default -> TEXT_ANNOTATION_TYPE;
        };
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(TOGGLE_HIGHLIGHT_PREFERENCE)) {
            this.enabled = Boolean.parseBoolean(String.valueOf(event.getNewValue()));
            if (this.enabled) {
                this.initialReconcile();
            } else {
                this.removeOccurrenceAnnotations();
            }
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, @Nullable IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(@Nullable ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(@Nullable ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            HighlightReconcilingStrategy.this.updateHighlights(event.getSelection());
        }
    }
}

