/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.util.SecurityManager;

public class LSPSecurityManager {
    private static final Logger LOGGER = Logger.getLogger(LSPSecurityManager.class.getName());
    private static final String ENTITY_EXPANSION_LIMIT_PROPERTY_NAME = "jdk.xml.entityExpansionLimit";
    private static final String MAX_OCCUR_LIMIT_PROPERTY_NAME = "jdk.xml.maxOccur";
    private static final int ENTITY_EXPANSION_LIMIT_DEFAULT_VALUE = 64000;
    private static final int MAX_OCCUR_LIMIT_DEFAULT_VALUE = 5000;

    public static SecurityManager getSecurityManager() {
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(LSPSecurityManager.getPropertyValue(ENTITY_EXPANSION_LIMIT_PROPERTY_NAME, 64000));
        securityManager.setMaxOccurNodeLimit(LSPSecurityManager.getPropertyValue(MAX_OCCUR_LIMIT_PROPERTY_NAME, 5000));
        return securityManager;
    }

    private static int getPropertyValue(String propertyName, int defaultValue) {
        String value = System.getProperty(propertyName, "");
        if (!value.isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error while getting system property '" + propertyName + "'.", e);
            }
        }
        return defaultValue;
    }
}

