/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities.participants;

import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.entities.EntitiesDocumentationUtils;
import org.eclipse.lemminx.services.extensions.hover.HoverParticipantAdapter;
import org.eclipse.lemminx.services.extensions.hover.IHoverRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;

public class EntitiesHoverParticipant
extends HoverParticipantAdapter {
    @Override
    public Hover onText(IHoverRequest request, CancelChecker cancelChecker) throws Exception {
        Range range;
        DOMNode node = request.getNode();
        if (!node.isText()) {
            return null;
        }
        DOMDocument document = request.getXMLDocument();
        int offset = request.getOffset();
        XMLPositionUtility.EntityReferenceRange entityRange = XMLPositionUtility.selectEntityReference(offset, document);
        if (entityRange == null) {
            return null;
        }
        String entityName = entityRange.getName();
        MarkupContent entityContents = EntitiesHoverParticipant.searchInEntities(entityName, range = entityRange.getRange(), document, request);
        if (entityContents != null) {
            return new Hover(entityContents, range);
        }
        return null;
    }

    private static MarkupContent searchInEntities(String entityName, Range entityRange, DOMDocument document, IHoverRequest request) {
        MarkupContent entityContents = EntitiesHoverParticipant.searchInPredefinedEntities(entityName, entityRange, document, request);
        if (entityContents != null) {
            return entityContents;
        }
        entityContents = EntitiesHoverParticipant.searchInLocalEntities(entityName, entityRange, document, request);
        if (entityContents != null) {
            return entityContents;
        }
        return EntitiesHoverParticipant.searchInExternalEntities(entityName, entityRange, document, request);
    }

    private static MarkupContent searchInPredefinedEntities(String entityName, Range entityRange, DOMDocument document, IHoverRequest request) {
        EntitiesDocumentationUtils.PredefinedEntity[] entities;
        for (EntitiesDocumentationUtils.PredefinedEntity entity : entities = EntitiesDocumentationUtils.PredefinedEntity.values()) {
            if (!entityName.equals(entity.getName())) continue;
            boolean markdown = request.canSupportMarkupKind("markdown");
            return EntitiesDocumentationUtils.getDocumentation(entity.getName(), entity.getValue(), EntitiesDocumentationUtils.EntityOriginType.PREDEFINED, markdown);
        }
        return null;
    }

    private static MarkupContent searchInLocalEntities(String entityName, Range entityRange, DOMDocument document, IHoverRequest request) {
        DOMDocumentType docType = document.getDoctype();
        if (docType == null) {
            return null;
        }
        NamedNodeMap entities = docType.getEntities();
        for (int i = 0; i < entities.getLength(); ++i) {
            DTDEntityDecl entity = (DTDEntityDecl)entities.item(i);
            if (!entityName.equals(entity.getName())) continue;
            boolean markdown = request.canSupportMarkupKind("markdown");
            return EntitiesDocumentationUtils.getDocumentation(entity, EntitiesDocumentationUtils.EntityOriginType.LOCAL, markdown);
        }
        return null;
    }

    private static MarkupContent searchInExternalEntities(String entityName, Range entityRange, DOMDocument document, IHoverRequest request) {
        ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
        Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(document, null, false);
        for (CMDocument cmDocument : cmDocuments) {
            List<Entity> entities = cmDocument.getEntities();
            for (Entity ent : entities) {
                DTDEntityDecl entity = (DTDEntityDecl)ent;
                if (!entityName.equals(entity.getName())) continue;
                boolean markdown = request.canSupportMarkupKind("markdown");
                return EntitiesDocumentationUtils.getDocumentation(entity, EntitiesDocumentationUtils.EntityOriginType.EXTERNAL, markdown);
            }
        }
        return null;
    }
}

