/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities.participants;

import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.entities.EntitiesDocumentationUtils;
import org.eclipse.lemminx.services.extensions.completion.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;

public class EntitiesCompletionParticipant
extends CompletionParticipantAdapter {
    @Override
    public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        XMLPositionUtility.EntityReferenceRange entityRange = XMLPositionUtility.selectEntityReference(request.getOffset(), request.getXMLDocument(), false);
        if (entityRange == null) {
            return;
        }
        Range range = entityRange.getRange();
        boolean markdown = request.canSupportMarkupKind("markdown");
        DOMDocument document = request.getXMLDocument();
        EntitiesCompletionParticipant.collectLocalEntityProposals(document, range, markdown, response);
        EntitiesCompletionParticipant.collectExternalEntityProposals(document, range, markdown, request, response);
        this.collectPredefinedEntityProposals(range, markdown, response);
    }

    private static void collectLocalEntityProposals(DOMDocument document, Range entityRange, boolean markdown, ICompletionResponse response) {
        DOMDocumentType docType = document.getDoctype();
        if (docType == null) {
            return;
        }
        NamedNodeMap entities = docType.getEntities();
        for (int i = 0; i < entities.getLength(); ++i) {
            Entity entity = (Entity)entities.item(i);
            if (entity.getNodeName() == null) continue;
            MarkupContent documentation = EntitiesDocumentationUtils.getDocumentation((DTDEntityDecl)entity, EntitiesDocumentationUtils.EntityOriginType.LOCAL, markdown);
            EntitiesCompletionParticipant.fillCompletion(entity.getNodeName(), documentation, entityRange, response);
        }
    }

    private static void collectExternalEntityProposals(DOMDocument document, Range entityRange, boolean markdown, ICompletionRequest request, ICompletionResponse response) {
        ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
        Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(document, null, false);
        for (CMDocument cmDocument : cmDocuments) {
            List<Entity> entities = cmDocument.getEntities();
            for (Entity entity : entities) {
                if (entity.getNodeName() == null) continue;
                MarkupContent documentation = EntitiesDocumentationUtils.getDocumentation((DTDEntityDecl)entity, EntitiesDocumentationUtils.EntityOriginType.EXTERNAL, markdown);
                EntitiesCompletionParticipant.fillCompletion(entity.getNodeName(), documentation, entityRange, response);
            }
        }
    }

    private void collectPredefinedEntityProposals(Range entityRange, boolean markdown, ICompletionResponse response) {
        EntitiesDocumentationUtils.PredefinedEntity[] entities;
        for (EntitiesDocumentationUtils.PredefinedEntity entity : entities = EntitiesDocumentationUtils.PredefinedEntity.values()) {
            MarkupContent documentation = EntitiesDocumentationUtils.getDocumentation(entity.getName(), entity.getValue(), EntitiesDocumentationUtils.EntityOriginType.PREDEFINED, markdown);
            EntitiesCompletionParticipant.fillCompletion(entity.getName(), documentation, entityRange, response);
        }
    }

    private static void fillCompletion(String name, MarkupContent documentation, Range entityRange, ICompletionResponse response) {
        String entityName = "&" + name + ";";
        CompletionItem item = new CompletionItem();
        item.setLabel(entityName);
        item.setKind(CompletionItemKind.Keyword);
        item.setInsertTextFormat(InsertTextFormat.PlainText);
        String insertText = entityName;
        item.setFilterText(insertText);
        item.setTextEdit(Either.forLeft(new TextEdit(entityRange, insertText)));
        item.setDocumentation(documentation);
        response.addCompletionItem(item);
    }
}

